/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.reflect;

import com.google.gson.JsonIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public abstract class ReflectionHelper {
    public static void makeAccessible(Field field) {
        try {
            field.setAccessible(true);
            return;
        }
        catch (Exception exception) {
            throw new JsonIOException("Failed making field '" + field.getDeclaringClass().getName() + "#" + field.getName() + "' accessible; either change its visibility or write a custom TypeAdapter for its declaring type", exception);
        }
    }

    private static String constructorToString(Constructor object) {
        Constructor constructor = object;
        object = new StringBuilder(((Constructor)object).getDeclaringClass().getName()).append('#').append(((Constructor)object).getDeclaringClass().getSimpleName()).append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append(classArray[i].getSimpleName());
        }
        return ((StringBuilder)object).append(')').toString();
    }

    public static String tryMakeAccessible(Constructor constructor) {
        try {
            constructor.setAccessible(true);
            return null;
        }
        catch (Exception exception) {
            return "Failed making constructor '" + ReflectionHelper.constructorToString(constructor) + "' accessible; either change its visibility or write a custom InstanceCreator or TypeAdapter for its declaring type: " + exception.getMessage();
        }
    }
}

