/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import kotlin.collections.EmptyIterator;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;

public final class EmptyList
implements List,
Serializable,
RandomAccess,
KMappedMarker {
    public static final EmptyList INSTANCE = new EmptyList();

    private EmptyList() {
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof List && ((List)object).isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public int getSize() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    public boolean contains(Void void_) {
        Intrinsics.checkNotNullParameter(void_, "element");
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        Collection collection2 = collection;
        Intrinsics.checkNotNullParameter(collection2, "elements");
        return collection2.isEmpty();
    }

    public Void get(int n) {
        throw new IndexOutOfBoundsException("Empty list doesn't contain element at index " + n + '.');
    }

    public int indexOf(Void void_) {
        Intrinsics.checkNotNullParameter(void_, "element");
        return -1;
    }

    public int lastIndexOf(Void void_) {
        Intrinsics.checkNotNullParameter(void_, "element");
        return -1;
    }

    @Override
    public Iterator iterator() {
        return EmptyIterator.INSTANCE;
    }

    public ListIterator listIterator() {
        return EmptyIterator.INSTANCE;
    }

    public ListIterator listIterator(int n) {
        if (n == 0) {
            return EmptyIterator.INSTANCE;
        }
        throw new IndexOutOfBoundsException("Index: " + n);
    }

    public List subList(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2);
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "array");
        return CollectionToArray.toArray(this, objectArray);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }
}

