/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.collections.builders.MapBuilder$Companion;
import kotlin.collections.builders.MapBuilder$EntriesItr;
import kotlin.collections.builders.MapBuilder$KeysItr;
import kotlin.collections.builders.MapBuilder$ValuesItr;
import kotlin.collections.builders.MapBuilderEntries;
import kotlin.collections.builders.MapBuilderKeys;
import kotlin.collections.builders.MapBuilderValues;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;

public final class MapBuilder
implements Map,
Serializable,
KMappedMarker {
    private static final MapBuilder$Companion Companion = new MapBuilder$Companion(null);
    private Object[] keysArray;
    private Object[] valuesArray;
    private int[] presenceArray;
    private int[] hashArray;
    private int maxProbeDistance;
    private int length;
    private int hashShift;
    private int size;
    private MapBuilderKeys keysView;
    private MapBuilderValues valuesView;
    private MapBuilderEntries entriesView;
    private boolean isReadOnly;

    private MapBuilder(Object[] objectArray, Object[] objectArray2, int[] nArray, int[] nArray2, int n, int n2) {
        MapBuilder mapBuilder = this;
        this.keysArray = objectArray;
        this.valuesArray = objectArray2;
        this.presenceArray = nArray;
        this.hashArray = nArray2;
        this.maxProbeDistance = n;
        mapBuilder.length = n2;
        mapBuilder.hashShift = MapBuilder$Companion.access$computeShift(Companion, this.getHashSize());
    }

    public MapBuilder() {
        this(8);
    }

    public MapBuilder(int n) {
        Object[] objectArray = objectArray2;
        int n2 = n;
        Object[] objectArray2 = ListBuilderKt.arrayOfUninitializedElements(n2);
        int[] nArray = new int[n2];
        Object[] objectArray3 = objectArray2;
        objectArray2 = new int[MapBuilder$Companion.access$computeHashSize(Companion, n)];
        super(objectArray3, null, nArray, (int[])objectArray2, 2, 0);
    }

    private final int getCapacity() {
        return this.keysArray.length;
    }

    private final int getHashSize() {
        return this.hashArray.length;
    }

    private final void ensureExtraCapacity(int n) {
        MapBuilder mapBuilder = this;
        mapBuilder.ensureCapacity(mapBuilder.length + n);
    }

    private final void ensureCapacity(int n) {
        if (n >= 0) {
            if (n > this.getCapacity()) {
                int n2 = this.getCapacity() * 3 / 2;
                if (n <= n2) {
                    n = n2;
                }
                MapBuilder mapBuilder = this;
                mapBuilder.keysArray = ListBuilderKt.copyOfUninitializedElements(mapBuilder.keysArray, n);
                Object object = mapBuilder.valuesArray;
                object = mapBuilder.valuesArray != null ? ListBuilderKt.copyOfUninitializedElements(object, n) : null;
                this.valuesArray = object;
                int[] nArray = Arrays.copyOf(this.presenceArray, n);
                Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(this, newSize)");
                this.presenceArray = nArray;
                n = MapBuilder$Companion.access$computeHashSize(Companion, n);
                if (n > this.getHashSize()) {
                    this.rehash(n);
                }
            } else if (this.length + n - this.size() > this.getCapacity()) {
                MapBuilder mapBuilder = this;
                mapBuilder.rehash(mapBuilder.getHashSize());
            }
            return;
        }
        throw new OutOfMemoryError();
    }

    private final Object[] allocateValuesArray() {
        Object[] objectArray = this.valuesArray;
        if (this.valuesArray != null) {
            return objectArray;
        }
        this.valuesArray = ListBuilderKt.arrayOfUninitializedElements(this.getCapacity());
        return this.valuesArray;
    }

    private final int hash(Object object) {
        return (object != null ? object.hashCode() : 0) * -1640531527 >>> this.hashShift;
    }

    private final void compact() {
        int n;
        int n2 = 0;
        Object[] objectArray = this.valuesArray;
        for (int i = 0; i < (n = this.length); ++i) {
            if (this.presenceArray[i] < 0) continue;
            this.keysArray[n2] = this.keysArray[i];
            if (objectArray != null) {
                objectArray[n2] = objectArray[i];
            }
            ++n2;
        }
        ListBuilderKt.resetRange(this.keysArray, n2, n);
        if (objectArray != null) {
            ListBuilderKt.resetRange(objectArray, n2, this.length);
        }
        this.length = n2;
    }

    private final void rehash(int n) {
        if (this.length > this.size()) {
            this.compact();
        }
        if (n != this.getHashSize()) {
            MapBuilder mapBuilder = this;
            mapBuilder.hashArray = new int[n];
            mapBuilder.hashShift = MapBuilder$Companion.access$computeShift(Companion, n);
        } else {
            n = this.getHashSize();
            ArraysKt.fill(this.hashArray, 0, 0, n);
        }
        n = 0;
        while (n < this.length) {
            if (this.putRehash(n++)) continue;
            throw new IllegalStateException("This cannot happen with fixed magic multiplier and grow-only hash array. Have object hashCodes changed?");
        }
    }

    private final boolean putRehash(int n) {
        MapBuilder mapBuilder = this;
        int n2 = mapBuilder.hash(mapBuilder.keysArray[n]);
        int n3 = mapBuilder.maxProbeDistance;
        while (true) {
            int[] nArray = this.hashArray;
            if (this.hashArray[n2] == 0) {
                nArray[n2] = n + 1;
                this.presenceArray[n] = n2;
                return true;
            }
            if ((n3 += -1) < 0) {
                return false;
            }
            int n4 = n2;
            n2 = n4 + -1;
            if (n4 != 0) continue;
            n2 = this.getHashSize() - 1;
        }
    }

    private final int findKey(Object object) {
        MapBuilder mapBuilder = this;
        int n = mapBuilder.hash(object);
        int n2 = mapBuilder.maxProbeDistance;
        int n3;
        while ((n3 = this.hashArray[n]) != 0) {
            if (n3 > 0 && Intrinsics.areEqual(this.keysArray[--n3], object)) {
                return n3;
            }
            if ((n2 += -1) < 0) {
                return -1;
            }
            int n4 = n;
            n = n4 + -1;
            if (n4 != 0) continue;
            n = this.getHashSize() - 1;
        }
        return -1;
    }

    private final int findValue(Object object) {
        int n = this.length;
        while ((n += -1) >= 0) {
            if (this.presenceArray[n] < 0) continue;
            Intrinsics.checkNotNull(this.valuesArray);
            if (!Intrinsics.areEqual(this.valuesArray[n], object)) continue;
            return n;
        }
        return -1;
    }

    private final void removeKeyAt(int n) {
        MapBuilder mapBuilder = this;
        ListBuilderKt.resetAt(mapBuilder.keysArray, n);
        mapBuilder.removeHashAt(mapBuilder.presenceArray[n]);
        mapBuilder.presenceArray[n] = -1;
        mapBuilder.size = mapBuilder.size() + -1;
    }

    private final void removeHashAt(int n) {
        int n2 = 0;
        int n3 = RangesKt.coerceAtMost(this.maxProbeDistance * 2, this.getHashSize() / 2);
        int n4 = n2;
        int n5 = n3;
        n2 = n;
        n3 = n4;
        do {
            int n6 = n;
            n = n6 + -1;
            if (n6 == 0) {
                n = this.getHashSize() - 1;
            }
            if (++n3 > this.maxProbeDistance) {
                this.hashArray[n2] = 0;
                return;
            }
            int[] nArray = this.hashArray;
            int n7 = this.hashArray[n];
            if (n7 == 0) {
                nArray[n2] = 0;
                return;
            }
            if (n7 < 0) {
                nArray[n2] = -1;
                n3 = n2 = 0;
                n2 = n;
                continue;
            }
            MapBuilder mapBuilder = this;
            int n8 = n7 - 1;
            if ((mapBuilder.hash(mapBuilder.keysArray[n8]) - n & this.getHashSize() - 1) < n3) continue;
            MapBuilder mapBuilder2 = this;
            mapBuilder2.hashArray[n2] = n7;
            mapBuilder2.presenceArray[n8] = n2;
            n3 = n2 = 0;
            n2 = n;
        } while ((n5 += -1) >= 0);
        this.hashArray[n2] = -1;
    }

    private final boolean contentEquals(Map map) {
        return this.size() == map.size() && this.containsAllEntries$kotlin_stdlib(map.entrySet());
    }

    private final boolean putEntry(Map.Entry entry) {
        int n = objectArray.addKey$kotlin_stdlib(entry.getKey());
        Object[] objectArray = objectArray.allocateValuesArray();
        if (n >= 0) {
            objectArray[n] = entry.getValue();
            return true;
        }
        n = -n - 1;
        Object object = objectArray[n];
        if (!Intrinsics.areEqual(entry.getValue(), object)) {
            objectArray[n] = entry.getValue();
            return true;
        }
        return false;
    }

    private final boolean putAllEntries(Collection object) {
        if (object.isEmpty()) {
            return false;
        }
        this.ensureExtraCapacity(object.size());
        object = object.iterator();
        boolean bl = false;
        while (object.hasNext()) {
            if (!this.putEntry((Map.Entry)object.next())) continue;
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ int access$getLength$p(MapBuilder mapBuilder) {
        return mapBuilder.length;
    }

    public static final /* synthetic */ int[] access$getPresenceArray$p(MapBuilder mapBuilder) {
        return mapBuilder.presenceArray;
    }

    public static final /* synthetic */ void access$removeKeyAt(MapBuilder mapBuilder, int n) {
        mapBuilder.removeKeyAt(n);
    }

    public static final /* synthetic */ Object[] access$getKeysArray$p(MapBuilder mapBuilder) {
        return mapBuilder.keysArray;
    }

    public static final /* synthetic */ Object[] access$getValuesArray$p(MapBuilder mapBuilder) {
        return mapBuilder.valuesArray;
    }

    public static final /* synthetic */ Object[] access$allocateValuesArray(MapBuilder mapBuilder) {
        return mapBuilder.allocateValuesArray();
    }

    public int getSize() {
        return this.size;
    }

    public final Map build() {
        MapBuilder mapBuilder = this;
        mapBuilder.checkIsMutable$kotlin_stdlib();
        mapBuilder.isReadOnly = true;
        return mapBuilder;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findKey(object) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.findValue(object) >= 0;
    }

    public Object get(Object object) {
        int n = this.findKey(object);
        if (n < 0) {
            return null;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        return this.valuesArray[n];
    }

    public Object put(Object object, Object object2) {
        objectArray.checkIsMutable$kotlin_stdlib();
        int n = objectArray.addKey$kotlin_stdlib(object);
        Object[] objectArray = objectArray.allocateValuesArray();
        if (n < 0) {
            n = -n - 1;
            objectArray[n] = object2;
            return objectArray[n];
        }
        objectArray[n] = object2;
        return null;
    }

    public void putAll(Map map) {
        Intrinsics.checkNotNullParameter(map, "from");
        this.checkIsMutable$kotlin_stdlib();
        this.putAllEntries(map.entrySet());
    }

    public Object remove(Object object) {
        int n = objectArray.removeKey$kotlin_stdlib(object);
        if (n < 0) {
            return null;
        }
        Object[] objectArray = objectArray.valuesArray;
        Intrinsics.checkNotNull(objectArray);
        Object object2 = objectArray.valuesArray[n];
        ListBuilderKt.resetAt(objectArray, n);
        return object2;
    }

    @Override
    public void clear() {
        this.checkIsMutable$kotlin_stdlib();
        Object[] objectArray = new IntRange(0, this.length - 1).iterator();
        while (objectArray.hasNext()) {
            int n = objectArray.nextInt();
            int[] nArray = this.presenceArray;
            int n2 = this.presenceArray[n];
            if (n2 < 0) continue;
            this.hashArray[n2] = 0;
            nArray[n] = -1;
        }
        MapBuilder mapBuilder = this;
        ListBuilderKt.resetRange(mapBuilder.keysArray, 0, this.length);
        objectArray = mapBuilder.valuesArray;
        if (mapBuilder.valuesArray != null) {
            ListBuilderKt.resetRange(objectArray, 0, this.length);
        }
        MapBuilder mapBuilder2 = this;
        mapBuilder2.size = 0;
        mapBuilder2.length = 0;
    }

    public Set getKeys() {
        MapBuilderKeys mapBuilderKeys = this.keysView;
        if (mapBuilderKeys == null) {
            MapBuilderKeys mapBuilderKeys2;
            mapBuilderKeys = mapBuilderKeys2;
            mapBuilderKeys2 = new MapBuilderKeys(this);
            this.keysView = mapBuilderKeys;
        }
        return mapBuilderKeys;
    }

    public Collection getValues() {
        MapBuilderValues mapBuilderValues = this.valuesView;
        if (mapBuilderValues == null) {
            MapBuilderValues mapBuilderValues2;
            mapBuilderValues = mapBuilderValues2;
            mapBuilderValues2 = new MapBuilderValues(this);
            this.valuesView = mapBuilderValues;
        }
        return mapBuilderValues;
    }

    public Set getEntries() {
        MapBuilderEntries mapBuilderEntries = this.entriesView;
        if (mapBuilderEntries == null) {
            MapBuilderEntries mapBuilderEntries2;
            mapBuilderEntries = mapBuilderEntries2;
            mapBuilderEntries(this);
            this.entriesView = mapBuilderEntries;
            return mapBuilderEntries2;
        }
        return mapBuilderEntries;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof Map && this.contentEquals((Map)object);
    }

    @Override
    public int hashCode() {
        int n = 0;
        MapBuilder$EntriesItr mapBuilder$EntriesItr = this.entriesIterator$kotlin_stdlib();
        while (mapBuilder$EntriesItr.hasNext()) {
            n += mapBuilder$EntriesItr.nextHashCode$kotlin_stdlib();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder(this.size() * 3 + 2).append("{");
        int n = 0;
        MapBuilder$EntriesItr mapBuilder$EntriesItr = this.entriesIterator$kotlin_stdlib();
        while (mapBuilder$EntriesItr.hasNext()) {
            if (n > 0) {
                stringBuilder2.append(", ");
            }
            mapBuilder$EntriesItr.nextAppendString(stringBuilder2);
            ++n;
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("}");
        String string = stringBuilder3.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    public final void checkIsMutable$kotlin_stdlib() {
        if (!this.isReadOnly) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    public final int addKey$kotlin_stdlib(Object object) {
        this.checkIsMutable$kotlin_stdlib();
        block0: while (true) {
            MapBuilder mapBuilder = this;
            int n = mapBuilder.hash(object);
            int n2 = RangesKt.coerceAtMost(mapBuilder.maxProbeDistance * 2, this.getHashSize() / 2);
            int n3 = 0;
            while (true) {
                int n4;
                if ((n4 = this.hashArray[n]) <= 0) {
                    if (this.length >= this.getCapacity()) {
                        this.ensureExtraCapacity(1);
                        continue block0;
                    }
                    MapBuilder mapBuilder2 = this;
                    n2 = mapBuilder2.length;
                    mapBuilder2.length = n4 = n2 + 1;
                    mapBuilder2.keysArray[n2] = object;
                    mapBuilder2.presenceArray[n2] = n;
                    mapBuilder2.hashArray[n] = n4;
                    mapBuilder2.size = mapBuilder2.size() + 1;
                    if (n3 > mapBuilder2.maxProbeDistance) {
                        this.maxProbeDistance = n3;
                    }
                    return n2;
                }
                if (Intrinsics.areEqual(this.keysArray[n4 - 1], object)) {
                    return -n4;
                }
                if (++n3 > n2) {
                    MapBuilder mapBuilder3 = this;
                    mapBuilder3.rehash(mapBuilder3.getHashSize() * 2);
                    continue block0;
                }
                int n5 = n;
                n = n5 + -1;
                if (n5 != 0) continue;
                n = this.getHashSize() - 1;
            }
            break;
        }
    }

    public final int removeKey$kotlin_stdlib(Object object) {
        MapBuilder mapBuilder = this;
        mapBuilder.checkIsMutable$kotlin_stdlib();
        int n = mapBuilder.findKey(object);
        if (n < 0) {
            return -1;
        }
        this.removeKeyAt(n);
        return n;
    }

    public final boolean containsEntry$kotlin_stdlib(Map.Entry entry) {
        Map.Entry entry2 = entry;
        Intrinsics.checkNotNullParameter(entry2, "entry");
        int n = this.findKey(entry2.getKey());
        if (n < 0) {
            return false;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        return Intrinsics.areEqual(this.valuesArray[n], entry.getValue());
    }

    public final boolean containsAllEntries$kotlin_stdlib(Collection object) {
        Collection collection = object;
        Intrinsics.checkNotNullParameter(collection, "m");
        for (Object e : collection) {
            if (e != null) {
                try {
                    if (this.containsEntry$kotlin_stdlib((Map.Entry)e)) continue;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public final boolean removeEntry$kotlin_stdlib(Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        this.checkIsMutable$kotlin_stdlib();
        int n = this.findKey(entry.getKey());
        if (n < 0) {
            return false;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        if (!Intrinsics.areEqual(this.valuesArray[n], entry.getValue())) {
            return false;
        }
        this.removeKeyAt(n);
        return true;
    }

    public final boolean removeValue$kotlin_stdlib(Object object) {
        MapBuilder mapBuilder = this;
        mapBuilder.checkIsMutable$kotlin_stdlib();
        int n = mapBuilder.findValue(object);
        if (n < 0) {
            return false;
        }
        this.removeKeyAt(n);
        return true;
    }

    public final MapBuilder$KeysItr keysIterator$kotlin_stdlib() {
        return new MapBuilder$KeysItr(this);
    }

    public final MapBuilder$ValuesItr valuesIterator$kotlin_stdlib() {
        return new MapBuilder$ValuesItr(this);
    }

    public final MapBuilder$EntriesItr entriesIterator$kotlin_stdlib() {
        return new MapBuilder$EntriesItr(this);
    }
}

