/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.Collection;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterable;
import kotlin.jvm.internal.markers.KMutableSet;

public abstract class TypeIntrinsics {
    private static Throwable sanitizeStackTrace(Throwable throwable) {
        return Intrinsics.sanitizeStackTrace(throwable, TypeIntrinsics.class.getName());
    }

    public static void throwCce(Object object, String string) {
        object = object == null ? "null" : object.getClass().getName();
        TypeIntrinsics.throwCce((String)object + " cannot be cast to " + string);
    }

    public static void throwCce(String string) {
        throw TypeIntrinsics.throwCce(new ClassCastException(string));
    }

    public static ClassCastException throwCce(ClassCastException classCastException) {
        throw (ClassCastException)TypeIntrinsics.sanitizeStackTrace(classCastException);
    }

    public static Iterable asMutableIterable(Object object) {
        if (object instanceof KMappedMarker && !(object instanceof KMutableIterable)) {
            TypeIntrinsics.throwCce(object, "kotlin.collections.MutableIterable");
        }
        return TypeIntrinsics.castToIterable(object);
    }

    public static Iterable castToIterable(Object object) {
        try {
            return (Iterable)object;
        }
        catch (ClassCastException classCastException) {
            throw TypeIntrinsics.throwCce(classCastException);
        }
    }

    public static Collection asMutableCollection(Object object) {
        if (object instanceof KMappedMarker && !(object instanceof KMutableCollection)) {
            TypeIntrinsics.throwCce(object, "kotlin.collections.MutableCollection");
        }
        return TypeIntrinsics.castToCollection(object);
    }

    public static Collection castToCollection(Object object) {
        try {
            return (Collection)object;
        }
        catch (ClassCastException classCastException) {
            throw TypeIntrinsics.throwCce(classCastException);
        }
    }

    public static Set asMutableSet(Object object) {
        if (object instanceof KMappedMarker && !(object instanceof KMutableSet)) {
            TypeIntrinsics.throwCce(object, "kotlin.collections.MutableSet");
        }
        return TypeIntrinsics.castToSet(object);
    }

    public static Set castToSet(Object object) {
        try {
            return (Set)object;
        }
        catch (ClassCastException classCastException) {
            throw TypeIntrinsics.throwCce(classCastException);
        }
    }
}

