/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.EmptyPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.MutableClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public abstract class SuspendFunctionTypesKt {
    private static final MutableClassDescriptor FAKE_CONTINUATION_CLASS_DESCRIPTOR;

    public static final SimpleType transformSuspendFunctionToRuntimeFunctionType(KotlinType object) {
        ArrayList<KotlinType> arrayList;
        KotlinType kotlinType = object;
        Intrinsics.checkNotNullParameter(kotlinType, "suspendFunType");
        boolean bl = FunctionTypesKt.isSuspendFunctionType(kotlinType);
        if (_Assertions.ENABLED && !bl) {
            object = "This type should be suspend function type: " + object;
            throw new AssertionError(object);
        }
        KotlinType kotlinType2 = object;
        Object object2 = TypeUtilsKt.getBuiltIns(kotlinType2);
        Object object3 = kotlinType2.getAnnotations();
        KotlinType kotlinType3 = FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType2);
        List list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(kotlinType2);
        Object object4 = FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType2);
        ArrayList<KotlinType> arrayList2 = arrayList;
        arrayList = new ArrayList<KotlinType>(CollectionsKt.collectionSizeOrDefault((Iterable)object4, 10));
        object4 = object4.iterator();
        while (object4.hasNext()) {
            arrayList2.add(((TypeProjection)object4.next()).getType());
        }
        KotlinBuiltIns kotlinBuiltIns = object2;
        Annotations annotations2 = object3;
        TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
        TypeConstructor typeConstructor2 = FAKE_CONTINUATION_CLASS_DESCRIPTOR.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "FAKE_CONTINUATION_CLASS_DESCRIPTOR.typeConstructor");
        object2 = CollectionsKt.plus(arrayList2, (Object)KotlinTypeFactory.simpleType$default(typeAttributes, typeConstructor2, CollectionsKt.listOf((Object)TypeUtilsKt.asTypeProjection(FunctionTypesKt.getReturnTypeFromFunctionType((KotlinType)object))), false, null, 16, null));
        object3 = TypeUtilsKt.getBuiltIns((KotlinType)object).getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue(object3, "suspendFunType.builtIns.nullableAnyType");
        return FunctionTypesKt.createFunctionType$default(kotlinBuiltIns, annotations2, kotlinType3, list, (List)object2, null, (KotlinType)object3, false, 128, null).makeNullableAsSpecified(((KotlinType)object).isMarkedNullable());
    }

    static {
        Name name = StandardNames.CONTINUATION_INTERFACE_FQ_NAME.shortName();
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(new EmptyPackageFragmentDescriptor(ErrorUtils.INSTANCE.getErrorModule(), StandardNames.COROUTINES_PACKAGE_FQ_NAME), ClassKind.INTERFACE, false, false, name, sourceElement, storageManager);
        mutableClassDescriptor.setModality(Modality.ABSTRACT);
        mutableClassDescriptor.setVisibility(DescriptorVisibilities.PUBLIC);
        name = Name.identifier("T");
        mutableClassDescriptor.setTypeParameterDescriptors(CollectionsKt.listOf((Object)TypeParameterDescriptorImpl.createWithDefaultBound(mutableClassDescriptor, Annotations.Companion.getEMPTY(), false, Variance.IN_VARIANCE, name, 0, storageManager)));
        mutableClassDescriptor.createTypeConstructor();
        FAKE_CONTINUATION_CLASS_DESCRIPTOR = mutableClassDescriptor;
    }
}

