/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMapper;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancedTypeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.MutabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPositionKt;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt$WhenMappings;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementUtilsKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;

public abstract class TypeEnhancementKt {
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    public static final boolean hasEnhancedNullability(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        return TypeEnhancementUtilsKt.hasEnhancedNullability(SimpleClassicTypeSystemContext.INSTANCE, kotlinType);
    }

    private static final Annotations compositeAnnotationsOrSingle(List list) {
        int n = list.size();
        if (n != 0) {
            Annotations annotations2;
            if (n != 1) {
                CompositeAnnotations compositeAnnotations;
                annotations2 = compositeAnnotations;
                compositeAnnotations = new CompositeAnnotations(CollectionsKt.toList(list));
            } else {
                annotations2 = (Annotations)CollectionsKt.single(list);
            }
            return annotations2;
        }
        throw new IllegalStateException("At least one Annotations object expected".toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final ClassifierDescriptor enhanceMutability(ClassifierDescriptor classifierDescriptor, JavaTypeQualifiers javaTypeQualifiers, TypeComponentPosition typeComponentPosition) {
        ClassDescriptor classDescriptor;
        JavaToKotlinClassMapper javaToKotlinClassMapper;
        block5: {
            block4: {
                ClassDescriptor classDescriptor2;
                javaToKotlinClassMapper = JavaToKotlinClassMapper.INSTANCE;
                if (!TypeComponentPositionKt.shouldEnhance(typeComponentPosition)) return null;
                if (!(classifierDescriptor instanceof ClassDescriptor)) break block4;
                if (javaTypeQualifiers.getMutability() == MutabilityQualifier.READ_ONLY && typeComponentPosition == TypeComponentPosition.FLEXIBLE_LOWER && javaToKotlinClassMapper.isMutable(classDescriptor2 = (ClassDescriptor)classifierDescriptor)) {
                    classDescriptor = javaToKotlinClassMapper.convertMutableToReadOnly(classDescriptor2);
                    return classDescriptor;
                }
                if (javaTypeQualifiers.getMutability() != MutabilityQualifier.MUTABLE) return null;
                if (typeComponentPosition != TypeComponentPosition.FLEXIBLE_UPPER) return null;
                if (javaToKotlinClassMapper.isReadOnly((ClassDescriptor)(classifierDescriptor = (ClassDescriptor)classifierDescriptor))) break block5;
            }
            return null;
        }
        classDescriptor = javaToKotlinClassMapper.convertReadOnlyToMutable((ClassDescriptor)classifierDescriptor);
        return classDescriptor;
    }

    private static final Boolean getEnhancedNullability(JavaTypeQualifiers object, TypeComponentPosition typeComponentPosition) {
        if (!TypeComponentPositionKt.shouldEnhance(typeComponentPosition)) {
            return null;
        }
        int n = (object = ((JavaTypeQualifiers)object).getNullability()) == null ? -1 : TypeEnhancementKt$WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        return n != 1 ? (n != 2 ? null : Boolean.FALSE) : Boolean.TRUE;
    }

    public static final /* synthetic */ ClassifierDescriptor access$enhanceMutability(ClassifierDescriptor classifierDescriptor, JavaTypeQualifiers javaTypeQualifiers, TypeComponentPosition typeComponentPosition) {
        return TypeEnhancementKt.enhanceMutability(classifierDescriptor, javaTypeQualifiers, typeComponentPosition);
    }

    public static final /* synthetic */ Boolean access$getEnhancedNullability(JavaTypeQualifiers javaTypeQualifiers, TypeComponentPosition typeComponentPosition) {
        return TypeEnhancementKt.getEnhancedNullability(javaTypeQualifiers, typeComponentPosition);
    }

    public static final /* synthetic */ Annotations access$compositeAnnotationsOrSingle(List list) {
        return TypeEnhancementKt.compositeAnnotationsOrSingle(list);
    }

    public static final /* synthetic */ EnhancedTypeAnnotations access$getENHANCED_MUTABILITY_ANNOTATIONS$p() {
        return ENHANCED_MUTABILITY_ANNOTATIONS;
    }

    public static final /* synthetic */ EnhancedTypeAnnotations access$getENHANCED_NULLABILITY_ANNOTATIONS$p() {
        return ENHANCED_NULLABILITY_ANNOTATIONS;
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        fqName2 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
    }
}

