/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DescriptorBasedTypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType$Object;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType$Primitive;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactoryImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureBuildingUtilsKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public abstract class MethodSignatureMappingKt {
    public static final String computeJvmDescriptor(FunctionDescriptor annotated, boolean bl, boolean bl2) {
        Object object;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(annotated, "<this>");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (bl2) {
            if (annotated instanceof ConstructorDescriptor) {
                object = "<init>";
            } else {
                object = annotated.getName().asString();
                Intrinsics.checkNotNullExpressionValue(object, "name.asString()");
            }
            stringBuilder2.append((String)object);
        }
        stringBuilder2.append("(");
        object = annotated.getExtensionReceiverParameter();
        if (object != null) {
            object = object.getType();
            Intrinsics.checkNotNullExpressionValue(object, "it.type");
            MethodSignatureMappingKt.appendErasedType(stringBuilder2, (KotlinType)object);
        }
        object = annotated.getValueParameters().iterator();
        while (object.hasNext()) {
            KotlinType kotlinType = ((ValueParameterDescriptor)object.next()).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "parameter.type");
            MethodSignatureMappingKt.appendErasedType(stringBuilder2, kotlinType);
        }
        stringBuilder2.append(")");
        if (bl) {
            if (DescriptorBasedTypeSignatureMappingKt.hasVoidReturnType(annotated)) {
                stringBuilder2.append("V");
            } else {
                annotated = annotated.getReturnType();
                Intrinsics.checkNotNull(annotated);
                MethodSignatureMappingKt.appendErasedType(stringBuilder2, (KotlinType)annotated);
            }
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String computeJvmDescriptor$default(FunctionDescriptor functionDescriptor, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return MethodSignatureMappingKt.computeJvmDescriptor(functionDescriptor, bl, bl2);
    }

    public static final boolean forceSingleValueParameterBoxing(CallableDescriptor object) {
        CallableDescriptor callableDescriptor = object;
        Intrinsics.checkNotNullParameter(callableDescriptor, "f");
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)object;
        if (Intrinsics.areEqual(functionDescriptor.getName().asString(), "remove") && functionDescriptor.getValueParameters().size() == 1 && !SpecialBuiltinMembers.isFromJavaOrBuiltins((CallableMemberDescriptor)object)) {
            List list = functionDescriptor.getOriginal().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "f.original.valueParameters");
            KotlinType kotlinType = ((ValueParameterDescriptor)CollectionsKt.single(list)).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "f.original.valueParameters.single().type");
            object = MethodSignatureMappingKt.mapToJvmType(kotlinType);
            object = object instanceof JvmType$Primitive ? (JvmType$Primitive)object : null;
            if ((object != null ? ((JvmType$Primitive)object).getJvmPrimitiveType() : null) != JvmPrimitiveType.INT) {
                return false;
            }
            object = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(functionDescriptor);
            if (object == null) {
                return false;
            }
            Object object2 = object;
            List list2 = object2.getOriginal().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "overridden.original.valueParameters");
            KotlinType kotlinType2 = ((ValueParameterDescriptor)CollectionsKt.single(list2)).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "overridden.original.valueParameters.single().type");
            object = MethodSignatureMappingKt.mapToJvmType(kotlinType2);
            DeclarationDescriptor declarationDescriptor = object2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "overridden.containingDeclaration");
            return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor), StandardNames$FqNames.mutableCollection.toUnsafe()) && object instanceof JvmType$Object && Intrinsics.areEqual(((JvmType$Object)object).getInternalName(), "java/lang/Object");
        }
        return false;
    }

    public static final String computeJvmSignature(CallableDescriptor callableDescriptor) {
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        Intrinsics.checkNotNullParameter(callableDescriptor2, "<this>");
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        if (DescriptorUtils.isLocal(callableDescriptor2)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
        declarationDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (declarationDescriptor == null) {
            return null;
        }
        if (declarationDescriptor.getName().isSpecial()) {
            return null;
        }
        if ((callableDescriptor = (callableDescriptor = callableDescriptor.getOriginal()) instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)callableDescriptor : null) == null) {
            return null;
        }
        return MethodSignatureBuildingUtilsKt.signature(signatureBuildingComponents, (ClassDescriptor)declarationDescriptor, MethodSignatureMappingKt.computeJvmDescriptor$default((FunctionDescriptor)callableDescriptor, false, false, 3, null));
    }

    public static final String getInternalName(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(classDescriptor, "<this>");
        FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameSafe(classDescriptor).toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "fqNameSafe.toUnsafe()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId != null) {
            String string = JvmClassName.byClassId(classId).getInternalName();
            Intrinsics.checkNotNullExpressionValue(string, "byClassId(it).internalName");
            return string;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName$default(classDescriptor, null, 2, null);
    }

    private static final void appendErasedType(StringBuilder stringBuilder, KotlinType kotlinType) {
        stringBuilder.append(MethodSignatureMappingKt.mapToJvmType(kotlinType));
    }

    public static final JvmType mapToJvmType(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        return (JvmType)DescriptorBasedTypeSignatureMappingKt.mapType$default(kotlinType2, JvmTypeFactoryImpl.INSTANCE, TypeMappingMode.DEFAULT, TypeMappingConfigurationImpl.INSTANCE, null, null, 32, null);
    }
}

