/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.StandardClassIds;

public abstract class StandardClassIdsKt {
    private static final FqName JAVA_LANG_PACKAGE = new FqName("java.lang");
    private static final FqName JAVA_LANG_ANNOTATION_PACKAGE;

    private static final ClassId baseId(String object) {
        String string = object;
        object = StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE();
        return new ClassId((FqName)object, Name.identifier(string));
    }

    private static final ClassId unsignedId(ClassId classId) {
        return new ClassId(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE(), Name.identifier('U' + classId.getShortClassName().getIdentifier()));
    }

    private static final ClassId reflectId(String object) {
        String string = object;
        object = StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE();
        return new ClassId((FqName)object, Name.identifier(string));
    }

    private static final ClassId primitiveArrayId(Name name) {
        StandardClassIds standardClassIds = StandardClassIds.INSTANCE;
        return new ClassId(standardClassIds.getArray().getPackageFqName(), Name.identifier(name.getIdentifier() + standardClassIds.getArray().getShortClassName().getIdentifier()));
    }

    private static final ClassId collectionsId(String object) {
        String string = object;
        object = StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE();
        return new ClassId((FqName)object, Name.identifier(string));
    }

    private static final ClassId rangesId(String object) {
        String string = object;
        object = StandardClassIds.INSTANCE.getBASE_RANGES_PACKAGE();
        return new ClassId((FqName)object, Name.identifier(string));
    }

    private static final ClassId annotationId(String object) {
        String string = object;
        object = StandardClassIds.INSTANCE.getBASE_ANNOTATION_PACKAGE();
        return new ClassId((FqName)object, Name.identifier(string));
    }

    private static final ClassId coroutinesId(String object) {
        String string = object;
        object = StandardClassIds.INSTANCE.getBASE_COROUTINES_PACKAGE();
        return new ClassId((FqName)object, Name.identifier(string));
    }

    private static final Map inverseMap(Map map) {
        LinkedHashMap linkedHashMap;
        Set set = map.entrySet();
        int n = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault(set, 10)), 16);
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap(n);
        for (Map.Entry entry : set) {
            Object object = entry.getKey();
            Pair pair = TuplesKt.to(entry.getValue(), object);
            object = pair.getFirst();
            linkedHashMap2.put(object, pair.getSecond());
        }
        return linkedHashMap2;
    }

    public static final /* synthetic */ ClassId access$baseId(String string) {
        return StandardClassIdsKt.baseId(string);
    }

    public static final /* synthetic */ ClassId access$reflectId(String string) {
        return StandardClassIdsKt.reflectId(string);
    }

    public static final /* synthetic */ ClassId access$coroutinesId(String string) {
        return StandardClassIdsKt.coroutinesId(string);
    }

    public static final /* synthetic */ ClassId access$annotationId(String string) {
        return StandardClassIdsKt.annotationId(string);
    }

    public static final /* synthetic */ ClassId access$primitiveArrayId(Name name) {
        return StandardClassIdsKt.primitiveArrayId(name);
    }

    public static final /* synthetic */ ClassId access$unsignedId(ClassId classId) {
        return StandardClassIdsKt.unsignedId(classId);
    }

    public static final /* synthetic */ Map access$inverseMap(Map map) {
        return StandardClassIdsKt.inverseMap(map);
    }

    public static final /* synthetic */ ClassId access$collectionsId(String string) {
        return StandardClassIdsKt.collectionsId(string);
    }

    public static final /* synthetic */ ClassId access$rangesId(String string) {
        return StandardClassIdsKt.rangesId(string);
    }

    static {
        FqName fqName2 = JAVA_LANG_PACKAGE.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "JAVA_LANG_PACKAGE.child(\u2026identifier(\"annotation\"))");
        JAVA_LANG_ANNOTATION_PACKAGE = fqName2;
    }
}

