/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.FieldSet$1;
import kotlin.reflect.jvm.internal.impl.protobuf.FieldSet$FieldDescriptorLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal$EnumLite;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyField$LazyIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite$Builder;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat$FieldType;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat$JavaType;

final class FieldSet {
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);
    private final SmallSortedMap fields;
    private boolean isImmutable;
    private boolean hasLazyField;

    private FieldSet() {
        this.hasLazyField = false;
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean bl) {
        FieldSet fieldSet = this;
        fieldSet.hasLazyField = false;
        fieldSet.fields = SmallSortedMap.newFieldMap(0);
        fieldSet.makeImmutable();
    }

    public static FieldSet newFieldSet() {
        return new FieldSet();
    }

    public static FieldSet emptySet() {
        return DEFAULT_INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private static void verifyType(WireFormat$FieldType var0, Object var1_3) {
        var1_3.getClass();
        var2_4 = false;
        block0 : switch (FieldSet$1.$SwitchMap$com$google$protobuf$WireFormat$JavaType[var0.getJavaType().ordinal()]) {
            default: {
                break;
            }
            case 9: {
                if (!(var1_3 instanceof MessageLite)) lbl-1000:
                // 3 sources

                {
                    while (true) {
                        var2_4 = var0_1 = false;
                        break block0;
                        break;
                    }
                }
lbl12:
                // 4 sources

                while (true) {
                    var2_4 = var0_2 = true;
                    break block0;
                    break;
                }
            }
            case 8: {
                if (!(var1_3 instanceof Integer) && !(var1_3 instanceof Internal$EnumLite)) ** GOTO lbl-1000
                ** GOTO lbl12
            }
            case 7: {
                if (var1_3 instanceof ByteString || var1_3 instanceof byte[]) ** break;
                ** continue;
                ** continue;
            }
            case 6: {
                var2_4 = var1_3 instanceof String;
                break;
            }
            case 5: {
                var2_4 = var1_3 instanceof Boolean;
                break;
            }
            case 4: {
                var2_4 = var1_3 instanceof Double;
                break;
            }
            case 3: {
                var2_4 = var1_3 instanceof Float;
                break;
            }
            case 2: {
                var2_4 = var1_3 instanceof Long;
                break;
            }
            case 1: {
                var2_4 = var1_3 instanceof Integer;
            }
        }
        if (var2_4) {
            return;
        }
        throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
    }

    private boolean isInitialized(Map.Entry entry) {
        Object object = (FieldSet$FieldDescriptorLite)entry.getKey();
        if (object.getLiteJavaType() == WireFormat$JavaType.MESSAGE) {
            if (object.isRepeated()) {
                object = ((List)entry.getValue()).iterator();
                while (object.hasNext()) {
                    if (((MessageLite)object.next()).isInitialized()) continue;
                    return false;
                }
            } else {
                object = entry.getValue();
                if (object instanceof MessageLite) {
                    if (!((MessageLite)object).isInitialized()) {
                        return false;
                    }
                } else {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat$FieldType wireFormat$FieldType, boolean bl) {
        if (bl) {
            return 2;
        }
        return wireFormat$FieldType.getWireType();
    }

    private Object cloneIfMutable(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            Object object2 = byArray;
            byte[] byArray2 = new byte[byArray.length];
            object = byArray2;
            Object object3 = object2;
            int n = ((Object)object3).length;
            System.arraycopy(object3, 0, object, 0, n);
            return byArray2;
        }
        return object;
    }

    private void mergeFromField(Map.Entry object) {
        Map.Entry entry = object;
        object = (FieldSet$FieldDescriptorLite)entry.getKey();
        Object v = entry.getValue();
        if (object.isRepeated()) {
            Object object2 = ((FieldSet)object4).getField((FieldSet$FieldDescriptorLite)object);
            if (object2 == null) {
                ArrayList arrayList;
                object2 = arrayList;
                arrayList = new ArrayList();
            }
            for (Object e : (List)v) {
                ((List)object2).add(super.cloneIfMutable(e));
            }
            ((FieldSet)object4).fields.put((Comparable)object, object2);
        } else if (object.getLiteJavaType() == WireFormat$JavaType.MESSAGE) {
            Object object3 = ((FieldSet)object4).getField((FieldSet$FieldDescriptorLite)object);
            if (object3 == null) {
                ((FieldSet)object4).fields.put((Comparable)object, ((FieldSet)object4).cloneIfMutable(v));
            } else {
                FieldSet fieldSet = object4;
                Object object4 = ((MessageLite)object3).toBuilder();
                object4 = object.internalMergeFrom((MessageLite$Builder)object4, (MessageLite)v).build();
                fieldSet.fields.put((Comparable)object, object4);
            }
        } else {
            ((FieldSet)object4).fields.put((Comparable)object, ((FieldSet)object4).cloneIfMutable(v));
        }
    }

    public static Object readPrimitiveField(CodedInputStream codedInputStream, WireFormat$FieldType wireFormat$FieldType, boolean bl) {
        switch (FieldSet$1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[wireFormat$FieldType.ordinal()]) {
            default: {
                throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
            }
            case 18: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle enums.");
            }
            case 17: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle embedded messages.");
            }
            case 16: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle nested groups.");
            }
            case 15: {
                return codedInputStream.readSInt64();
            }
            case 14: {
                return codedInputStream.readSInt32();
            }
            case 13: {
                return codedInputStream.readSFixed64();
            }
            case 12: {
                return codedInputStream.readSFixed32();
            }
            case 11: {
                return codedInputStream.readUInt32();
            }
            case 10: {
                return codedInputStream.readBytes();
            }
            case 9: {
                if (bl) {
                    return codedInputStream.readStringRequireUtf8();
                }
                return codedInputStream.readString();
            }
            case 8: {
                return codedInputStream.readBool();
            }
            case 7: {
                return codedInputStream.readFixed32();
            }
            case 6: {
                return codedInputStream.readFixed64();
            }
            case 5: {
                return codedInputStream.readInt32();
            }
            case 4: {
                return codedInputStream.readUInt64();
            }
            case 3: {
                return codedInputStream.readInt64();
            }
            case 2: {
                return Float.valueOf(codedInputStream.readFloat());
            }
            case 1: 
        }
        return codedInputStream.readDouble();
    }

    private static void writeElement(CodedOutputStream codedOutputStream, WireFormat$FieldType wireFormat$FieldType, int n, Object object) {
        if (wireFormat$FieldType == WireFormat$FieldType.GROUP) {
            codedOutputStream.writeGroup(n, (MessageLite)object);
        } else {
            CodedOutputStream codedOutputStream2 = codedOutputStream;
            codedOutputStream2.writeTag(n, FieldSet.getWireFormatForFieldType(wireFormat$FieldType, false));
            FieldSet.writeElementNoTag(codedOutputStream2, wireFormat$FieldType, object);
        }
    }

    private static void writeElementNoTag(CodedOutputStream codedOutputStream, WireFormat$FieldType wireFormat$FieldType, Object object) {
        switch (FieldSet$1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[wireFormat$FieldType.ordinal()]) {
            default: {
                break;
            }
            case 18: {
                if (object instanceof Internal$EnumLite) {
                    codedOutputStream.writeEnumNoTag(((Internal$EnumLite)object).getNumber());
                    break;
                }
                codedOutputStream.writeEnumNoTag((Integer)object);
                break;
            }
            case 17: {
                codedOutputStream.writeMessageNoTag((MessageLite)object);
                break;
            }
            case 16: {
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                break;
            }
            case 15: {
                codedOutputStream.writeSInt64NoTag((Long)object);
                break;
            }
            case 14: {
                codedOutputStream.writeSInt32NoTag((Integer)object);
                break;
            }
            case 13: {
                codedOutputStream.writeSFixed64NoTag((Long)object);
                break;
            }
            case 12: {
                codedOutputStream.writeSFixed32NoTag((Integer)object);
                break;
            }
            case 11: {
                codedOutputStream.writeUInt32NoTag((Integer)object);
                break;
            }
            case 10: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    break;
                }
                codedOutputStream.writeByteArrayNoTag((byte[])object);
                break;
            }
            case 9: {
                codedOutputStream.writeStringNoTag((String)object);
                break;
            }
            case 8: {
                codedOutputStream.writeBoolNoTag((Boolean)object);
                break;
            }
            case 7: {
                codedOutputStream.writeFixed32NoTag((Integer)object);
                break;
            }
            case 6: {
                codedOutputStream.writeFixed64NoTag((Long)object);
                break;
            }
            case 5: {
                codedOutputStream.writeInt32NoTag((Integer)object);
                break;
            }
            case 4: {
                codedOutputStream.writeUInt64NoTag((Long)object);
                break;
            }
            case 3: {
                codedOutputStream.writeInt64NoTag((Long)object);
                break;
            }
            case 2: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                break;
            }
            case 1: {
                codedOutputStream.writeDoubleNoTag((Double)object);
            }
        }
    }

    public static void writeField(FieldSet$FieldDescriptorLite iterator2, Object object, CodedOutputStream codedOutputStream) {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite = iterator2;
        WireFormat$FieldType wireFormat$FieldType = fieldSet$FieldDescriptorLite.getLiteType();
        int n = fieldSet$FieldDescriptorLite.getNumber();
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite2 = iterator2;
            iterator2 = (List)object;
            if (fieldSet$FieldDescriptorLite2.isPacked()) {
                codedOutputStream.writeTag(n, 2);
                int n2 = 0;
                Iterator iterator3 = iterator2.iterator();
                while (iterator3.hasNext()) {
                    n2 += FieldSet.computeElementSizeNoTag(wireFormat$FieldType, iterator3.next());
                }
                codedOutputStream.writeRawVarint32(n2);
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    FieldSet.writeElementNoTag(codedOutputStream, wireFormat$FieldType, iterator2.next());
                }
            } else {
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    FieldSet.writeElement(codedOutputStream, wireFormat$FieldType, n, object);
                }
            }
        } else {
            FieldSet.writeElement(codedOutputStream, wireFormat$FieldType, n, object);
        }
    }

    private static int computeElementSize(WireFormat$FieldType wireFormat$FieldType, int n, Object object) {
        n = CodedOutputStream.computeTagSize(n);
        if (wireFormat$FieldType == WireFormat$FieldType.GROUP) {
            n *= 2;
        }
        return n + FieldSet.computeElementSizeNoTag(wireFormat$FieldType, object);
    }

    private static int computeElementSizeNoTag(WireFormat$FieldType wireFormat$FieldType, Object object) {
        switch (FieldSet$1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[wireFormat$FieldType.ordinal()]) {
            default: {
                throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
            }
            case 18: {
                if (object instanceof Internal$EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal$EnumLite)object).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)object);
            }
            case 17: {
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)object);
            }
            case 16: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)object);
            }
            case 15: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)object);
            }
            case 14: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)object);
            }
            case 13: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)object);
            }
            case 12: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)object);
            }
            case 11: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)object);
            }
            case 10: {
                if (object instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])object);
            }
            case 9: {
                return CodedOutputStream.computeStringSizeNoTag((String)object);
            }
            case 8: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)object);
            }
            case 7: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)object);
            }
            case 6: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)object);
            }
            case 5: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)object);
            }
            case 4: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)object);
            }
            case 3: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)object);
            }
            case 2: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)object).floatValue());
            }
            case 1: 
        }
        return CodedOutputStream.computeDoubleSizeNoTag((Double)object);
    }

    public static int computeFieldSize(FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite, Object iterator2) {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite2 = fieldSet$FieldDescriptorLite;
        WireFormat$FieldType wireFormat$FieldType = fieldSet$FieldDescriptorLite2.getLiteType();
        int n = fieldSet$FieldDescriptorLite2.getNumber();
        if (fieldSet$FieldDescriptorLite2.isRepeated()) {
            if (fieldSet$FieldDescriptorLite.isPacked()) {
                int n2 = 0;
                iterator2 = ((List)((Object)iterator2)).iterator();
                while (iterator2.hasNext()) {
                    n2 += FieldSet.computeElementSizeNoTag(wireFormat$FieldType, iterator2.next());
                }
                return n2 + CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeRawVarint32Size(n2);
            }
            int n3 = 0;
            iterator2 = ((List)((Object)iterator2)).iterator();
            while (iterator2.hasNext()) {
                n3 += FieldSet.computeElementSize(wireFormat$FieldType, n, iterator2.next());
            }
            return n3;
        }
        return FieldSet.computeElementSize(wireFormat$FieldType, n, iterator2);
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public FieldSet clone() {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite;
        FieldSet fieldSet = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry entry = this.fields.getArrayEntryAt(i);
            fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldSet$FieldDescriptorLite, entry.getValue());
        }
        for (Map.Entry entry : this.fields.getOverflowEntries()) {
            fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldSet$FieldDescriptorLite, entry.getValue());
        }
        fieldSet.hasLazyField = this.hasLazyField;
        return fieldSet;
    }

    public Iterator iterator() {
        if (this.hasLazyField) {
            return new LazyField$LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    public boolean hasField(FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite) {
        if (!fieldSet$FieldDescriptorLite.isRepeated()) {
            return this.fields.get(fieldSet$FieldDescriptorLite) != null;
        }
        throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
    }

    public Object getField(FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite) {
        return this.fields.get(fieldSet$FieldDescriptorLite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setField(FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite, Object object) {
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            ArrayList arrayList;
            if (!(object instanceof List)) throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            ArrayList arrayList2 = arrayList;
            arrayList2();
            arrayList.addAll((List)object);
            for (Object e : arrayList) {
                FieldSet.verifyType(fieldSet$FieldDescriptorLite.getLiteType(), e);
            }
            object = arrayList2;
        } else {
            FieldSet.verifyType(fieldSet$FieldDescriptorLite.getLiteType(), object);
        }
        this.fields.put(fieldSet$FieldDescriptorLite, object);
    }

    public int getRepeatedFieldCount(FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite) {
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            if ((this = ((FieldSet)this).getField(fieldSet$FieldDescriptorLite)) == null) {
                return 0;
            }
            return ((List)this).size();
        }
        throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
    }

    public Object getRepeatedField(FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite, int n) {
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            if ((this = ((FieldSet)this).getField(fieldSet$FieldDescriptorLite)) != null) {
                return ((List)this).get(n);
            }
            throw new IndexOutOfBoundsException();
        }
        throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
    }

    public void addRepeatedField(FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite, Object object) {
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            Object object2;
            FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite2 = fieldSet$FieldDescriptorLite;
            FieldSet.verifyType(fieldSet$FieldDescriptorLite2.getLiteType(), object);
            Object object3 = ((FieldSet)object2).getField(fieldSet$FieldDescriptorLite2);
            if (object3 == null) {
                ArrayList arrayList;
                FieldSet fieldSet = object2;
                object2 = arrayList;
                arrayList = new ArrayList();
                fieldSet.fields.put(fieldSet$FieldDescriptorLite, object2);
            } else {
                object2 = (List)object3;
            }
            object2.add(object);
            return;
        }
        throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
    }

    public boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            FieldSet fieldSet = this;
            if (fieldSet.isInitialized(fieldSet.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        Iterator iterator2 = this.fields.getOverflowEntries().iterator();
        while (iterator2.hasNext()) {
            if (this.isInitialized((Map.Entry)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public void mergeFrom(FieldSet object) {
        for (int i = 0; i < ((FieldSet)object).fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(((FieldSet)object).fields.getArrayEntryAt(i));
        }
        object = ((FieldSet)object).fields.getOverflowEntries().iterator();
        while (object.hasNext()) {
            this.mergeFromField((Map.Entry)object.next());
        }
    }

    public int getSerializedSize() {
        int n = 0;
        for (int i = 0; i < ((FieldSet)this).fields.getNumArrayEntries(); ++i) {
            Map.Entry entry = ((FieldSet)this).fields.getArrayEntryAt(i);
            n += FieldSet.computeFieldSize((FieldSet$FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : ((FieldSet)this).fields.getOverflowEntries()) {
            n += FieldSet.computeFieldSize((FieldSet$FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n;
    }
}

