/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyStringList;
import kotlin.reflect.jvm.internal.impl.protobuf.UnmodifiableLazyStringList;

public class LazyStringArrayList
extends AbstractList
implements RandomAccess,
LazyStringList {
    public static final LazyStringList EMPTY = new LazyStringArrayList().getUnmodifiableView();
    private final List list;

    public LazyStringArrayList() {
        ArrayList arrayList;
        AbstractList abstractList = arrayList;
        arrayList = new ArrayList();
        v1.list = abstractList;
    }

    public LazyStringArrayList(LazyStringList lazyStringList) {
        this.list = new ArrayList(lazyStringList.size());
        this.addAll((Collection)lazyStringList);
    }

    private static String asString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            return ((ByteString)object).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    private static ByteString asByteString(Object object) {
        if (object instanceof ByteString) {
            return (ByteString)object;
        }
        if (object instanceof String) {
            return ByteString.copyFromUtf8((String)object);
        }
        return ByteString.copyFrom((byte[])object);
    }

    public String get(int n) {
        Object object = this.list.get(n);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            ByteString byteString = (ByteString)object;
            object = byteString.toStringUtf8();
            if (byteString.isValidUtf8()) {
                this.list.set(n, object);
            }
            return object;
        }
        byte[] byArray = (byte[])object;
        object = Internal.toStringUtf8(byArray);
        if (Internal.isValidUtf8(byArray)) {
            this.list.set(n, object);
        }
        return object;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public String set(int n, String string) {
        return LazyStringArrayList.asString(this.list.set(n, string));
    }

    public void add(int n, String string) {
        LazyStringArrayList lazyStringArrayList = this;
        lazyStringArrayList.list.add(n, string);
        ++lazyStringArrayList.modCount;
    }

    @Override
    public boolean addAll(Collection collection) {
        LazyStringArrayList lazyStringArrayList = this;
        return lazyStringArrayList.addAll(lazyStringArrayList.size(), collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (collection instanceof LazyStringList) {
            collection = ((LazyStringList)collection).getUnderlyingElements();
        }
        ++this.modCount;
        return this.list.addAll(n, collection);
    }

    public String remove(int n) {
        LazyStringArrayList lazyStringArrayList = lazyStringArrayList2;
        LazyStringArrayList lazyStringArrayList2 = lazyStringArrayList.list.remove(n);
        ++lazyStringArrayList.modCount;
        return LazyStringArrayList.asString(lazyStringArrayList2);
    }

    @Override
    public void clear() {
        LazyStringArrayList lazyStringArrayList = this;
        lazyStringArrayList.list.clear();
        ++lazyStringArrayList.modCount;
    }

    @Override
    public void add(ByteString byteString) {
        LazyStringArrayList lazyStringArrayList = this;
        lazyStringArrayList.list.add(byteString);
        ++lazyStringArrayList.modCount;
    }

    @Override
    public ByteString getByteString(int n) {
        Object e = this.list.get(n);
        ByteString byteString = LazyStringArrayList.asByteString(e);
        if (byteString != e) {
            this.list.set(n, byteString);
        }
        return byteString;
    }

    @Override
    public List getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        return new UnmodifiableLazyStringList(this);
    }
}

