/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString$ByteIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString$LiteralByteIterator;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.Utf8;

class LiteralByteString
extends ByteString {
    protected final byte[] bytes;
    private int hash = 0;

    LiteralByteString(byte[] byArray) {
        this.bytes = byArray;
    }

    static int hashCode(int n, byte[] byArray, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            n = n * 31 + byArray[i];
        }
        return n;
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, n, byArray, n2, n3);
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n, int n2) {
        outputStream.write(this.bytes, this.getOffsetIntoBytes() + n, n2);
    }

    @Override
    public String toString(String string) {
        LiteralByteString literalByteString = object;
        Object object = literalByteString.bytes;
        int n = literalByteString.getOffsetIntoBytes();
        int n2 = literalByteString.size();
        return new String((byte[])object, n, n2, string);
    }

    @Override
    public boolean isValidUtf8() {
        int n;
        LiteralByteString literalByteString = this;
        int n2 = n = literalByteString.getOffsetIntoBytes();
        return Utf8.isValidUtf8(literalByteString.bytes, n2, n2 + this.size());
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = n;
        n = ((LiteralByteString)object).getOffsetIntoBytes() + n2;
        Object object = ((LiteralByteString)object).bytes;
        n2 = n + n3;
        return Utf8.partialIsValidUtf8(n4, (byte[])object, n, n2);
    }

    public boolean equals(Object object) {
        Object object2;
        if (object == object2) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        if (((LiteralByteString)object2).size() != ((ByteString)object).size()) {
            return false;
        }
        if (((LiteralByteString)object2).size() == 0) {
            return true;
        }
        if (object instanceof LiteralByteString) {
            LiteralByteString literalByteString = object2;
            object2 = (LiteralByteString)object;
            int n = literalByteString.size();
            return literalByteString.equalsRange((LiteralByteString)object2, 0, n);
        }
        if (object instanceof RopeByteString) {
            return object.equals(object2);
        }
        object2 = String.valueOf(object.getClass());
        throw new IllegalArgumentException(new StringBuilder(((String)object2).length() + 49).append("Has a new type of ByteString been created? Found ").append((String)object2).toString());
    }

    boolean equalsRange(LiteralByteString object, int n, int n2) {
        if (n2 <= ((LiteralByteString)object).size()) {
            if (n + n2 <= ((LiteralByteString)object).size()) {
                LiteralByteString literalByteString = object;
                LiteralByteString literalByteString2 = object2;
                Object object2 = ((LiteralByteString)object2).bytes;
                object = ((LiteralByteString)object).bytes;
                n2 = literalByteString2.getOffsetIntoBytes() + n2;
                int n3 = literalByteString2.getOffsetIntoBytes();
                n = literalByteString.getOffsetIntoBytes() + n;
                while (n3 < n2) {
                    if (object2[n3] != object[n]) {
                        return false;
                    }
                    ++n3;
                    ++n;
                }
                return true;
            }
            throw new IllegalArgumentException(new StringBuilder(59).append("Ran off end of other: ").append(n).append(", ").append(n2).append(", ").append(((LiteralByteString)object).size()).toString());
        }
        throw new IllegalArgumentException(new StringBuilder(40).append("Length too large: ").append(n2).append(((LiteralByteString)object2).size()).toString());
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            LiteralByteString literalByteString = this;
            int n2 = literalByteString.size();
            n = literalByteString.partialHash(n2, 0, n2);
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        return LiteralByteString.hashCode(n, this.bytes, this.getOffsetIntoBytes() + n2, n3);
    }

    public ByteString$ByteIterator iterator() {
        return new LiteralByteString$LiteralByteIterator(this, null);
    }

    @Override
    protected int getTreeDepth() {
        return 0;
    }

    @Override
    protected boolean isBalanced() {
        return true;
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }
}

