/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorImpl;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;

public final class CapturedType
extends SimpleType
implements CapturedTypeMarker {
    private final TypeProjection typeProjection;
    private final CapturedTypeConstructor constructor;
    private final boolean isMarkedNullable;
    private final TypeAttributes attributes;

    public CapturedType(TypeProjection typeProjection, CapturedTypeConstructor capturedTypeConstructor, boolean bl, TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter(typeProjection, "typeProjection");
        Intrinsics.checkNotNullParameter(capturedTypeConstructor, "constructor");
        Intrinsics.checkNotNullParameter(typeAttributes, "attributes");
        this.typeProjection = typeProjection;
        this.constructor = capturedTypeConstructor;
        this.isMarkedNullable = bl;
        this.attributes = typeAttributes;
    }

    public /* synthetic */ CapturedType(TypeProjection typeProjection, CapturedTypeConstructor capturedTypeConstructor, boolean bl, TypeAttributes typeAttributes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            CapturedTypeConstructorImpl capturedTypeConstructorImpl;
            capturedTypeConstructor = capturedTypeConstructorImpl;
            capturedTypeConstructorImpl = new CapturedTypeConstructorImpl(typeProjection);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            typeAttributes = TypeAttributes.Companion.getEmpty();
        }
        this(typeProjection, capturedTypeConstructor, bl, typeAttributes);
    }

    @Override
    public CapturedTypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    @Override
    public TypeAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List getArguments() {
        return CollectionsKt.emptyList();
    }

    @Override
    public MemberScope getMemberScope() {
        return ErrorUtils.createErrorScope(ErrorScopeKind.CAPTURED_TYPE_SCOPE, true, new String[0]);
    }

    @Override
    public String toString() {
        CapturedType capturedType = stringBuilder;
        StringBuilder stringBuilder = new StringBuilder().append("Captured(").append(((CapturedType)((Object)stringBuilder)).typeProjection).append(')');
        String string = capturedType.isMarkedNullable() ? "?" : "";
        return stringBuilder.append(string).toString();
    }

    @Override
    public CapturedType makeNullableAsSpecified(boolean bl) {
        if (bl == ((CapturedType)((Object)typeProjection)).isMarkedNullable()) {
            return typeProjection;
        }
        CapturedType capturedType = typeProjection;
        TypeProjection typeProjection = capturedType.typeProjection;
        CapturedTypeConstructor capturedTypeConstructor = capturedType.getConstructor();
        TypeAttributes typeAttributes = capturedType.getAttributes();
        return new CapturedType(typeProjection, capturedTypeConstructor, bl, typeAttributes);
    }

    @Override
    public SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter(typeAttributes, "newAttributes");
        CapturedType capturedType = typeProjection;
        TypeProjection typeProjection = capturedType.typeProjection;
        CapturedTypeConstructor capturedTypeConstructor = capturedType.getConstructor();
        boolean bl = capturedType.isMarkedNullable();
        return new CapturedType(typeProjection, capturedTypeConstructor, bl, typeAttributes);
    }

    @Override
    public CapturedType refine(KotlinTypeRefiner object) {
        Intrinsics.checkNotNullParameter(object, "kotlinTypeRefiner");
        CapturedType capturedType = typeProjection;
        TypeProjection typeProjection = capturedType.typeProjection.refine((KotlinTypeRefiner)object);
        Intrinsics.checkNotNullExpressionValue(typeProjection, "typeProjection.refine(kotlinTypeRefiner)");
        object = capturedType.getConstructor();
        boolean bl = capturedType.isMarkedNullable();
        TypeAttributes typeAttributes = capturedType.getAttributes();
        return new CapturedType(typeProjection, (CapturedTypeConstructor)object, bl, typeAttributes);
    }
}

