/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public abstract class ClassifierBasedTypeConstructor
implements TypeConstructor {
    private int hashCode;

    private final boolean hasMeaningfulFqName(ClassifierDescriptor classifierDescriptor) {
        return !ErrorUtils.isError(classifierDescriptor) && !DescriptorUtils.isLocal(classifierDescriptor);
    }

    @Override
    public abstract ClassifierDescriptor getDeclarationDescriptor();

    public int hashCode() {
        int n = this.hashCode;
        if (n != 0) {
            return n;
        }
        ClassifierBasedTypeConstructor classifierBasedTypeConstructor = this;
        ClassifierDescriptor classifierDescriptor = classifierBasedTypeConstructor.getDeclarationDescriptor();
        int n2 = classifierBasedTypeConstructor.hasMeaningfulFqName(classifierDescriptor) ? DescriptorUtils.getFqName(classifierDescriptor).hashCode() : System.identityHashCode(this);
        this.hashCode = n2;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypeConstructor)) {
            return false;
        }
        if (object.hashCode() != this.hashCode()) {
            return false;
        }
        if ((object = (TypeConstructor)object).getParameters().size() != this.getParameters().size()) {
            return false;
        }
        Object object2 = object;
        object = this.getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = object2.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        if (this.hasMeaningfulFqName((ClassifierDescriptor)object) && this.hasMeaningfulFqName(classifierDescriptor)) {
            return this.isSameClassifier(classifierDescriptor);
        }
        return false;
    }

    protected abstract boolean isSameClassifier(ClassifierDescriptor var1);

    protected final boolean areFqNamesEqual(ClassifierDescriptor declarationDescriptor, ClassifierDescriptor classifierDescriptor) {
        Intrinsics.checkNotNullParameter(declarationDescriptor, "first");
        Intrinsics.checkNotNullParameter(classifierDescriptor, "second");
        if (!Intrinsics.areEqual(declarationDescriptor.getName(), classifierDescriptor.getName())) {
            return false;
        }
        Object object = declarationDescriptor.getContainingDeclaration();
        for (declarationDescriptor = classifierDescriptor.getContainingDeclaration(); object != null && declarationDescriptor != null; object = object.getContainingDeclaration(), declarationDescriptor = declarationDescriptor.getContainingDeclaration()) {
            if (object instanceof ModuleDescriptor) {
                return declarationDescriptor instanceof ModuleDescriptor;
            }
            if (declarationDescriptor instanceof ModuleDescriptor) {
                return false;
            }
            if (object instanceof PackageFragmentDescriptor) {
                return declarationDescriptor instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)object).getFqName(), ((PackageFragmentDescriptor)declarationDescriptor).getFqName());
            }
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                return false;
            }
            if (Intrinsics.areEqual(object.getName(), declarationDescriptor.getName())) continue;
            return false;
        }
        return true;
    }
}

