/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;

public abstract class FlexibleTypesKt {
    public static final boolean isFlexible(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        return kotlinType2.unwrap() instanceof FlexibleType;
    }

    public static final FlexibleType asFlexibleType(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        UnwrappedType unwrappedType = kotlinType2.unwrap();
        Intrinsics.checkNotNull(unwrappedType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.FlexibleType");
        return (FlexibleType)unwrappedType;
    }

    public static final SimpleType lowerIfFlexible(KotlinType kotlinType) {
        block4: {
            SimpleType simpleType2;
            block3: {
                block2: {
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
                    kotlinType = kotlinType2.unwrap();
                    if (!(kotlinType instanceof FlexibleType)) break block2;
                    simpleType2 = ((FlexibleType)kotlinType).getLowerBound();
                    break block3;
                }
                if (!(kotlinType instanceof SimpleType)) break block4;
                simpleType2 = (SimpleType)kotlinType;
            }
            return simpleType2;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final SimpleType upperIfFlexible(KotlinType kotlinType) {
        block4: {
            SimpleType simpleType2;
            block3: {
                block2: {
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
                    kotlinType = kotlinType2.unwrap();
                    if (!(kotlinType instanceof FlexibleType)) break block2;
                    simpleType2 = ((FlexibleType)kotlinType).getUpperBound();
                    break block3;
                }
                if (!(kotlinType instanceof SimpleType)) break block4;
                simpleType2 = (SimpleType)kotlinType;
            }
            return simpleType2;
        }
        throw new NoWhenBranchMatchedException();
    }
}

