/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.NotNullSimpleType;
import kotlin.reflect.jvm.internal.impl.types.NullableSimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleTypeWithAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;

final class SimpleTypeImpl
extends SimpleType {
    private final TypeConstructor constructor;
    private final List arguments;
    private final boolean isMarkedNullable;
    private final MemberScope memberScope;
    private final Function1 refinedTypeFactory;

    public SimpleTypeImpl(TypeConstructor typeConstructor2, List list, boolean bl, MemberScope memberScope2, Function1 function1) {
        Intrinsics.checkNotNullParameter(typeConstructor2, "constructor");
        Intrinsics.checkNotNullParameter(list, "arguments");
        Intrinsics.checkNotNullParameter(memberScope2, "memberScope");
        Intrinsics.checkNotNullParameter(function1, "refinedTypeFactory");
        this.constructor = typeConstructor2;
        this.arguments = list;
        this.isMarkedNullable = bl;
        this.memberScope = memberScope2;
        this.refinedTypeFactory = function1;
        if (this.getMemberScope() instanceof ErrorScope && !(this.getMemberScope() instanceof ThrowingScope)) {
            throw new IllegalStateException("SimpleTypeImpl should not be created for error type: " + this.getMemberScope() + '\n' + this.getConstructor());
        }
    }

    @Override
    public TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public List getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    @Override
    public MemberScope getMemberScope() {
        return this.memberScope;
    }

    @Override
    public TypeAttributes getAttributes() {
        return TypeAttributes.Companion.getEmpty();
    }

    @Override
    public SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        TypeAttributes typeAttributes2 = typeAttributes;
        Intrinsics.checkNotNullParameter(typeAttributes2, "newAttributes");
        if (!typeAttributes2.isEmpty()) {
            SimpleTypeWithAttributes simpleTypeWithAttributes;
            SimpleTypeWithAttributes simpleTypeWithAttributes2 = simpleTypeWithAttributes;
            simpleTypeWithAttributes = new SimpleTypeWithAttributes(simpleType2, typeAttributes);
            SimpleType simpleType2 = simpleTypeWithAttributes2;
        }
        return simpleType2;
    }

    @Override
    public SimpleType makeNullableAsSpecified(boolean bl) {
        if (bl != simpleType2.isMarkedNullable()) {
            SimpleType simpleType2;
            if (bl) {
                NullableSimpleType nullableSimpleType;
                NullableSimpleType nullableSimpleType2 = nullableSimpleType;
                nullableSimpleType = new NullableSimpleType(simpleType2);
                simpleType2 = nullableSimpleType2;
            } else {
                NotNullSimpleType notNullSimpleType;
                NotNullSimpleType notNullSimpleType2 = notNullSimpleType;
                notNullSimpleType = new NotNullSimpleType(simpleType2);
                simpleType2 = notNullSimpleType2;
            }
        }
        return simpleType2;
    }

    @Override
    public SimpleType refine(KotlinTypeRefiner object) {
        Intrinsics.checkNotNullParameter(object, "kotlinTypeRefiner");
        object = (SimpleType)((SimpleTypeImpl)object2).refinedTypeFactory.invoke(object);
        if (object != null) {
            Object object2 = object;
        }
        return object2;
    }
}

