/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.Collection;
import kotlin.collections.AbstractList;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.CharsKt__CharKt;
import kotlin.text.StringsKt;
import kotlin.text.StringsKt__StringNumberConversionsKt;
import kotlin.text.StringsKt__StringsKt;

abstract class StringsKt__StringsJVMKt
extends StringsKt__StringNumberConversionsKt {
    public static boolean equals(String string, String string2, boolean bl) {
        if (string == null) {
            return string2 == null;
        }
        return !bl ? string.equals(string2) : string.equalsIgnoreCase(string2);
    }

    public static final String replace(String string, char c, char c2, boolean bl) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(string, "<this>");
        if (!bl) {
            String string2 = string.replace(c, c2);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026replace(oldChar, newChar)");
            return string2;
        }
        int n = string.length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n);
        for (n = 0; n < string.length(); ++n) {
            char c3 = string.charAt(n);
            if (CharsKt__CharKt.equals(c3, c, bl)) {
                c3 = c2;
            }
            stringBuilder2.append(c3);
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string3;
    }

    public static /* synthetic */ String replace$default(String string, char c, char c2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return StringsKt__StringsJVMKt.replace(string, c, c2, bl);
    }

    public static final String replace(String string, String string2, String string3, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "oldValue");
        Intrinsics.checkNotNullParameter(string3, "newValue");
        int n = StringsKt__StringsKt.indexOf((CharSequence)string, string2, 0, bl);
        if (n < 0) {
            return string;
        }
        int n2 = string2.length();
        int n3 = RangesKt.coerceAtLeast(n2, 1);
        int n4 = string.length() - n2 + string3.length();
        if (n4 >= 0) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder(n4);
            n4 = 0;
            do {
                stringBuilder2.append(string, n4, n).append(string3);
                n4 = n + n2;
            } while (n < string.length() && (n = StringsKt__StringsKt.indexOf((CharSequence)string, string2, n + n3, bl)) > 0);
            String string4 = string;
            String string5 = stringBuilder2.append(string4, n4, string4.length()).toString();
            Intrinsics.checkNotNullExpressionValue(string5, "stringBuilder.append(this, i, length).toString()");
            return string5;
        }
        throw new OutOfMemoryError();
    }

    public static /* synthetic */ String replace$default(String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return StringsKt__StringsJVMKt.replace(string, string2, string3, bl);
    }

    public static String concatToString(char[] cArray) {
        Intrinsics.checkNotNullParameter(cArray, "<this>");
        return new String(cArray);
    }

    public static String concatToString(char[] cArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(cArray, "<this>");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(n, n2, cArray.length);
        return new String(cArray, n, n2 - n);
    }

    public static boolean startsWith(String string, String string2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "prefix");
        if (!bl) {
            return string.startsWith(string2);
        }
        int n = string2.length();
        return StringsKt__StringsJVMKt.regionMatches(string, 0, string2, 0, n, bl);
    }

    public static /* synthetic */ boolean startsWith$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.startsWith(string, string2, bl);
    }

    public static boolean startsWith(String string, String string2, int n, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "prefix");
        if (!bl) {
            return string.startsWith(string2, n);
        }
        int n2 = string2.length();
        return StringsKt__StringsJVMKt.regionMatches(string, n, string2, 0, n2, bl);
    }

    public static /* synthetic */ boolean startsWith$default(String string, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return StringsKt.startsWith(string, string2, n, bl);
    }

    public static boolean endsWith(String string, String string2, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "suffix");
        if (!bl) {
            return string.endsWith(string2);
        }
        int n = string.length() - string2.length();
        int n2 = string2.length();
        return StringsKt__StringsJVMKt.regionMatches(string, n, string2, 0, n2, true);
    }

    public static /* synthetic */ boolean endsWith$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return StringsKt.endsWith(string, string2, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBlank(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        Intrinsics.checkNotNullParameter(charSequence2, "<this>");
        if (charSequence2.length() == 0) return true;
        Object object = StringsKt.getIndices(charSequence);
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return true;
        }
        object = object.iterator();
        do {
            if (!object.hasNext()) return true;
        } while (CharsKt.isWhitespace(charSequence.charAt(((IntIterator)object).nextInt())));
        return false;
    }

    public static final boolean regionMatches(String string, int n, String string2, int n2, int n3, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string2, "other");
        return !bl ? string.regionMatches(n, string2, n2, n3) : string.regionMatches(bl, n, string2, n2, n3);
    }

    public static String repeat(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "<this>");
        if (n >= 0) {
            if (n != 0) {
                if (n != 1) {
                    int n2 = charSequence.length();
                    if (n2 != 0) {
                        if (n2 != 1) {
                            StringBuilder stringBuilder;
                            StringBuilder stringBuilder2 = stringBuilder;
                            stringBuilder = new StringBuilder(n * charSequence.length());
                            IntIterator intIterator = new IntRange(1, n).iterator();
                            while (intIterator.hasNext()) {
                                intIterator.nextInt();
                                stringBuilder2.append(charSequence);
                            }
                            charSequence = stringBuilder2.toString();
                            Intrinsics.checkNotNullExpressionValue(charSequence, "{\n                    va\u2026tring()\n                }");
                        } else {
                            String string;
                            char c = charSequence.charAt(0);
                            char[] cArray = new char[n];
                            for (n2 = 0; n2 < n; ++n2) {
                                cArray[n2] = c;
                            }
                            charSequence = string;
                            string = new String(cArray);
                        }
                    } else {
                        charSequence = "";
                    }
                } else {
                    charSequence = ((Object)charSequence).toString();
                }
            } else {
                charSequence = "";
            }
            return charSequence;
        }
        charSequence = "Count 'n' must be non-negative, but was " + n + '.';
        throw new IllegalArgumentException(((Object)charSequence).toString());
    }
}

