/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Headers$Builder;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;

public class Request$Builder {
    private HttpUrl url;
    private String method;
    private Headers$Builder headers;
    private RequestBody body;
    private Map tags;

    public Request$Builder() {
        Headers$Builder headers$Builder;
        LinkedHashMap linkedHashMap;
        Object object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1.tags = object;
        v1.method = "GET";
        object = headers$Builder;
        headers$Builder = new Headers$Builder();
        v1.headers = object;
    }

    public Request$Builder(Request request) {
        Map map;
        Intrinsics.checkNotNullParameter(request, "request");
        this.tags = new LinkedHashMap();
        this.url = request.url();
        this.method = request.method();
        this.body = request.body();
        if (request.getTags$okhttp().isEmpty()) {
            LinkedHashMap linkedHashMap;
            map = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
        } else {
            map = MapsKt.toMutableMap(request.getTags$okhttp());
        }
        this.tags = map;
        this.headers = request.headers().newBuilder();
    }

    public final void setUrl$okhttp(HttpUrl httpUrl) {
        this.url = httpUrl;
    }

    public final void setMethod$okhttp(String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.method = string;
    }

    public final Headers$Builder getHeaders$okhttp() {
        return this.headers;
    }

    public final void setHeaders$okhttp(Headers$Builder headers$Builder) {
        Intrinsics.checkNotNullParameter(headers$Builder, "<set-?>");
        this.headers = headers$Builder;
    }

    public final void setBody$okhttp(RequestBody requestBody) {
        this.body = requestBody;
    }

    public Request$Builder url(HttpUrl httpUrl) {
        Request$Builder request$Builder = this;
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        request$Builder.setUrl$okhttp(httpUrl);
        return request$Builder;
    }

    public Request$Builder url(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "url");
        if (StringsKt.startsWith(string2, "ws:", true)) {
            string = string.substring(3);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            string = Intrinsics.stringPlus("http:", string);
        } else if (StringsKt.startsWith(string, "wss:", true)) {
            string = string.substring(4);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            string = Intrinsics.stringPlus("https:", string);
        }
        return this.url(HttpUrl.Companion.get(string));
    }

    public Request$Builder header(String string, String string2) {
        Request$Builder request$Builder = this;
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(string2, "value");
        request$Builder.getHeaders$okhttp().set(string, string2);
        return request$Builder;
    }

    public Request$Builder removeHeader(String string) {
        Request$Builder request$Builder = this;
        Intrinsics.checkNotNullParameter(string, "name");
        request$Builder.getHeaders$okhttp().removeAll(string);
        return request$Builder;
    }

    public Request$Builder headers(Headers headers) {
        Request$Builder request$Builder = this;
        Headers headers2 = headers;
        Intrinsics.checkNotNullParameter(headers2, "headers");
        request$Builder.setHeaders$okhttp(headers2.newBuilder());
        return request$Builder;
    }

    public Request$Builder get() {
        return this.method("GET", null);
    }

    public Request$Builder post(RequestBody requestBody) {
        Intrinsics.checkNotNullParameter(requestBody, "body");
        return this.method("POST", requestBody);
    }

    public Request$Builder method(String string, RequestBody requestBody) {
        block5: {
            Object object;
            block8: {
                block7: {
                    block6: {
                        String string2 = string;
                        Intrinsics.checkNotNullParameter(string2, "method");
                        if (!(string2.length() > 0)) break block5;
                        if (requestBody != null) break block6;
                        if (!(HttpMethod.requiresRequestBody(string) ^ true)) {
                            object = "method " + string + " must have a request body.";
                            throw new IllegalArgumentException(object.toString());
                        }
                        break block7;
                    }
                    if (!HttpMethod.permitsRequestBody(string)) break block8;
                }
                Request$Builder request$Builder = object;
                request$Builder.setMethod$okhttp(string);
                request$Builder.setBody$okhttp(requestBody);
                return request$Builder;
            }
            object = "method " + string + " must not have a request body.";
            throw new IllegalArgumentException(object.toString());
        }
        throw new IllegalArgumentException("method.isEmpty() == true".toString());
    }

    public Request build() {
        HttpUrl httpUrl = ((Request$Builder)((Object)string)).url;
        if (httpUrl != null) {
            Request$Builder request$Builder = string;
            String string = request$Builder.method;
            Headers headers = request$Builder.headers.build();
            RequestBody requestBody = request$Builder.body;
            Map map = Util.toImmutableMap(request$Builder.tags);
            return new Request(httpUrl, string, headers, requestBody, map);
        }
        throw new IllegalStateException("url == null".toString());
    }
}

