/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okio.BufferedSource;

public final class ResponseBody$BomAwareReader
extends Reader {
    private final BufferedSource source;
    private final Charset charset;
    private boolean closed;
    private Reader delegate;

    public ResponseBody$BomAwareReader(BufferedSource bufferedSource, Charset charset) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Intrinsics.checkNotNullParameter(charset, "charset");
        this.source = bufferedSource;
        this.charset = charset;
    }

    @Override
    public int read(char[] cArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(cArray, "cbuf");
        if (!this.closed) {
            Reader reader = this.delegate;
            if (reader == null) {
                InputStreamReader inputStreamReader;
                reader = inputStreamReader;
                this.delegate = new InputStreamReader(this.source.inputStream(), Util.readBomAsCharset(this.source, this.charset));
            }
            return reader.read(cArray, n, n2);
        }
        throw new IOException("Stream closed");
    }

    @Override
    public void close() {
        Unit unit;
        this.closed = true;
        Reader reader = this.delegate;
        if (reader == null) {
            unit = null;
        } else {
            reader.close();
            unit = Unit.INSTANCE;
        }
        if (unit == null) {
            this.source.close();
        }
    }
}

