/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.OpenJSSEPlatform$Companion;
import okhttp3.internal.platform.Platform;
import org.openjsse.javax.net.ssl.SSLSocket;
import org.openjsse.net.ssl.OpenJSSE;

public final class OpenJSSEPlatform
extends Platform {
    public static final OpenJSSEPlatform$Companion Companion;
    private static final boolean isSupported;
    private final Provider provider = (Provider)new OpenJSSE();

    private OpenJSSEPlatform() {
    }

    public static final /* synthetic */ boolean access$isSupported$cp() {
        return isSupported;
    }

    public /* synthetic */ OpenJSSEPlatform(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    static {
        boolean bl;
        OpenJSSEPlatform$Companion openJSSEPlatform$Companion;
        OpenJSSEPlatform$Companion openJSSEPlatform$Companion2 = openJSSEPlatform$Companion;
        Companion = new OpenJSSEPlatform$Companion(null);
        String string = "org.openjsse.net.ssl.OpenJSSE";
        try {
            Class.forName(string, false, openJSSEPlatform$Companion2.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        bl = true;
        isSupported = bl;
    }

    @Override
    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.3", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLSv1.3\", provider)");
        return sSLContext;
    }

    @Override
    public X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), ((OpenJSSEPlatform)object).provider);
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                return (X509TrustManager)object;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        object = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(object, "toString(this)");
        object = Intrinsics.stringPlus("Unexpected default trust managers: ", object);
        throw new IllegalStateException(object.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configureTlsExtensions(javax.net.ssl.SSLSocket object, String string, List stringArray) {
        Intrinsics.checkNotNullParameter(object, "sslSocket");
        Intrinsics.checkNotNullParameter(stringArray, "protocols");
        if (object instanceof SSLSocket) {
            OpenJSSEPlatform openJSSEPlatform = (SSLSocket)object;
            if (!((object = openJSSEPlatform.getSSLParameters()) instanceof org.openjsse.javax.net.ssl.SSLParameters)) return;
            string = (org.openjsse.javax.net.ssl.SSLParameters)object;
            if ((stringArray = Platform.Companion.alpnProtocolNames((List)stringArray).toArray(new String[0])) == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            string.setApplicationProtocols(stringArray);
            openJSSEPlatform.setSSLParameters((SSLParameters)object);
            return;
        } else {
            super.configureTlsExtensions((javax.net.ssl.SSLSocket)object, string, (List)stringArray);
        }
    }

    @Override
    public String getSelectedProtocol(javax.net.ssl.SSLSocket sSLSocket) {
        Object object;
        javax.net.ssl.SSLSocket sSLSocket2 = sSLSocket;
        Intrinsics.checkNotNullParameter(sSLSocket2, "sslSocket");
        if (sSLSocket2 instanceof SSLSocket) {
            object = ((SSLSocket)sSLSocket).getApplicationProtocol();
            if (object == null ? true : Intrinsics.areEqual(object, "")) {
                object = null;
            }
        } else {
            object = super.getSelectedProtocol(sSLSocket);
        }
        return object;
    }
}

