/*
 * Decompiled with CFR 0.152.
 */
package cc.ekblad.toml.transcoding;

import cc.ekblad.toml.model.TomlException$DecodingError;
import cc.ekblad.toml.model.TomlValue;
import cc.ekblad.toml.model.TomlValue$List;
import cc.ekblad.toml.model.TomlValue$Map;
import cc.ekblad.toml.model.TomlValue$String;
import cc.ekblad.toml.transcoding.TomlDecoder;
import cc.ekblad.toml.transcoding.TomlDecoder$Pass;
import cc.ekblad.toml.util.KTypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.KCallablesJvm;

public abstract class TomlDecoderKt {
    private static final KType anyKType = KClassifiers.createType$default(Reflection.getOrCreateKotlinClass(Object.class), null, false, null, 7, null);
    private static final KType stringKType = KClassifiers.createType$default(Reflection.getOrCreateKotlinClass(String.class), null, false, null, 7, null);

    public static final Object decode(TomlDecoder tomlDecoder, TomlValue tomlValue, KType kType) {
        block9: {
            Object object;
            block7: {
                block8: {
                    block6: {
                        KType kType2 = kType;
                        Intrinsics.checkNotNullParameter(tomlDecoder, "<this>");
                        Intrinsics.checkNotNullParameter(tomlValue, "value");
                        Intrinsics.checkNotNullParameter(kType2, "target");
                        Function2 function2 = tomlDecoder.decoderFor$4koma(TomlDecoderKt.requireKClass(kType2.getClassifier()));
                        if (function2 != null) {
                            try {
                                return function2.invoke(kType, tomlValue);
                            }
                            catch (TomlDecoder$Pass tomlDecoder$Pass) {}
                        }
                        if (!(tomlValue instanceof TomlValue$List)) break block6;
                        object = TomlDecoderKt.toList(tomlDecoder, (TomlValue$List)tomlValue, kType);
                        break block7;
                    }
                    if (!(tomlValue instanceof TomlValue$Map)) break block8;
                    object = TomlDecoderKt.toObject(tomlDecoder, (TomlValue$Map)tomlValue, kType);
                    break block7;
                }
                if (!(tomlValue instanceof TomlValue$String)) break block9;
                object = TomlDecoderKt.toEnum((TomlValue$String)tomlValue, kType);
            }
            return object;
        }
        throw TomlDecoderKt.noDecoder(tomlValue, kType);
    }

    private static final TomlException$DecodingError noDecoder(TomlValue tomlValue, KType kType) {
        return new TomlException$DecodingError("no decoder registered for value/target pair", tomlValue, kType);
    }

    private static final Object toEnum(TomlValue$String tomlValue$String, KType kType) {
        block8: {
            Enum enum_;
            KClass kClass;
            block9: {
                block7: {
                    kClass = TomlDecoderKt.requireKClass(kType.getClassifier());
                    if (!KClasses.isSubclassOf(kClass, Reflection.getOrCreateKotlinClass(Enum.class))) break block8;
                    T[] TArray = JvmClassMappingKt.getJavaClass(kClass).getEnumConstants();
                    Intrinsics.checkNotNull(TArray, "null cannot be cast to non-null type kotlin.Array<kotlin.Enum<*>>");
                    Enum[] enumArray = (Enum[])TArray;
                    enum_ = null;
                    boolean bl = false;
                    for (Enum enum_2 : enumArray) {
                        if (!Intrinsics.areEqual(enum_2.name(), tomlValue$String.getValue())) continue;
                        if (!bl) {
                            boolean bl2;
                            bl = bl2 = true;
                            enum_ = enum_2;
                            continue;
                        }
                        break block7;
                    }
                    if (bl) break block9;
                }
                enum_ = null;
            }
            if (enum_ != null) {
                return enum_;
            }
            throw new TomlException$DecodingError(tomlValue$String.getValue() + " is not a constructor of enum class " + kClass.getSimpleName(), tomlValue$String, kType);
        }
        throw TomlDecoderKt.noDecoder(tomlValue$String, kType);
    }

    private static final Object toList(TomlDecoder object, TomlValue$List object2, KType kType) {
        block12: {
            block8: {
                KClass kClass;
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                kClass = TomlDecoderKt.requireKClass(kType.getClassifier());
                                if (!Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(List.class))) break block7;
                                object2 = ((TomlValue$List)object2).getElements();
                                if ((kType = ((KTypeProjection)CollectionsKt.single(kType.getArguments())).getType()) == null) {
                                    kType = anyKType;
                                }
                                object = TomlDecoderKt.decodeList((TomlDecoder)object, (List)object2, kType);
                                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toList");
                                break block8;
                            }
                            if (!Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Set.class))) break block9;
                            object2 = ((TomlValue$List)object2).getElements();
                            if ((kType = ((KTypeProjection)CollectionsKt.single(kType.getArguments())).getType()) == null) {
                                kType = anyKType;
                            }
                            object = CollectionsKt.toSet(TomlDecoderKt.decodeList((TomlDecoder)object, (List)object2, kType));
                            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toList");
                            break block8;
                        }
                        if (!Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Collection.class))) break block10;
                        object2 = ((TomlValue$List)object2).getElements();
                        if ((kType = ((KTypeProjection)CollectionsKt.single(kType.getArguments())).getType()) == null) {
                            kType = anyKType;
                        }
                        object = TomlDecoderKt.decodeList((TomlDecoder)object, (List)object2, kType);
                        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toList");
                        break block8;
                    }
                    if (!Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Iterable.class))) break block11;
                    object2 = ((TomlValue$List)object2).getElements();
                    if ((kType = ((KTypeProjection)CollectionsKt.single(kType.getArguments())).getType()) == null) {
                        kType = anyKType;
                    }
                    object = TomlDecoderKt.decodeList((TomlDecoder)object, (List)object2, kType);
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toList");
                    break block8;
                }
                if (!Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Object.class))) break block12;
                object = TomlDecoderKt.decodeList((TomlDecoder)object, ((TomlValue$List)object2).getElements(), anyKType);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toList");
            }
            return object;
        }
        throw new TomlException$DecodingError("lists can only be decoded into lists, sets, collections or iterables", (TomlValue)object2, kType);
    }

    private static final List decodeList(TomlDecoder tomlDecoder, List object, KType kType) {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(TomlDecoderKt.decode(tomlDecoder, (TomlValue)object.next(), kType));
        }
        return arrayList2;
    }

    private static final Object toObject(TomlDecoder object, TomlValue$Map tomlValue$Map, KType kType) {
        block6: {
            block3: {
                KClass kClass;
                block5: {
                    block4: {
                        block2: {
                            kClass = TomlDecoderKt.requireKClass(kType.getClassifier());
                            if (!Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Map.class))) break block2;
                            object = TomlDecoderKt.toMap((TomlDecoder)object, tomlValue$Map, kType);
                            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toObject");
                            break block3;
                        }
                        if (!Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(SortedMap.class))) break block4;
                        object = MapsKt.toSortedMap(TomlDecoderKt.toMap((TomlDecoder)object, tomlValue$Map, kType));
                        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toObject");
                        break block3;
                    }
                    if (!Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Object.class))) break block5;
                    object = TomlDecoderKt.toMap((TomlDecoder)object, tomlValue$Map, KClassifiers.createType$default(Reflection.getOrCreateKotlinClass(Object.class), null, false, null, 7, null));
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toObject");
                    break block3;
                }
                if (KClasses.getPrimaryConstructor(kClass) == null) break block6;
                object = TomlDecoderKt.toDataClass((TomlDecoder)object, tomlValue$Map, kType, kClass);
            }
            return object;
        }
        throw new TomlException$DecodingError("objects can only be decoded into maps, data classes, or types for which a custom decoder function has been registered", tomlValue$Map, kType);
    }

    private static final Map toMap(TomlDecoder tomlDecoder, TomlValue$Map iterator2, KType object) {
        Object object2;
        Object[] objectArray = new KType[3];
        objectArray[0] = null;
        Object object3 = anyKType;
        objectArray[1] = object3;
        objectArray[2] = stringKType;
        Set<Object> set = SetsKt.setOf(objectArray);
        if (set.contains(object2 = (object2 = (KTypeProjection)CollectionsKt.firstOrNull(object.getArguments())) != null ? ((KTypeProjection)object2).getType() : null)) {
            LinkedHashMap linkedHashMap;
            if ((object = (KTypeProjection)CollectionsKt.getOrNull(object.getArguments(), 1)) != null && (object = ((KTypeProjection)object).getType()) != null) {
                object3 = object;
            }
            iterator2 = ((TomlValue$Map)((Object)iterator2)).getProperties();
            object = linkedHashMap;
            linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity(iterator2.size()));
            for (Map.Entry entry : iterator2.entrySet()) {
                set = entry.getKey();
                object.put(set, TomlDecoderKt.decode(tomlDecoder, (TomlValue)entry.getValue(), (KType)object3));
            }
            return object;
        }
        throw new TomlException$DecodingError("when decoding an object into a map, that map must have keys of type String or Any", (TomlValue)((Object)iterator2), (KType)object);
    }

    private static final Object toDataClass(TomlDecoder tomlDecoder, TomlValue$Map tomlValue$Map, KType kType, KClass kClass) {
        ArrayList<Pair> arrayList;
        LinkedHashMap<Object, Object> linkedHashMap;
        KClass kClass2 = kClass;
        KFunction kFunction = KClasses.getPrimaryConstructor(kClass2);
        Intrinsics.checkNotNull(kFunction);
        Map map = tomlDecoder.mappingFor$4koma(kClass2);
        LinkedHashMap<Object, Object> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Object, Object>();
        Object object = kClass.getTypeParameters();
        List list = kType.getArguments();
        Object object22 = object.iterator();
        Object object3 = list.iterator();
        ArrayList<Pair> arrayList2 = arrayList;
        arrayList = new ArrayList<Pair>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10), CollectionsKt.collectionSizeOrDefault(list, 10)));
        while (object22.hasNext() && object3.hasNext()) {
            object = (KTypeProjection)object3.next();
            KTypeParameter kTypeParameter = (KTypeParameter)object22.next();
            KType kType2 = ((KTypeProjection)object).getType();
            Intrinsics.checkNotNull(kType2);
            arrayList2.add(TuplesKt.to(kTypeParameter, kType2));
        }
        object = MapsKt.toMap(arrayList2);
        for (Object object22 : kFunction.getParameters()) {
            object3 = (String)map.get(object22.getName());
            if (object3 == null) {
                object3 = object22.getName();
            }
            if ((object3 = (TomlValue)tomlValue$Map.getProperties().get(object3)) == null && object22.isOptional()) continue;
            if ((object3 = object3 != null ? TomlDecoderKt.decode(tomlDecoder, (TomlValue)object3, KTypeUtilsKt.subst(object22.getType(), (Map)object)) : null) == null) {
                object3 = tomlDecoder.defaultValueFor$4koma(kClass, (KParameter)object22);
            }
            if (!object22.getType().isMarkedNullable() && object3 == null) {
                throw new TomlException$DecodingError("no value found for non-nullable parameter '" + object22.getName() + '\'', tomlValue$Map, kType);
            }
            linkedHashMap2.put(object22, object3);
        }
        if (kClass.getVisibility() == KVisibility.PRIVATE) {
            KCallablesJvm.setAccessible(kFunction, true);
        }
        Object object4 = kFunction.callBy(linkedHashMap2);
        Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type T of cc.ekblad.toml.transcoding.TomlDecoderKt.toDataClass");
        return object4;
    }

    public static final KClass requireKClass(KClassifier object) {
        KClass kClass = object instanceof KClass ? (KClass)object : null;
        if (kClass != null) {
            return kClass;
        }
        object = "classifier '" + object + "' is not a KClass; you can only decode to concrete types";
        throw new IllegalArgumentException(object.toString());
    }
}

