/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class JsonWriter
implements Closeable,
Flushable {
    private static final Pattern VALID_JSON_NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private int[] stack;
    private int stackSize;
    private String indent;
    private String separator;
    private boolean lenient;
    private boolean htmlSafe;
    private String deferredName;
    private boolean serializeNulls;

    public JsonWriter(Writer writer) {
        JsonWriter jsonWriter = this;
        jsonWriter.stack = new int[32];
        jsonWriter.stackSize = 0;
        jsonWriter.push(6);
        jsonWriter.separator = ":";
        jsonWriter.serializeNulls = true;
        if (writer != null) {
            this.out = writer;
            return;
        }
        throw new NullPointerException("out == null");
    }

    private JsonWriter open(int n, char c) {
        JsonWriter jsonWriter = this;
        this.beforeValue();
        jsonWriter.push(n);
        jsonWriter.out.write(c);
        return jsonWriter;
    }

    private JsonWriter close(int n, int n2, char c) {
        int n3 = this.peek();
        if (n3 != n2 && n3 != n) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName == null) {
            --this.stackSize;
            if (n3 == n2) {
                this.newline();
            }
            JsonWriter jsonWriter = this;
            jsonWriter.out.write(c);
            return jsonWriter;
        }
        throw new IllegalStateException("Dangling name: " + this.deferredName);
    }

    private void push(int n) {
        int n2 = this.stackSize;
        int[] nArray = this.stack;
        if (n2 == this.stack.length) {
            this.stack = Arrays.copyOf(nArray, n2 * 2);
        }
        int n3 = this.stackSize;
        this.stackSize = n3 + 1;
        this.stack[n3] = n;
    }

    private int peek() {
        int n = this.stackSize;
        if (n != 0) {
            return this.stack[n - 1];
        }
        throw new IllegalStateException("JsonWriter is closed.");
    }

    private void replaceTop(int n) {
        this.stack[this.stackSize - 1] = n;
    }

    private void writeDeferredName() {
        if (this.deferredName != null) {
            JsonWriter jsonWriter = this;
            jsonWriter.beforeName();
            jsonWriter.string(jsonWriter.deferredName);
            jsonWriter.deferredName = null;
        }
    }

    private static boolean isTrustedNumberType(Class clazz) {
        return clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Byte.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == AtomicInteger.class || clazz == AtomicLong.class;
    }

    private void string(String string) {
        String[] stringArray = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write(34);
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            String string2;
            char c = string.charAt(i);
            if (c < '\u0080') {
                string2 = stringArray[c];
                if (string2 == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n < i) {
                this.out.write(string, n, i - n);
            }
            this.out.write(string2);
            n = i + 1;
        }
        if (n < n2) {
            this.out.write(string, n, n2 - n);
        }
        this.out.write(34);
    }

    private void newline() {
        if (this.indent == null) {
            return;
        }
        JsonWriter jsonWriter = this;
        jsonWriter.out.write(10);
        int n = jsonWriter.stackSize;
        for (int i = 1; i < n; ++i) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() {
        block4: {
            block3: {
                int n;
                block2: {
                    n = this.peek();
                    if (n != 5) break block2;
                    this.out.write(44);
                    break block3;
                }
                if (n != 3) break block4;
            }
            JsonWriter jsonWriter = this;
            jsonWriter.newline();
            jsonWriter.replaceTop(4);
            return;
        }
        throw new IllegalStateException("Nesting problem.");
    }

    private void beforeValue() {
        switch (this.peek()) {
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                break;
            }
            case 4: {
                JsonWriter jsonWriter = this;
                jsonWriter.out.append(this.separator);
                jsonWriter.replaceTop(5);
                break;
            }
            case 2: {
                JsonWriter jsonWriter = this;
                jsonWriter.out.append(',');
                jsonWriter.newline();
                break;
            }
            case 1: {
                JsonWriter jsonWriter = this;
                jsonWriter.replaceTop(2);
                jsonWriter.newline();
            }
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = i;
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", objectArray2);
        }
        String[] stringArray = REPLACEMENT_CHARS;
        String[] stringArray2 = REPLACEMENT_CHARS;
        stringArray[34] = "\\\"";
        stringArray2[92] = "\\\\";
        stringArray[9] = "\\t";
        stringArray2[8] = "\\b";
        stringArray[10] = "\\n";
        stringArray2[13] = "\\r";
        stringArray[12] = "\\f";
        String[] stringArray3 = (String[])stringArray2.clone();
        HTML_SAFE_REPLACEMENT_CHARS = stringArray3;
        stringArray3[60] = "\\u003c";
        stringArray3[62] = "\\u003e";
        stringArray3[38] = "\\u0026";
        stringArray3[61] = "\\u003d";
        stringArray3[39] = "\\u0027";
    }

    public final void setIndent(String string) {
        if (string.length() == 0) {
            JsonWriter jsonWriter = this;
            jsonWriter.indent = null;
            jsonWriter.separator = ":";
        } else {
            JsonWriter jsonWriter = this;
            jsonWriter.indent = string;
            jsonWriter.separator = ": ";
        }
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final void setHtmlSafe(boolean bl) {
        this.htmlSafe = bl;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public final void setSerializeNulls(boolean bl) {
        this.serializeNulls = bl;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter beginArray() {
        JsonWriter jsonWriter = this;
        jsonWriter.writeDeferredName();
        return jsonWriter.open(1, '[');
    }

    public JsonWriter endArray() {
        return this.close(1, 2, ']');
    }

    public JsonWriter beginObject() {
        JsonWriter jsonWriter = this;
        jsonWriter.writeDeferredName();
        return jsonWriter.open(3, '{');
    }

    public JsonWriter endObject() {
        return this.close(3, 5, '}');
    }

    public JsonWriter name(String string) {
        if (string != null) {
            if (this.deferredName == null) {
                if (this.stackSize != 0) {
                    this.deferredName = string;
                    return this;
                }
                throw new IllegalStateException("JsonWriter is closed.");
            }
            throw new IllegalStateException();
        }
        throw new NullPointerException("name == null");
    }

    public JsonWriter value(String string) {
        if (string == null) {
            return this.nullValue();
        }
        JsonWriter jsonWriter = this;
        jsonWriter.writeDeferredName();
        jsonWriter.beforeValue();
        jsonWriter.string(string);
        return jsonWriter;
    }

    public JsonWriter nullValue() {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        JsonWriter jsonWriter = this;
        jsonWriter.beforeValue();
        jsonWriter.out.write("null");
        return jsonWriter;
    }

    public JsonWriter value(boolean bl) {
        JsonWriter jsonWriter = this;
        jsonWriter.writeDeferredName();
        jsonWriter.beforeValue();
        Writer writer = jsonWriter.out;
        String string = bl ? "true" : "false";
        writer.write(string);
        return this;
    }

    public JsonWriter value(Boolean object) {
        if (object == null) {
            return this.nullValue();
        }
        Boolean bl = object;
        JsonWriter jsonWriter = this;
        jsonWriter.writeDeferredName();
        jsonWriter.beforeValue();
        object = jsonWriter.out;
        String string = bl != false ? "true" : "false";
        ((Writer)object).write(string);
        return this;
    }

    public JsonWriter value(long l) {
        JsonWriter jsonWriter = this;
        jsonWriter.writeDeferredName();
        jsonWriter.beforeValue();
        jsonWriter.out.write(Long.toString(l));
        return jsonWriter;
    }

    public JsonWriter value(Number serializable) {
        String string;
        block8: {
            block7: {
                block6: {
                    if (serializable == null) {
                        return this.nullValue();
                    }
                    this.writeDeferredName();
                    string = serializable.toString();
                    if (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN")) break block6;
                    if (!JsonWriter.isTrustedNumberType(serializable = serializable.getClass()) && !VALID_JSON_NUMBER_PATTERN.matcher(string).matches()) {
                        throw new IllegalArgumentException("String created by " + serializable + " is not a valid JSON number: " + string);
                    }
                    break block7;
                }
                if (!this.lenient) break block8;
            }
            JsonWriter jsonWriter = this;
            jsonWriter.beforeValue();
            jsonWriter.out.append(string);
            return jsonWriter;
        }
        throw new IllegalArgumentException("Numeric values must be finite, but was " + string);
    }

    @Override
    public void flush() {
        if (this.stackSize != 0) {
            this.out.flush();
            return;
        }
        throw new IllegalStateException("JsonWriter is closed.");
    }

    @Override
    public void close() {
        JsonWriter jsonWriter = this;
        jsonWriter.out.close();
        int n = jsonWriter.stackSize;
        if (n <= 1 && (n != 1 || this.stack[n - 1] == 7)) {
            this.stackSize = 0;
            return;
        }
        throw new IOException("Incomplete document");
    }
}

