/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KVisibility;
import kotlin.reflect.jvm.internal.KClassImpl$Data;
import kotlin.reflect.jvm.internal.KClassImpl$WhenMappings;
import kotlin.reflect.jvm.internal.KClassImpl$data$1;
import kotlin.reflect.jvm.internal.KClassImpl$getLocalProperty$2$1$1;
import kotlin.reflect.jvm.internal.KClassifierImpl;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.KTypeParameterOwnerImpl;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.ReflectProperties;
import kotlin.reflect.jvm.internal.ReflectProperties$LazyVal;
import kotlin.reflect.jvm.internal.RuntimeTypeMapper;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Class;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Property;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite$GeneratedExtension;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import kotlin.text.StringsKt;

public final class KClassImpl
extends KDeclarationContainerImpl
implements KClass,
KClassifierImpl,
KTypeParameterOwnerImpl {
    private final Class jClass;
    private final ReflectProperties$LazyVal data;

    public KClassImpl(Class clazz) {
        Intrinsics.checkNotNullParameter(clazz, "jClass");
        ((KClassImpl)((Object)reflectProperties$LazyVal)).jClass = clazz;
        ReflectProperties$LazyVal reflectProperties$LazyVal = ReflectProperties.lazy(new KClassImpl$data$1((KClassImpl)((Object)reflectProperties$LazyVal)));
        Intrinsics.checkNotNullExpressionValue(reflectProperties$LazyVal, "lazy { Data() }");
        v0.data = reflectProperties$LazyVal;
    }

    private final ClassId getClassId() {
        return RuntimeTypeMapper.INSTANCE.mapJvmClassToKotlinClassId(this.getJClass());
    }

    private final Void reportUnresolvedClass() {
        Object object = ReflectKotlinClass.Factory.create(this.getJClass());
        object = object != null && (object = ((ReflectKotlinClass)object).getClassHeader()) != null ? ((KotlinClassHeader)object).getKind() : null;
        switch (object == null ? -1 : KClassImpl$WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 5: {
                throw new KotlinReflectionInternalError("Unknown class: " + this.getJClass() + " (kind = " + object + ')');
            }
            case 4: {
                throw new UnsupportedOperationException("This class is an internal synthetic class generated by the Kotlin compiler, such as an anonymous class for a lambda, a SAM wrapper, a callable reference, etc. It's not a Kotlin class or interface, so the reflection library has no idea what declarations it has. Please use Java reflection to inspect this class: " + this.getJClass());
            }
            case 1: 
            case 2: 
            case 3: {
                throw new UnsupportedOperationException("Packages and file facades are not yet supported in Kotlin reflection. Meanwhile please use Java reflection to inspect this class: " + this.getJClass());
            }
            case -1: 
            case 6: 
        }
        throw new KotlinReflectionInternalError("Unresolved class: " + this.getJClass());
    }

    public static final /* synthetic */ ClassId access$getClassId(KClassImpl kClassImpl) {
        return kClassImpl.getClassId();
    }

    public static final /* synthetic */ Void access$reportUnresolvedClass(KClassImpl kClassImpl) {
        return kClassImpl.reportUnresolvedClass();
    }

    @Override
    public Class getJClass() {
        return this.jClass;
    }

    public final ReflectProperties$LazyVal getData() {
        return this.data;
    }

    @Override
    public ClassDescriptor getDescriptor() {
        return ((KClassImpl$Data)this.data.invoke()).getDescriptor();
    }

    public final MemberScope getMemberScope$kotlin_reflection() {
        return this.getDescriptor().getDefaultType().getMemberScope();
    }

    public final MemberScope getStaticScope$kotlin_reflection() {
        MemberScope memberScope2 = this.getDescriptor().getStaticScope();
        Intrinsics.checkNotNullExpressionValue(memberScope2, "descriptor.staticScope");
        return memberScope2;
    }

    @Override
    public Collection getConstructorDescriptors() {
        if ((this = ((KClassImpl)this).getDescriptor()).getKind() != ClassKind.INTERFACE && this.getKind() != ClassKind.OBJECT) {
            Collection collection = this.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, "descriptor.constructors");
            return collection;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public Collection getProperties(Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        NoLookupLocation noLookupLocation = NoLookupLocation.FROM_REFLECTION;
        return CollectionsKt.plus(this.getMemberScope$kotlin_reflection().getContributedVariables(name, noLookupLocation), (Iterable)this.getStaticScope$kotlin_reflection().getContributedVariables(name, noLookupLocation));
    }

    @Override
    public Collection getFunctions(Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        NoLookupLocation noLookupLocation = NoLookupLocation.FROM_REFLECTION;
        return CollectionsKt.plus(this.getMemberScope$kotlin_reflection().getContributedFunctions(name, noLookupLocation), (Iterable)this.getStaticScope$kotlin_reflection().getContributedFunctions(name, noLookupLocation));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PropertyDescriptor getLocalProperty(int n) {
        Object object;
        if (Intrinsics.areEqual(((KClassImpl)((Object)nameResolver)).getJClass().getSimpleName(), "DefaultImpls") && (object = ((KClassImpl)((Object)nameResolver)).getJClass().getDeclaringClass()) != null && ((Class)object).isInterface()) {
            KClass kClass = JvmClassMappingKt.getKotlinClass((Class)object);
            Intrinsics.checkNotNull(kClass, "null cannot be cast to non-null type kotlin.reflect.jvm.internal.KClassImpl<*>");
            return ((KClassImpl)kClass).getLocalProperty(n);
        }
        object = ((KClassImpl)((Object)nameResolver)).getDescriptor();
        if (!(object instanceof DeserializedClassDescriptor)) return null;
        object = (DeserializedClassDescriptor)object;
        if (object == null) return null;
        ProtoBuf$Class protoBuf$Class = ((DeserializedClassDescriptor)object).getClassProto();
        GeneratedMessageLite$GeneratedExtension generatedMessageLite$GeneratedExtension = JvmProtoBuf.classLocalVariable;
        Intrinsics.checkNotNullExpressionValue(generatedMessageLite$GeneratedExtension, "classLocalVariable");
        Object object2 = (ProtoBuf$Property)ProtoBufUtilKt.getExtensionOrNull(protoBuf$Class, generatedMessageLite$GeneratedExtension, n);
        if (object2 == null) return null;
        Class clazz = ((KClassImpl)((Object)nameResolver)).getJClass();
        ProtoBuf$Property protoBuf$Property = object2;
        Object object3 = object;
        NameResolver nameResolver = ((DeserializedClassDescriptor)object3).getC().getNameResolver();
        object2 = ((DeserializedClassDescriptor)object3).getC().getTypeTable();
        object = ((DeserializedClassDescriptor)object3).getMetadataVersion();
        KClassImpl$getLocalProperty$2$1$1 kClassImpl$getLocalProperty$2$1$1 = KClassImpl$getLocalProperty$2$1$1.INSTANCE;
        return (PropertyDescriptor)UtilKt.deserializeToDescriptor(clazz, protoBuf$Property, nameResolver, (TypeTable)object2, (BinaryVersion)object, kClassImpl$getLocalProperty$2$1$1);
    }

    @Override
    public String getSimpleName() {
        return ((KClassImpl$Data)this.data.invoke()).getSimpleName();
    }

    @Override
    public String getQualifiedName() {
        return ((KClassImpl$Data)this.data.invoke()).getQualifiedName();
    }

    public Collection getConstructors() {
        return ((KClassImpl$Data)this.data.invoke()).getConstructors();
    }

    @Override
    public List getTypeParameters() {
        return ((KClassImpl$Data)this.data.invoke()).getTypeParameters();
    }

    @Override
    public List getSupertypes() {
        return ((KClassImpl$Data)this.data.invoke()).getSupertypes();
    }

    @Override
    public KVisibility getVisibility() {
        DescriptorVisibility descriptorVisibility = this.getDescriptor().getVisibility();
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "descriptor.visibility");
        return UtilKt.toKVisibility(descriptorVisibility);
    }

    @Override
    public boolean isData() {
        return this.getDescriptor().isData();
    }

    public boolean equals(Object object) {
        return object instanceof KClassImpl && Intrinsics.areEqual(JvmClassMappingKt.getJavaObjectType(this), JvmClassMappingKt.getJavaObjectType((KClass)object));
    }

    public int hashCode() {
        return JvmClassMappingKt.getJavaObjectType(this).hashCode();
    }

    public String toString() {
        KClassImpl kClassImpl = stringBuilder;
        StringBuilder stringBuilder = new StringBuilder().append("class ");
        ClassId classId = kClassImpl.getClassId();
        Object object = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(object, "classId.packageFqName");
        object = ((FqName)object).isRoot() ? "" : ((FqName)object).asString() + '.';
        String string = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "classId.relativeClassName.asString()");
        return stringBuilder.append((String)object + StringsKt.replace$default(string, '.', '$', false, 4, null)).toString();
    }
}

