/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.ref.WeakReference;
import kotlin.jvm.internal.Intrinsics;

final class WeakClassLoaderBox {
    private final WeakReference ref;
    private final int identityHashCode;
    private ClassLoader temporaryStrongRef;

    public WeakClassLoaderBox(ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        this.ref = new WeakReference<ClassLoader>(classLoader);
        this.identityHashCode = System.identityHashCode(classLoader);
        this.temporaryStrongRef = classLoader;
    }

    public final void setTemporaryStrongRef(ClassLoader classLoader) {
        this.temporaryStrongRef = classLoader;
    }

    public boolean equals(Object object) {
        return object instanceof WeakClassLoaderBox && this.ref.get() == ((WeakClassLoaderBox)object).ref.get();
    }

    public int hashCode() {
        return this.identityHashCode;
    }

    public String toString() {
        Object object = (ClassLoader)((WeakClassLoaderBox)object).ref.get();
        if (object == null || (object = object.toString()) == null) {
            object = "<null>";
        }
        return object;
    }
}

