/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.InvalidModuleExceptionKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleCapability;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor$DefaultImpls;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.CompositePackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependencies;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependenciesImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl$packageFragmentProviderForWholeModuleWithDependencies$2;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl$packages$1;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageViewDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageViewDescriptorFactory$Default;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.TargetPlatform;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

public final class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor {
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final Name stableName;
    private final Map capabilities;
    private final PackageViewDescriptorFactory packageViewDescriptorFactory;
    private ModuleDependencies dependencies;
    private PackageFragmentProvider packageFragmentProviderForModuleContent;
    private boolean isValid;
    private final MemoizedFunctionToNotNull packages;
    private final Lazy packageFragmentProviderForWholeModuleWithDependencies$delegate;

    public ModuleDescriptorImpl(Name object, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map map, Name name) {
        Intrinsics.checkNotNullParameter(object, "moduleName");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(kotlinBuiltIns, "builtIns");
        Intrinsics.checkNotNullParameter(map, "capabilities");
        super(Annotations.Companion.getEMPTY(), (Name)object);
        this.storageManager = storageManager;
        this.builtIns = kotlinBuiltIns;
        this.stableName = name;
        if (((Name)object).isSpecial()) {
            this.capabilities = map;
            object = (PackageViewDescriptorFactory)this.getCapability(PackageViewDescriptorFactory.Companion.getCAPABILITY());
            if (object == null) {
                object = PackageViewDescriptorFactory$Default.INSTANCE;
            }
            ModuleDescriptorImpl moduleDescriptorImpl = this;
            ModuleDescriptorImpl moduleDescriptorImpl2 = this;
            moduleDescriptorImpl2.packageViewDescriptorFactory = object;
            moduleDescriptorImpl2.isValid = true;
            moduleDescriptorImpl.packages = storageManager.createMemoizedFunction(new ModuleDescriptorImpl$packages$1(this));
            moduleDescriptorImpl.packageFragmentProviderForWholeModuleWithDependencies$delegate = LazyKt.lazy(new ModuleDescriptorImpl$packageFragmentProviderForWholeModuleWithDependencies$2(this));
            return;
        }
        throw new IllegalArgumentException("Module name must be special: " + object);
    }

    public /* synthetic */ ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map map, Name name2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            targetPlatform = null;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            name2 = null;
        }
        this(name, storageManager, kotlinBuiltIns, targetPlatform, map, name2);
    }

    private final CompositePackageFragmentProvider getPackageFragmentProviderForWholeModuleWithDependencies() {
        return (CompositePackageFragmentProvider)this.packageFragmentProviderForWholeModuleWithDependencies$delegate.getValue();
    }

    private final boolean isInitialized() {
        return this.packageFragmentProviderForModuleContent != null;
    }

    private final String getId() {
        String string = this.getName().toString();
        Intrinsics.checkNotNullExpressionValue(string, "name.toString()");
        return string;
    }

    public ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform) {
        Intrinsics.checkNotNullParameter(name, "moduleName");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(kotlinBuiltIns, "builtIns");
        this(name, storageManager, kotlinBuiltIns, targetPlatform, null, null, 48, null);
    }

    public static final /* synthetic */ PackageViewDescriptorFactory access$getPackageViewDescriptorFactory$p(ModuleDescriptorImpl moduleDescriptorImpl) {
        return moduleDescriptorImpl.packageViewDescriptorFactory;
    }

    public static final /* synthetic */ StorageManager access$getStorageManager$p(ModuleDescriptorImpl moduleDescriptorImpl) {
        return moduleDescriptorImpl.storageManager;
    }

    public static final /* synthetic */ ModuleDependencies access$getDependencies$p(ModuleDescriptorImpl moduleDescriptorImpl) {
        return moduleDescriptorImpl.dependencies;
    }

    public static final /* synthetic */ String access$getId(ModuleDescriptorImpl moduleDescriptorImpl) {
        return moduleDescriptorImpl.getId();
    }

    public static final /* synthetic */ boolean access$isInitialized(ModuleDescriptorImpl moduleDescriptorImpl) {
        return moduleDescriptorImpl.isInitialized();
    }

    public static final /* synthetic */ PackageFragmentProvider access$getPackageFragmentProviderForModuleContent$p(ModuleDescriptorImpl moduleDescriptorImpl) {
        return moduleDescriptorImpl.packageFragmentProviderForModuleContent;
    }

    @Override
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void assertValid() {
        if (!this.isValid()) {
            InvalidModuleExceptionKt.moduleInvalidated(this);
        }
    }

    @Override
    public List getExpectedByModules() {
        ModuleDependencies moduleDependencies = ((ModuleDescriptorImpl)((Object)string)).dependencies;
        if (moduleDependencies != null) {
            return moduleDependencies.getDirectExpectedByDependencies();
        }
        String string = "Dependencies of module " + ((ModuleDescriptorImpl)((Object)string)).getId() + " were not set";
        throw new AssertionError((Object)string);
    }

    @Override
    public PackageViewDescriptor getPackage(FqName fqName2) {
        ModuleDescriptorImpl moduleDescriptorImpl = this;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        moduleDescriptorImpl.assertValid();
        return (PackageViewDescriptor)moduleDescriptorImpl.packages.invoke(fqName2);
    }

    @Override
    public Collection getSubPackagesOf(FqName fqName2, Function1 function1) {
        ModuleDescriptorImpl moduleDescriptorImpl = this;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(function1, "nameFilter");
        moduleDescriptorImpl.assertValid();
        return moduleDescriptorImpl.getPackageFragmentProvider().getSubPackagesOf(fqName2, function1);
    }

    public final void setDependencies(ModuleDependencies moduleDependencies) {
        Intrinsics.checkNotNullParameter(moduleDependencies, "dependencies");
        boolean bl = ((ModuleDescriptorImpl)((Object)string)).dependencies == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Dependencies of " + ((ModuleDescriptorImpl)((Object)string)).getId() + " were already set";
            throw new AssertionError((Object)string);
        }
        ((ModuleDescriptorImpl)((Object)string)).dependencies = moduleDependencies;
    }

    public final void setDependencies(ModuleDescriptorImpl ... moduleDescriptorImplArray) {
        Intrinsics.checkNotNullParameter(moduleDescriptorImplArray, "descriptors");
        this.setDependencies(ArraysKt.toList(moduleDescriptorImplArray));
    }

    public final void setDependencies(List list) {
        Intrinsics.checkNotNullParameter(list, "descriptors");
        this.setDependencies(list, SetsKt.emptySet());
    }

    public final void setDependencies(List list, Set set) {
        ModuleDependenciesImpl moduleDependenciesImpl;
        ModuleDescriptorImpl moduleDescriptorImpl = moduleDependenciesImpl2;
        Intrinsics.checkNotNullParameter(list, "descriptors");
        Intrinsics.checkNotNullParameter(set, "friends");
        ModuleDependenciesImpl moduleDependenciesImpl2 = moduleDependenciesImpl;
        List list2 = CollectionsKt.emptyList();
        Set set2 = SetsKt.emptySet();
        moduleDependenciesImpl = new ModuleDependenciesImpl(list, set, list2, set2);
        moduleDescriptorImpl.setDependencies(moduleDependenciesImpl2);
    }

    @Override
    public boolean shouldSeeInternalsOf(ModuleDescriptor moduleDescriptor) {
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        Intrinsics.checkNotNullParameter(moduleDescriptor2, "targetModule");
        if (Intrinsics.areEqual(this, moduleDescriptor2)) {
            return true;
        }
        ModuleDependencies moduleDependencies = this.dependencies;
        Intrinsics.checkNotNull(moduleDependencies);
        if (CollectionsKt.contains(moduleDependencies.getModulesWhoseInternalsAreVisible(), moduleDescriptor)) {
            return true;
        }
        if (this.getExpectedByModules().contains(moduleDescriptor)) {
            return true;
        }
        return moduleDescriptor.getExpectedByModules().contains(this);
    }

    public final void initialize(PackageFragmentProvider packageFragmentProvider) {
        Intrinsics.checkNotNullParameter(packageFragmentProvider, "providerForModuleContent");
        boolean bl = ((ModuleDescriptorImpl)((Object)string)).isInitialized() ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Attempt to initialize module " + ((ModuleDescriptorImpl)((Object)string)).getId() + " twice";
            throw new AssertionError((Object)string);
        }
        ((ModuleDescriptorImpl)((Object)string)).packageFragmentProviderForModuleContent = packageFragmentProvider;
    }

    public final PackageFragmentProvider getPackageFragmentProvider() {
        ModuleDescriptorImpl moduleDescriptorImpl = this;
        moduleDescriptorImpl.assertValid();
        return moduleDescriptorImpl.getPackageFragmentProviderForWholeModuleWithDependencies();
    }

    @Override
    public Object getCapability(ModuleCapability moduleCapability) {
        Intrinsics.checkNotNullParameter(moduleCapability, "capability");
        ModuleDescriptorImpl moduleDescriptorImpl = moduleDescriptorImpl.capabilities.get(moduleCapability);
        if (moduleDescriptorImpl == null) {
            moduleDescriptorImpl = null;
        }
        return moduleDescriptorImpl;
    }

    @Override
    public DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor$DefaultImpls.getContainingDeclaration(this);
    }

    @Override
    public Object accept(DeclarationDescriptorVisitor declarationDescriptorVisitor, Object object) {
        return ModuleDescriptor$DefaultImpls.accept(this, declarationDescriptorVisitor, object);
    }
}

