/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.List;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaMethodDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class JavaIncompatibilityRulesOverridabilityCondition$Companion {
    private JavaIncompatibilityRulesOverridabilityCondition$Companion() {
    }

    private final JvmType mapValueParameterType(FunctionDescriptor functionDescriptor, ValueParameterDescriptor valueParameterDescriptor) {
        JvmType jvmType;
        if (!MethodSignatureMappingKt.forceSingleValueParameterBoxing(functionDescriptor) && !this.isPrimitiveCompareTo(functionDescriptor)) {
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "valueParameterDescriptor.type");
            jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType);
        } else {
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "valueParameterDescriptor.type");
            jvmType = MethodSignatureMappingKt.mapToJvmType(TypeUtilsKt.makeNullable(kotlinType));
        }
        return jvmType;
    }

    private final boolean isPrimitiveCompareTo(FunctionDescriptor declarationDescriptorNonRoot) {
        if (declarationDescriptorNonRoot.getValueParameters().size() != 1) {
            return false;
        }
        Object object = declarationDescriptorNonRoot.getContainingDeclaration();
        object = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (object == null) {
            return false;
        }
        List list = declarationDescriptorNonRoot.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "f.valueParameters");
        declarationDescriptorNonRoot = ((ValueParameterDescriptor)CollectionsKt.single(list)).getType().getConstructor().getDeclarationDescriptor();
        declarationDescriptorNonRoot = declarationDescriptorNonRoot instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptorNonRoot : null;
        if (declarationDescriptorNonRoot == null) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)object) && Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object), DescriptorUtilsKt.getFqNameSafe(declarationDescriptorNonRoot));
    }

    public /* synthetic */ JavaIncompatibilityRulesOverridabilityCondition$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    public final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2) {
        CallableDescriptor callableDescriptor3 = callableDescriptor2;
        Intrinsics.checkNotNullParameter(callableDescriptor, "superDescriptor");
        Intrinsics.checkNotNullParameter(callableDescriptor3, "subDescriptor");
        if (callableDescriptor3 instanceof JavaMethodDescriptor && callableDescriptor instanceof FunctionDescriptor) {
            JavaMethodDescriptor javaMethodDescriptor = (JavaMethodDescriptor)callableDescriptor2;
            callableDescriptor = (FunctionDescriptor)callableDescriptor;
            boolean bl = javaMethodDescriptor.getValueParameters().size() == callableDescriptor.getValueParameters().size();
            if (_Assertions.ENABLED && !bl) {
                throw new AssertionError((Object)"External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size");
            }
            List list = javaMethodDescriptor.getOriginal().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "subDescriptor.original.valueParameters");
            List list2 = callableDescriptor.getOriginal().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "superDescriptor.original.valueParameters");
            for (Object object : CollectionsKt.zip(list, list2)) {
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)((Pair)object).component1();
                object = (ValueParameterDescriptor)((Pair)object).component2();
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor2;
                Intrinsics.checkNotNullExpressionValue(valueParameterDescriptor, "subParameter");
                boolean bl2 = this.mapValueParameterType(functionDescriptor, valueParameterDescriptor) instanceof JvmType.Primitive;
                Intrinsics.checkNotNullExpressionValue(object, "superParameter");
                if (bl2 == this.mapValueParameterType((FunctionDescriptor)callableDescriptor, (ValueParameterDescriptor)object) instanceof JvmType.Primitive) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

