/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation$Argument;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation$Argument$Value;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation$Argument$Value$Type;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedArrayValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    public AnnotationDeserializer(ModuleDescriptor moduleDescriptor, NotFoundClasses notFoundClasses) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "module");
        Intrinsics.checkNotNullParameter(notFoundClasses, "notFoundClasses");
        this.module = moduleDescriptor;
        this.notFoundClasses = notFoundClasses;
    }

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    private final Pair resolveArgument(ProtoBuf$Annotation$Argument object, Map object2, NameResolver nameResolver) {
        if ((object2 = (ValueParameterDescriptor)object2.get(NameResolverUtilKt.getName(nameResolver, ((ProtoBuf$Annotation$Argument)object).getNameId()))) == null) {
            return null;
        }
        AnnotationDeserializer annotationDeserializer = name;
        ProtoBuf$Annotation$Argument protoBuf$Annotation$Argument = object;
        Name name = NameResolverUtilKt.getName(nameResolver, ((ProtoBuf$Annotation$Argument)object).getNameId());
        object = object2.getType();
        Intrinsics.checkNotNullExpressionValue(object, "parameter.type");
        object2 = protoBuf$Annotation$Argument.getValue();
        Intrinsics.checkNotNullExpressionValue(object2, "proto.value");
        return new Pair(name, annotationDeserializer.resolveValueAndCheckExpectedType((KotlinType)object, (ProtoBuf$Annotation$Argument$Value)object2, nameResolver));
    }

    private final ConstantValue resolveValueAndCheckExpectedType(KotlinType kotlinType, ProtoBuf$Annotation$Argument$Value protoBuf$Annotation$Argument$Value, NameResolver nameResolver) {
        AnnotationDeserializer annotationDeserializer = object;
        Object object = annotationDeserializer.resolveValue(kotlinType, protoBuf$Annotation$Argument$Value, nameResolver);
        if (!annotationDeserializer.doesValueConformToExpectedType((ConstantValue)object, kotlinType, protoBuf$Annotation$Argument$Value)) {
            object = null;
        }
        if (object == null) {
            object = ErrorValue.Companion.create("Unexpected argument value: actual type " + protoBuf$Annotation$Argument$Value.getType() + " != expected type " + kotlinType);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean doesValueConformToExpectedType(ConstantValue object, KotlinType object2, ProtoBuf$Annotation$Argument$Value protoBuf$Annotation$Argument$Value) {
        Object object3;
        ProtoBuf$Annotation$Argument$Value$Type protoBuf$Annotation$Argument$Value$Type = protoBuf$Annotation$Argument$Value.getType();
        int n = protoBuf$Annotation$Argument$Value$Type == null ? -1 : AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[protoBuf$Annotation$Argument$Value$Type.ordinal()];
        if (n != 10) {
            if (n == 13) {
                if (object instanceof ArrayValue && ((List)((ArrayValue)object).getValue()).size() == protoBuf$Annotation$Argument$Value.getArrayElementList().size()) {
                    ProtoBuf$Annotation$Argument$Value protoBuf$Annotation$Argument$Value2;
                    ConstantValue constantValue;
                    Object object4 = object;
                    object = super.getBuiltIns().getArrayElementType((KotlinType)object2);
                    Intrinsics.checkNotNullExpressionValue(object, "builtIns.getArrayElementType(expectedType)");
                    object2 = (ArrayValue)object4;
                    Object object5 = CollectionsKt.getIndices((Collection)((ConstantValue)object2).getValue());
                    if (object5 instanceof Collection && ((Collection)object5).isEmpty()) return true;
                    object5 = object5.iterator();
                    do {
                        if (!object5.hasNext()) return true;
                        int n2 = ((IntIterator)object5).nextInt();
                        constantValue = (ConstantValue)((List)((ConstantValue)object2).getValue()).get(n2);
                        protoBuf$Annotation$Argument$Value2 = protoBuf$Annotation$Argument$Value.getArrayElement(n2);
                        Intrinsics.checkNotNullExpressionValue(protoBuf$Annotation$Argument$Value2, "value.getArrayElement(i)");
                    } while (super.doesValueConformToExpectedType(constantValue, (KotlinType)object, protoBuf$Annotation$Argument$Value2));
                    return false;
                }
                object3 = "Deserialized ArrayValue should have the same number of elements as the original array value: " + object;
                throw new IllegalStateException(object3.toString());
            }
        } else {
            object3 = ((KotlinType)object2).getConstructor().getDeclarationDescriptor();
            if (!(object3 instanceof ClassDescriptor)) return true;
            object3 = (ClassDescriptor)object3;
            if (object3 == null) return true;
            if (!KotlinBuiltIns.isKClass((ClassDescriptor)object3)) return false;
            return true;
        }
        boolean bl = Intrinsics.areEqual(((ConstantValue)object).getType(((AnnotationDeserializer)object3).module), object2);
        return bl;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public final AnnotationDescriptor deserializeAnnotation(ProtoBuf$Annotation object, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter(object, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        ClassDescriptor classDescriptor = ((AnnotationDeserializer)((Object)simpleType2)).resolveClass(NameResolverUtilKt.getClassId(nameResolver, ((ProtoBuf$Annotation)object).getId()));
        Object object2 = MapsKt.emptyMap();
        if (((ProtoBuf$Annotation)object).getArgumentCount() != 0 && !ErrorUtils.isError(classDescriptor) && DescriptorUtils.isAnnotationClass(classDescriptor)) {
            Collection collection = classDescriptor.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, "annotationClass.constructors");
            Object object3 = (ClassConstructorDescriptor)CollectionsKt.singleOrNull(collection);
            if (object3 != null) {
                ArrayList arrayList;
                LinkedHashMap linkedHashMap;
                List list = object3.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "constructor.valueParameters");
                int n = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault(list, 10)), 16);
                object3 = linkedHashMap;
                linkedHashMap = new LinkedHashMap(n);
                for (Object object4 : list) {
                    object3.put(((ValueParameterDescriptor)object4).getName(), object4);
                }
                List list2 = ((ProtoBuf$Annotation)object).getArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, "proto.argumentList");
                object = arrayList;
                arrayList = new ArrayList();
                for (ProtoBuf$Annotation$Argument protoBuf$Annotation$Argument : list2) {
                    Object object4;
                    Intrinsics.checkNotNullExpressionValue(protoBuf$Annotation$Argument, "it");
                    object4 = super.resolveArgument(protoBuf$Annotation$Argument, (Map)object3, nameResolver);
                    if (object4 == null) continue;
                    object.add(object4);
                }
                object2 = MapsKt.toMap((Iterable)object);
            }
        }
        SimpleType simpleType2 = classDescriptor.getDefaultType();
        object = SourceElement.NO_SOURCE;
        return new AnnotationDescriptorImpl(simpleType2, (Map)object2, (SourceElement)object);
    }

    public final ConstantValue resolveValue(KotlinType object, ProtoBuf$Annotation$Argument$Value iterator2, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter(object, "expectedType");
        Intrinsics.checkNotNullParameter(iterator2, "value");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Boolean bl = Flags.IS_UNSIGNED.get(((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getFlags());
        Intrinsics.checkNotNullExpressionValue(bl, "IS_UNSIGNED.get(value.flags)");
        boolean bl2 = bl;
        Object object2 = ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getType();
        switch (object2 == null ? -1 : AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()]) {
            default: {
                throw new IllegalStateException(("Unsupported annotation argument type: " + ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getType() + " (expected " + object + ')').toString());
            }
            case 13: {
                DeserializedArrayValue deserializedArrayValue;
                ArrayList<ConstantValue> arrayList;
                iterator2 = ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getArrayElementList();
                Intrinsics.checkNotNullExpressionValue(iterator2, "value.arrayElementList");
                ArrayList<ConstantValue> arrayList2 = arrayList;
                arrayList = new ArrayList<ConstantValue>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    object2 = (ProtoBuf$Annotation$Argument$Value)iterator2.next();
                    SimpleType simpleType2 = super.getBuiltIns().getAnyType();
                    Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.anyType");
                    Intrinsics.checkNotNullExpressionValue(object2, "it");
                    arrayList2.add(((AnnotationDeserializer)object3).resolveValue(simpleType2, (ProtoBuf$Annotation$Argument$Value)object2, nameResolver));
                }
                Object object3 = deserializedArrayValue;
                deserializedArrayValue = new DeserializedArrayValue(arrayList2, (KotlinType)object);
                break;
            }
            case 12: {
                AnnotationValue annotationValue;
                object = annotationValue;
                ProtoBuf$Annotation protoBuf$Annotation = ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getAnnotation();
                Intrinsics.checkNotNullExpressionValue(protoBuf$Annotation, "value.annotation");
                annotationValue = new AnnotationValue(((AnnotationDeserializer)object3).deserializeAnnotation(protoBuf$Annotation, nameResolver));
                Object object3 = object;
                break;
            }
            case 11: {
                EnumValue enumValue;
                Object object3 = enumValue;
                object = NameResolverUtilKt.getClassId(nameResolver, ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getClassId());
                enumValue = new EnumValue((ClassId)object, NameResolverUtilKt.getName(nameResolver, ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getEnumValueId()));
                break;
            }
            case 10: {
                KClassValue kClassValue;
                Object object3 = kClassValue;
                object = NameResolverUtilKt.getClassId(nameResolver, ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getClassId());
                kClassValue = new KClassValue((ClassId)object, ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getArrayDimensionCount());
                break;
            }
            case 9: {
                StringValue stringValue;
                Object object3 = stringValue;
                stringValue = new StringValue(nameResolver.getString(((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getStringValue()));
                break;
            }
            case 8: {
                boolean bl3 = ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getIntValue() != 0L;
                Object object3 = new BooleanValue(bl3);
                break;
            }
            case 7: {
                DoubleValue doubleValue;
                Object object3 = doubleValue;
                doubleValue = new DoubleValue(((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getDoubleValue());
                break;
            }
            case 6: {
                FloatValue floatValue;
                Object object3 = floatValue;
                floatValue = new FloatValue(((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getFloatValue());
                break;
            }
            case 5: {
                LongValue longValue;
                Object object3;
                long l = ((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getIntValue();
                if (bl2) {
                    ULongValue uLongValue;
                    iterator2 = uLongValue;
                    uLongValue = new ULongValue(l);
                    object3 = iterator2;
                    break;
                }
                iterator2 = longValue;
                longValue = new LongValue(l);
                object3 = iterator2;
                break;
            }
            case 4: {
                IntValue intValue;
                Object object3;
                int n = (int)((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getIntValue();
                if (bl2) {
                    UIntValue uIntValue;
                    object = uIntValue;
                    uIntValue = new UIntValue(n);
                    object3 = object;
                    break;
                }
                object = intValue;
                intValue = new IntValue(n);
                object3 = object;
                break;
            }
            case 3: {
                ShortValue shortValue;
                Object object3;
                short s = (short)((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getIntValue();
                if (bl2) {
                    UShortValue uShortValue;
                    object = uShortValue;
                    uShortValue = new UShortValue(s);
                    object3 = object;
                    break;
                }
                object = shortValue;
                shortValue = new ShortValue(s);
                object3 = object;
                break;
            }
            case 2: {
                CharValue charValue;
                Object object3 = charValue;
                charValue = new CharValue((char)((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getIntValue());
                break;
            }
            case 1: {
                ByteValue byteValue;
                Object object3;
                byte by = (byte)((ProtoBuf$Annotation$Argument$Value)((Object)iterator2)).getIntValue();
                if (bl2) {
                    UByteValue uByteValue;
                    object = uByteValue;
                    uByteValue = new UByteValue(by);
                    object3 = object;
                    break;
                }
                object = byteValue;
                byteValue = new ByteValue(by);
                object3 = object;
            }
        }
        return object3;
    }
}

