/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypePreparator$Default;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import kotlin.reflect.jvm.internal.impl.types.model.CaptureStatus;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public abstract class NewCapturedTypeKt {
    public static final SimpleType captureFromArguments(SimpleType simpleType2, CaptureStatus object) {
        Intrinsics.checkNotNullParameter(simpleType2, "type");
        Intrinsics.checkNotNullParameter(object, "status");
        object = NewCapturedTypeKt.captureArguments(simpleType2, object);
        return object != null ? NewCapturedTypeKt.replaceArguments(simpleType2, (List)object) : null;
    }

    private static final SimpleType replaceArguments(UnwrappedType object, List list) {
        TypeAttributes typeAttributes = ((KotlinType)object).getAttributes();
        UnwrappedType unwrappedType = object;
        object = unwrappedType.getConstructor();
        boolean bl = unwrappedType.isMarkedNullable();
        return KotlinTypeFactory.simpleType$default(typeAttributes, (TypeConstructor)object, list, bl, null, 16, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final List captureArguments(UnwrappedType unwrappedType, CaptureStatus object) {
        Object object2;
        TypeProjection typeProjection;
        ArrayList<TypeProjection> arrayList;
        if (unwrappedType.getArguments().size() != unwrappedType.getConstructor().getParameters().size()) {
            return null;
        }
        List list = unwrappedType.getArguments();
        if (list instanceof Collection && list.isEmpty()) {
            return null;
        }
        Iterator iterator2 = list.iterator();
        do {
            if (!iterator2.hasNext()) return null;
        } while (((TypeProjection)iterator2.next()).getProjectionKind() == Variance.INVARIANT);
        boolean bl = false;
        if (bl) {
            return null;
        }
        List list2 = unwrappedType.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "type.constructor.parameters");
        iterator2 = CollectionsKt.zip(list, list2);
        ArrayList<TypeProjection> arrayList2 = arrayList;
        arrayList = new ArrayList<TypeProjection>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Object object3 = (Pair)iterator2.next();
            typeProjection = (TypeProjection)((Pair)object3).component1();
            object3 = (TypeParameterDescriptor)((Pair)object3).component2();
            if (typeProjection.getProjectionKind() != Variance.INVARIANT) {
                object2 = !typeProjection.isStarProjection() && typeProjection.getProjectionKind() == Variance.IN_VARIANCE ? typeProjection.getType().unwrap() : null;
                Intrinsics.checkNotNullExpressionValue(object3, "parameter");
                typeProjection = TypeUtilsKt.asTypeProjection(new NewCapturedType((CaptureStatus)((Object)object), (UnwrappedType)object2, typeProjection, (TypeParameterDescriptor)object3));
            }
            arrayList2.add(typeProjection);
        }
        object = TypeConstructorSubstitution.Companion.create(unwrappedType.getConstructor(), arrayList2).buildSubstitutor();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            typeProjection = (TypeProjection)list.get(n);
            object2 = (TypeProjection)arrayList2.get(n);
            if (typeProjection.getProjectionKind() != Variance.INVARIANT) {
                ArrayList<UnwrappedType> arrayList3;
                List list3 = ((TypeParameterDescriptor)unwrappedType.getConstructor().getParameters().get(n)).getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(list3, "type.constructor.parameters[index].upperBounds");
                ArrayList<UnwrappedType> arrayList4 = arrayList3;
                arrayList3 = new ArrayList<UnwrappedType>();
                for (KotlinType kotlinType : list3) {
                    arrayList4.add(KotlinTypePreparator$Default.INSTANCE.prepareType(((TypeSubstitutor)object).safeSubstitute(kotlinType, Variance.INVARIANT).unwrap()));
                }
                if (!typeProjection.isStarProjection() && typeProjection.getProjectionKind() == Variance.OUT_VARIANCE) {
                    arrayList4.add(KotlinTypePreparator$Default.INSTANCE.prepareType(typeProjection.getType().unwrap()));
                }
                KotlinType kotlinType = object2.getType();
                Intrinsics.checkNotNull(kotlinType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.checker.NewCapturedType");
                ((NewCapturedType)kotlinType).getConstructor().initializeSupertypes(arrayList4);
            }
            ++n;
        }
        return arrayList2;
    }
}

