/*
 * Decompiled with CFR 0.152.
 */
package link.infra.packwiz.installer.deps.commons-cli;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0;
import link.infra.packwiz.installer.deps.commons-cli.AmbiguousOptionException;
import link.infra.packwiz.installer.deps.commons-cli.CommandLine;
import link.infra.packwiz.installer.deps.commons-cli.MissingArgumentException;
import link.infra.packwiz.installer.deps.commons-cli.MissingOptionException;
import link.infra.packwiz.installer.deps.commons-cli.Option;
import link.infra.packwiz.installer.deps.commons-cli.Options;
import link.infra.packwiz.installer.deps.commons-cli.UnrecognizedOptionException;
import link.infra.packwiz.installer.deps.commons-cli.Util;

public class DefaultParser {
    protected CommandLine cmd;
    protected Options options;
    protected boolean stopAtNonOption;
    protected String currentToken;
    protected Option currentOption;
    protected boolean skipParsing;
    protected List expectedOpts;
    private final boolean allowPartialMatching;
    private final Boolean stripLeadingAndTrailingQuotes = null;

    public DefaultParser() {
        this.allowPartialMatching = true;
    }

    private void checkRequiredArgs() {
        Option option = this.currentOption;
        if (option != null && option.requiresArg()) {
            throw new MissingArgumentException(this.currentOption);
        }
    }

    private String getLongPrefix(String string) {
        string = Util.stripLeadingHyphens(string);
        String string2 = null;
        for (int i = string.length() - 2; i > 1; --i) {
            String string3 = string.substring(0, i);
            if (!this.options.hasLongOption(string3)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    private List getMatchingLongOptions(String string) {
        ArrayList<String> arrayList;
        if (this.allowPartialMatching) {
            return this.options.getMatchingOptions(string);
        }
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(1);
        if (this.options.hasLongOption(string)) {
            arrayList2.add(this.options.getOption(string).getLongOpt());
        }
        return arrayList2;
    }

    private void handleLongOption(String string) {
        if (string.indexOf(61) == -1) {
            this.handleLongOptionWithoutEqual(string);
        } else {
            this.handleLongOptionWithEqual(string);
        }
    }

    private void handleLongOptionWithEqual(String string) {
        String string2 = string;
        int n = string2.indexOf(61);
        String string3 = string2.substring(n + 1);
        Object object = string2.substring(0, n);
        List list = this.getMatchingLongOptions((String)object);
        if (list.isEmpty()) {
            DefaultParser defaultParser = this;
            defaultParser.handleUnknownToken(defaultParser.currentToken);
        } else {
            if (list.size() > 1 && !this.options.hasLongOption((String)object)) {
                throw new AmbiguousOptionException((String)object, list);
            }
            if (!this.options.hasLongOption((String)object)) {
                object = (String)list.get(0);
            }
            object = this.options.getOption((String)object);
            if (((Option)object).acceptsArg()) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption((Option)object);
                defaultParser.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(string3));
                defaultParser.currentOption = null;
            } else {
                DefaultParser defaultParser = this;
                defaultParser.handleUnknownToken(defaultParser.currentToken);
            }
        }
    }

    private void handleLongOptionWithoutEqual(String string) {
        List list = this.getMatchingLongOptions(string);
        if (list.isEmpty()) {
            DefaultParser defaultParser = this;
            defaultParser.handleUnknownToken(defaultParser.currentToken);
        } else {
            if (list.size() > 1 && !this.options.hasLongOption(string)) {
                throw new AmbiguousOptionException(string, list);
            }
            if (!this.options.hasLongOption(string)) {
                string = (String)list.get(0);
            }
            DefaultParser defaultParser = this;
            defaultParser.handleOption(defaultParser.options.getOption(string));
        }
    }

    private void handleOption(Option option) {
        this.checkRequiredArgs();
        option = (Option)option.clone();
        this.updateRequiredOptions(option);
        this.cmd.addOption(option);
        this.currentOption = option.hasArg() ? option : null;
    }

    private void handleProperties(Properties properties2) {
        if (properties2 == null) {
            return;
        }
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            Option option = this.options.getOption(string);
            if (option != null) {
                DefaultParser defaultParser = this;
                defaultParser.options.getOptionGroup(option);
                if (defaultParser.cmd.hasOption(string)) continue;
                string = properties2.getProperty(string);
                if (option.hasArg()) {
                    if (option.getValues() == null || option.getValues().length == 0) {
                        option.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(string));
                    }
                } else if (!"yes".equalsIgnoreCase(string) && !"true".equalsIgnoreCase(string) && !"1".equalsIgnoreCase(string)) continue;
                this.handleOption(option);
                this.currentOption = null;
                continue;
            }
            throw new UnrecognizedOptionException("Default option wasn't defined", string);
        }
    }

    private void handleShortAndLongOption(String string) {
        Object object = Util.stripLeadingHyphens(string);
        int n = ((String)object).indexOf(61);
        if (((String)object).length() == 1) {
            if (this.options.hasShortOption((String)object)) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption(defaultParser.options.getOption((String)object));
            } else {
                this.handleUnknownToken(string);
            }
        } else if (n == -1) {
            if (this.options.hasShortOption((String)object)) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption(defaultParser.options.getOption((String)object));
            } else if (!this.getMatchingLongOptions((String)object).isEmpty()) {
                this.handleLongOptionWithoutEqual(string);
            } else {
                String string2 = this.getLongPrefix((String)object);
                if (string2 != null && this.options.getOption(string2).acceptsArg()) {
                    DefaultParser defaultParser = this;
                    defaultParser.handleOption(defaultParser.options.getOption(string2));
                    defaultParser.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(((String)object).substring(string2.length())));
                    defaultParser.currentOption = null;
                } else if (this.isJavaProperty((String)object)) {
                    DefaultParser defaultParser = this;
                    defaultParser.handleOption(defaultParser.options.getOption(((String)object).substring(0, 1)));
                    defaultParser.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(((String)object).substring(1)));
                    defaultParser.currentOption = null;
                } else {
                    this.handleConcatenatedOptions(string);
                }
            }
        } else {
            String string3 = object;
            object = ((String)object).substring(0, n);
            String string4 = string3.substring(n + 1);
            if (((String)object).length() == 1) {
                if ((object = this.options.getOption((String)object)) != null && ((Option)object).acceptsArg()) {
                    DefaultParser defaultParser = this;
                    defaultParser.handleOption((Option)object);
                    defaultParser.currentOption.addValueForProcessing(string4);
                    defaultParser.currentOption = null;
                } else {
                    this.handleUnknownToken(string);
                }
            } else if (this.isJavaProperty((String)object)) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption(defaultParser.options.getOption(((String)object).substring(0, 1)));
                defaultParser.currentOption.addValueForProcessing(((String)object).substring(1));
                defaultParser.currentOption.addValueForProcessing(string4);
                defaultParser.currentOption = null;
            } else {
                this.handleLongOptionWithEqual(string);
            }
        }
    }

    private void handleToken(String object) {
        this.currentToken = object;
        if (this.skipParsing) {
            this.cmd.addArg((String)object);
        } else if ("--".equals(object)) {
            this.skipParsing = true;
        } else {
            Option option = this.currentOption;
            if (option != null && option.acceptsArg() && this.isArgument((String)object)) {
                this.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOn((String)object));
            } else if (((String)object).startsWith("--")) {
                this.handleLongOption((String)object);
            } else if (((String)object).startsWith("-") && !"-".equals(object)) {
                this.handleShortAndLongOption((String)object);
            } else {
                this.handleUnknownToken((String)object);
            }
        }
        object = this.currentOption;
        if (object != null && !((Option)object).acceptsArg()) {
            this.currentOption = null;
        }
    }

    private void handleUnknownToken(String string) {
        if (string.startsWith("-") && string.length() > 1 && !this.stopAtNonOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + string, string);
        }
        DefaultParser defaultParser = this;
        defaultParser.cmd.addArg(string);
        if (defaultParser.stopAtNonOption) {
            this.skipParsing = true;
        }
    }

    private boolean isArgument(String string) {
        return !this.isOption(string) || this.isNegativeNumber(string);
    }

    private boolean isJavaProperty(String string) {
        DefaultParser defaultParser = object;
        Object object = string.substring(0, 1);
        return (object = defaultParser.options.getOption((String)object)) != null && (((Option)object).getArgs() >= 2 || ((Option)object).getArgs() == -2);
    }

    private boolean isLongOption(String string) {
        if (string != null && string.startsWith("-") && string.length() != 1) {
            int n = string.indexOf("=");
            String string2 = n == -1 ? string : string.substring(0, n);
            if (!this.getMatchingLongOptions(string2).isEmpty()) {
                return true;
            }
            return this.getLongPrefix(string) != null && !string.startsWith("--");
        }
        return false;
    }

    private boolean isNegativeNumber(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean isOption(String string) {
        return this.isLongOption(string) || this.isShortOption(string);
    }

    private boolean isShortOption(String string) {
        if (string != null && string.startsWith("-") && string.length() != 1) {
            int n = string.indexOf("=");
            if (this.options.hasShortOption(string = n == -1 ? string.substring(1) : string.substring(1, n))) {
                return true;
            }
            return !string.isEmpty() && this.options.hasShortOption(String.valueOf(string.charAt(0)));
        }
        return false;
    }

    private String stripLeadingAndTrailingQuotesDefaultOff(String string) {
        Boolean bl = ((DefaultParser)((Object)bl)).stripLeadingAndTrailingQuotes;
        if (bl != null && bl.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(string);
        }
        return string;
    }

    private String stripLeadingAndTrailingQuotesDefaultOn(String string) {
        Boolean bl = ((DefaultParser)((Object)bl)).stripLeadingAndTrailingQuotes;
        if (bl != null && !bl.booleanValue()) {
            return string;
        }
        return Util.stripLeadingAndTrailingQuotes(string);
    }

    private void updateRequiredOptions(Option option) {
        if (option.isRequired()) {
            this.expectedOpts.remove(option.getKey());
        }
        this.options.getOptionGroup(option);
    }

    protected void checkRequiredOptions() {
        if (this.expectedOpts.isEmpty()) {
            return;
        }
        throw new MissingOptionException(this.expectedOpts);
    }

    protected void handleConcatenatedOptions(String string) {
        for (int i = 1; i < string.length(); ++i) {
            String string2 = String.valueOf(string.charAt(i));
            if (!this.options.hasOption(string2)) {
                if (this.stopAtNonOption && i > 1) {
                    string = string.substring(i);
                }
                this.handleUnknownToken(string);
                break;
            }
            DefaultParser defaultParser = this;
            defaultParser.handleOption(defaultParser.options.getOption(string2));
            if (defaultParser.currentOption == null) continue;
            int n = i + 1;
            if (string.length() == n) continue;
            this.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(string.substring(n)));
            break;
        }
    }

    public CommandLine parse(Options options, String[] stringArray) {
        return this.parse(options, stringArray, null);
    }

    public CommandLine parse(Options options, String[] stringArray, Properties properties2) {
        return this.parse(options, stringArray, properties2, false);
    }

    public CommandLine parse(Options object, String[] stringArray, Properties properties2, boolean n) {
        DefaultParser defaultParser = this;
        this.options = object;
        defaultParser.stopAtNonOption = n;
        defaultParser.skipParsing = false;
        defaultParser.currentOption = null;
        defaultParser.expectedOpts = new ArrayList(((Options)object).getRequiredOptions());
        if (!(object = ((Options)object).getOptionGroups().iterator()).hasNext()) {
            CommandLine commandLine;
            object = commandLine;
            commandLine = new CommandLine();
            this.cmd = object;
            if (stringArray != null) {
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    this.handleToken(stringArray[n]);
                }
            }
            DefaultParser defaultParser2 = this;
            this.checkRequiredArgs();
            defaultParser2.handleProperties(properties2);
            defaultParser2.checkRequiredOptions();
            return defaultParser2.cmd;
        }
        LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0.m(object.next());
        throw null;
    }
}

