/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec$Builder;
import okhttp3.ConnectionSpec$Companion;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

public final class ConnectionSpec {
    public static final ConnectionSpec$Companion Companion;
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    private static final CipherSuite[] APPROVED_CIPHER_SUITES;
    public static final ConnectionSpec RESTRICTED_TLS;
    public static final ConnectionSpec MODERN_TLS;
    public static final ConnectionSpec COMPATIBLE_TLS;
    public static final ConnectionSpec CLEARTEXT;
    private final boolean isTls;
    private final boolean supportsTlsExtensions;
    private final String[] cipherSuitesAsString;
    private final String[] tlsVersionsAsString;

    public ConnectionSpec(boolean bl, boolean bl2, String[] stringArray, String[] stringArray2) {
        this.isTls = bl;
        this.supportsTlsExtensions = bl2;
        this.cipherSuitesAsString = stringArray;
        this.tlsVersionsAsString = stringArray2;
    }

    private final ConnectionSpec supportedSpec(SSLSocket object, boolean n) {
        ConnectionSpec$Builder connectionSpec$Builder;
        String[] stringArray;
        String[] stringArray2;
        if (this.cipherSuitesAsString != null) {
            String[] stringArray3 = object.getEnabledCipherSuites();
            Intrinsics.checkNotNullExpressionValue(stringArray3, "sslSocket.enabledCipherSuites");
            stringArray2 = Util.intersect(stringArray3, this.cipherSuitesAsString, CipherSuite.Companion.getORDER_BY_NAME$okhttp());
        } else {
            stringArray2 = object.getEnabledCipherSuites();
        }
        if (this.tlsVersionsAsString != null) {
            String[] stringArray4 = object.getEnabledProtocols();
            Intrinsics.checkNotNullExpressionValue(stringArray4, "sslSocket.enabledProtocols");
            stringArray = Util.intersect(stringArray4, this.tlsVersionsAsString, ComparisonsKt.naturalOrder());
        } else {
            stringArray = object.getEnabledProtocols();
        }
        int n2 = n;
        object = object.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue(object, "supportedCipherSuites");
        n = Util.indexOf(object, "TLS_FALLBACK_SCSV", CipherSuite.Companion.getORDER_BY_NAME$okhttp());
        if (n2 != 0 && n != -1) {
            Intrinsics.checkNotNullExpressionValue(stringArray2, "cipherSuitesIntersection");
            object = object[n];
            Intrinsics.checkNotNullExpressionValue(object, "supportedCipherSuites[indexOfFallbackScsv]");
            stringArray2 = Util.concat(stringArray2, (String)object);
        }
        object = connectionSpec$Builder;
        object(this);
        Intrinsics.checkNotNullExpressionValue(stringArray2, "cipherSuitesIntersection");
        ConnectionSpec$Builder connectionSpec$Builder2 = connectionSpec$Builder.cipherSuites(Arrays.copyOf(stringArray2, stringArray2.length));
        String[] stringArray5 = stringArray;
        Intrinsics.checkNotNullExpressionValue(stringArray5, "tlsVersionsIntersection");
        return connectionSpec$Builder2.tlsVersions(Arrays.copyOf(stringArray, stringArray5.length)).build();
    }

    public static final /* synthetic */ String[] access$getCipherSuitesAsString$p(ConnectionSpec connectionSpec) {
        return connectionSpec.cipherSuitesAsString;
    }

    public static final /* synthetic */ String[] access$getTlsVersionsAsString$p(ConnectionSpec connectionSpec) {
        return connectionSpec.tlsVersionsAsString;
    }

    static {
        ConnectionSpec$Builder connectionSpec$Builder;
        ConnectionSpec$Builder connectionSpec$Builder2;
        ConnectionSpec$Builder connectionSpec$Builder3;
        CipherSuite cipherSuite;
        CipherSuite cipherSuite2;
        CipherSuite cipherSuite3;
        CipherSuite cipherSuite4;
        CipherSuite cipherSuite5;
        CipherSuite cipherSuite6;
        CipherSuite cipherSuite7;
        Companion = new ConnectionSpec$Companion(null);
        CipherSuite[] cipherSuiteArray = new CipherSuite[9];
        Object object = cipherSuiteArray;
        Object object2 = CipherSuite.TLS_AES_128_GCM_SHA256;
        cipherSuiteArray[0] = object2;
        Object object3 = CipherSuite.TLS_AES_256_GCM_SHA384;
        cipherSuiteArray[1] = object3;
        cipherSuiteArray[2] = cipherSuite7 = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        cipherSuiteArray[3] = cipherSuite6 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray[4] = cipherSuite5 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray[5] = cipherSuite4 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray[6] = cipherSuite3 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray[7] = cipherSuite2 = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        cipherSuiteArray[8] = cipherSuite = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        RESTRICTED_CIPHER_SUITES = cipherSuiteArray;
        CipherSuite[] cipherSuiteArray2 = new CipherSuite[16];
        CipherSuite[] cipherSuiteArray3 = cipherSuiteArray2;
        cipherSuiteArray2[0] = object2;
        cipherSuiteArray2[1] = object3;
        cipherSuiteArray2[2] = cipherSuite7;
        cipherSuiteArray2[3] = cipherSuite6;
        cipherSuiteArray2[4] = cipherSuite5;
        cipherSuiteArray2[5] = cipherSuite4;
        cipherSuiteArray2[6] = cipherSuite3;
        cipherSuiteArray2[7] = cipherSuite2;
        cipherSuiteArray2[8] = cipherSuite;
        cipherSuiteArray2[9] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray2[10] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray2[11] = CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray2[12] = CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray2[13] = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray2[14] = CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray2[15] = CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        APPROVED_CIPHER_SUITES = cipherSuiteArray2;
        object2 = connectionSpec$Builder3;
        ((ConnectionSpec$Builder)object2)(true);
        ConnectionSpec$Builder connectionSpec$Builder4 = connectionSpec$Builder3.cipherSuites(Arrays.copyOf(object, ((CipherSuite[])object).length));
        TlsVersion[] tlsVersionArray = new TlsVersion[2];
        tlsVersionArray[0] = object = TlsVersion.TLS_1_3;
        object2 = TlsVersion.TLS_1_2;
        tlsVersionArray[1] = object2;
        RESTRICTED_TLS = connectionSpec$Builder4.tlsVersions(tlsVersionArray).supportsTlsExtensions(true).build();
        object3 = connectionSpec$Builder2;
        ((ConnectionSpec$Builder)object3)(true);
        MODERN_TLS = connectionSpec$Builder2.cipherSuites(Arrays.copyOf(cipherSuiteArray3, cipherSuiteArray3.length)).tlsVersions(new TlsVersion[]{object, object2}).supportsTlsExtensions(true).build();
        object3 = connectionSpec$Builder;
        ((ConnectionSpec$Builder)object3)(true);
        COMPATIBLE_TLS = connectionSpec$Builder.cipherSuites(Arrays.copyOf(cipherSuiteArray3, cipherSuiteArray3.length)).tlsVersions(new TlsVersion[]{object, object2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0}).supportsTlsExtensions(true).build();
        CLEARTEXT = new ConnectionSpec$Builder(false).build();
    }

    public final boolean isTls() {
        return this.isTls;
    }

    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    public final List cipherSuites() {
        List list;
        String[] stringArray = stringArray.cipherSuitesAsString;
        if (stringArray.cipherSuitesAsString == null) {
            list = null;
        } else {
            ArrayList<CipherSuite> arrayList;
            ArrayList<CipherSuite> arrayList2 = arrayList;
            arrayList = new ArrayList<CipherSuite>(stringArray.length);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(CipherSuite.Companion.forJavaName(stringArray[i]));
            }
            list = CollectionsKt.toList(arrayList2);
        }
        return list;
    }

    public final List tlsVersions() {
        List list;
        String[] stringArray = stringArray.tlsVersionsAsString;
        if (stringArray.tlsVersionsAsString == null) {
            list = null;
        } else {
            ArrayList<TlsVersion> arrayList;
            ArrayList<TlsVersion> arrayList2 = arrayList;
            arrayList = new ArrayList<TlsVersion>(stringArray.length);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(TlsVersion.Companion.forJavaName(stringArray[i]));
            }
            list = CollectionsKt.toList(arrayList2);
        }
        return list;
    }

    public final void apply$okhttp(SSLSocket sSLSocket, boolean bl) {
        SSLSocket sSLSocket2 = sSLSocket;
        Intrinsics.checkNotNullParameter(sSLSocket2, "sslSocket");
        ConnectionSpec connectionSpec = connectionSpec.supportedSpec(sSLSocket2, bl);
        if (connectionSpec.tlsVersions() != null) {
            sSLSocket.setEnabledProtocols(connectionSpec.tlsVersionsAsString);
        }
        if (connectionSpec.cipherSuites() != null) {
            sSLSocket.setEnabledCipherSuites(connectionSpec.cipherSuitesAsString);
        }
    }

    public final boolean isCompatible(SSLSocket sSLSocket) {
        Intrinsics.checkNotNullParameter(sSLSocket, "socket");
        if (!stringArray2.isTls) {
            return false;
        }
        String[] stringArray = stringArray2.tlsVersionsAsString;
        if (stringArray2.tlsVersionsAsString != null && !Util.hasIntersection(stringArray, sSLSocket.getEnabledProtocols(), ComparisonsKt.naturalOrder())) {
            return false;
        }
        String[] stringArray2 = stringArray2.cipherSuitesAsString;
        return stringArray2.cipherSuitesAsString == null || Util.hasIntersection(stringArray2, sSLSocket.getEnabledCipherSuites(), CipherSuite.Companion.getORDER_BY_NAME$okhttp());
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        boolean bl = this.isTls;
        object = (ConnectionSpec)object;
        if (bl != ((ConnectionSpec)object).isTls) {
            return false;
        }
        if (bl) {
            if (!Arrays.equals(this.cipherSuitesAsString, ((ConnectionSpec)object).cipherSuitesAsString)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersionsAsString, ((ConnectionSpec)object).tlsVersionsAsString)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        if (this.isTls) {
            n = 527;
            Object[] objectArray = this.cipherSuitesAsString;
            int n2 = this.cipherSuitesAsString == null ? 0 : Arrays.hashCode(objectArray);
            n = (n + n2) * 31;
            Object[] objectArray2 = this.tlsVersionsAsString;
            int n3 = this.tlsVersionsAsString == null ? 0 : Arrays.hashCode(objectArray2);
            n = (n + n3) * 31 + (this.supportsTlsExtensions ^ 1);
        }
        return n;
    }

    public String toString() {
        if (!this.isTls) {
            return "ConnectionSpec()";
        }
        return "ConnectionSpec(cipherSuites=" + Objects.toString(this.cipherSuites(), "[all enabled]") + ", tlsVersions=" + Objects.toString(this.tlsVersions(), "[all enabled]") + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ')';
    }
}

