/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.http2.Header$Companion;
import okio.ByteString;
import okio.ByteString$Companion;

public final class Header {
    public static final Header$Companion Companion = new Header$Companion(null);
    public static final ByteString PSEUDO_PREFIX;
    public static final ByteString RESPONSE_STATUS;
    public static final ByteString TARGET_METHOD;
    public static final ByteString TARGET_PATH;
    public static final ByteString TARGET_SCHEME;
    public static final ByteString TARGET_AUTHORITY;
    public final ByteString name;
    public final ByteString value;
    public final int hpackSize;

    public Header(ByteString byteString, ByteString byteString2) {
        Intrinsics.checkNotNullParameter(byteString, "name");
        Intrinsics.checkNotNullParameter(byteString2, "value");
        this.name = byteString;
        this.value = byteString2;
        this.hpackSize = byteString.size() + 32 + byteString2.size();
    }

    public Header(String string, String string2) {
        Header header = byteString;
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(string2, "value");
        ByteString$Companion byteString$Companion = ByteString.Companion;
        ByteString byteString = byteString$Companion.encodeUtf8(string);
        header(byteString, byteString$Companion.encodeUtf8(string2));
    }

    public Header(ByteString byteString, String string) {
        Intrinsics.checkNotNullParameter(byteString, "name");
        Intrinsics.checkNotNullParameter(string, "value");
        this(byteString, ByteString.Companion.encodeUtf8(string));
    }

    static {
        ByteString$Companion byteString$Companion = ByteString.Companion;
        PSEUDO_PREFIX = byteString$Companion.encodeUtf8(":");
        RESPONSE_STATUS = byteString$Companion.encodeUtf8(":status");
        TARGET_METHOD = byteString$Companion.encodeUtf8(":method");
        TARGET_PATH = byteString$Companion.encodeUtf8(":path");
        TARGET_SCHEME = byteString$Companion.encodeUtf8(":scheme");
        TARGET_AUTHORITY = byteString$Companion.encodeUtf8(":authority");
    }

    public String toString() {
        return this.name.utf8() + ": " + this.value.utf8();
    }

    public final ByteString component1() {
        return this.name;
    }

    public final ByteString component2() {
        return this.value;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Header)) {
            return false;
        }
        object = (Header)object;
        if (!Intrinsics.areEqual(this.name, ((Header)object).name)) {
            return false;
        }
        return Intrinsics.areEqual(this.value, ((Header)object).value);
    }
}

