/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Hpack$Reader;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Http2Reader$Companion;
import okhttp3.internal.http2.Http2Reader$ContinuationSource;
import okhttp3.internal.http2.Http2Reader$Handler;
import okhttp3.internal.http2.Settings;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;

public final class Http2Reader
implements Closeable {
    public static final Http2Reader$Companion Companion = new Http2Reader$Companion(null);
    private static final Logger logger;
    private final BufferedSource source;
    private final boolean client;
    private final Http2Reader$ContinuationSource continuation;
    private final Hpack$Reader hpackReader;

    public Http2Reader(BufferedSource object, boolean bl) {
        Hpack$Reader hpack$Reader;
        Http2Reader$ContinuationSource http2Reader$ContinuationSource;
        Intrinsics.checkNotNullParameter(object, "source");
        closeable.source = object;
        closeable.client = bl;
        Closeable closeable = http2Reader$ContinuationSource;
        http2Reader$ContinuationSource = new Http2Reader$ContinuationSource((BufferedSource)object);
        v1.continuation = closeable;
        object = hpack$Reader;
        hpack$Reader = new Hpack$Reader((Source)closeable, 4096, 0, 4, null);
        v1.hpackReader = object;
    }

    private final void readHeaders(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n3 != 0) {
            boolean bl = (n2 & 1) != 0;
            int n4 = (n2 & 8) != 0 ? Util.and(((Http2Reader)((Object)list)).source.readByte(), 255) : 0;
            if ((n2 & 0x20) != 0) {
                ((Http2Reader)((Object)list)).readPriority(http2Reader$Handler, n3);
                n -= 5;
            }
            List list = ((Http2Reader)((Object)list)).readHeaderBlock(Companion.lengthWithoutPadding(n, n2, n4), n4, n2, n3);
            http2Reader$Handler.headers(bl, n3, -1, list);
            return;
        }
        throw new IOException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0");
    }

    private final List readHeaderBlock(int n, int n2, int n3, int n4) {
        Http2Reader http2Reader = this;
        http2Reader.continuation.setLeft(n);
        Http2Reader$ContinuationSource http2Reader$ContinuationSource = http2Reader.continuation;
        http2Reader$ContinuationSource.setLength(http2Reader$ContinuationSource.getLeft());
        http2Reader.continuation.setPadding(n2);
        http2Reader.continuation.setFlags(n3);
        http2Reader.continuation.setStreamId(n4);
        http2Reader.hpackReader.readHeaders();
        return http2Reader.hpackReader.getAndResetHeaderList();
    }

    private final void readData(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n3 != 0) {
            boolean bl = (n2 & 1) != 0;
            if (!((n2 & 0x20) != 0)) {
                int n4 = (n2 & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
                int n5 = Companion.lengthWithoutPadding(n, n2, n4);
                http2Reader$Handler.data(bl, n3, this.source, n5);
                this.source.skip(n4);
                return;
            }
            throw new IOException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA");
        }
        throw new IOException("PROTOCOL_ERROR: TYPE_DATA streamId == 0");
    }

    private final void readPriority(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n == 5) {
            if (n3 != 0) {
                this.readPriority(http2Reader$Handler, n3);
                return;
            }
            throw new IOException("TYPE_PRIORITY streamId == 0");
        }
        throw new IOException("TYPE_PRIORITY length: " + n + " != 5");
    }

    private final void readPriority(Http2Reader$Handler http2Reader$Handler, int n) {
        int n2 = this.source.readInt();
        boolean bl = (n2 & Integer.MIN_VALUE) != 0;
        int n3 = n2 & Integer.MAX_VALUE;
        http2Reader$Handler.priority(n, n3, Util.and(this.source.readByte(), 255) + 1, bl);
    }

    private final void readRstStream(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n == 4) {
            if (n3 != 0) {
                int n4 = this.source.readInt();
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(n4);
                if (errorCode != null) {
                    http2Reader$Handler.rstStream(n3, errorCode);
                    return;
                }
                throw new IOException(Intrinsics.stringPlus("TYPE_RST_STREAM unexpected error code: ", n4));
            }
            throw new IOException("TYPE_RST_STREAM streamId == 0");
        }
        throw new IOException("TYPE_RST_STREAM length: " + n + " != 4");
    }

    private final void readSettings(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n3 == 0) {
            if ((n2 & 1) != 0) {
                if (n == 0) {
                    http2Reader$Handler.ackSettings();
                    return;
                }
                throw new IOException("FRAME_SIZE_ERROR ack frame should be empty!");
            }
            if (n % 6 == 0) {
                Settings settings;
                Settings settings2 = settings;
                settings = new Settings();
                IntProgression intProgression = RangesKt.step(RangesKt.until(0, n), 6);
                n = intProgression.getFirst();
                n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                if (n4 > 0 && n <= n3 || n4 < 0 && n3 <= n) {
                    while (true) {
                        int n5 = n + n4;
                        int n6 = Util.and(this.source.readShort(), 65535);
                        int n7 = this.source.readInt();
                        switch (n6) {
                            default: {
                                break;
                            }
                            case 5: {
                                if (n7 >= 16384 && n7 <= 0xFFFFFF) break;
                                throw new IOException(Intrinsics.stringPlus("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: ", n7));
                            }
                            case 4: {
                                n6 = 7;
                                if (n7 >= 0) break;
                                throw new IOException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1");
                            }
                            case 3: {
                                n6 = 4;
                                break;
                            }
                            case 2: {
                                if (n7 == 0 || n7 == 1) break;
                                throw new IOException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1");
                            }
                        }
                        settings2.set(n6, n7);
                        if (n == n3) break;
                        n = n5;
                    }
                }
                http2Reader$Handler.settings(false, settings2);
                return;
            }
            throw new IOException(Intrinsics.stringPlus("TYPE_SETTINGS length % 6 != 0: ", n));
        }
        throw new IOException("TYPE_SETTINGS streamId != 0");
    }

    private final void readPushPromise(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n3 != 0) {
            int n4 = (n2 & 8) != 0 ? Util.and(this.source.readByte(), 255) : 0;
            Http2Reader http2Reader = this;
            int n5 = http2Reader.source.readInt() & Integer.MAX_VALUE;
            http2Reader$Handler.pushPromise(n3, n5, http2Reader.readHeaderBlock(Companion.lengthWithoutPadding(n - 4, n2, n4), n4, n2, n3));
            return;
        }
        throw new IOException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0");
    }

    private final void readPing(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n == 8) {
            if (n3 == 0) {
                Http2Reader http2Reader = this;
                int n4 = http2Reader.source.readInt();
                n = http2Reader.source.readInt();
                n2 = (n2 & 1) != 0 ? 1 : 0;
                http2Reader$Handler.ping(n2 != 0, n4, n);
                return;
            }
            throw new IOException("TYPE_PING streamId != 0");
        }
        throw new IOException(Intrinsics.stringPlus("TYPE_PING length != 8: ", n));
    }

    private final void readGoAway(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n >= 8) {
            if (n3 == 0) {
                int n4 = n;
                Http2Reader http2Reader = this;
                n = http2Reader.source.readInt();
                n2 = http2Reader.source.readInt();
                n3 = n4 - 8;
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(n2);
                if (errorCode != null) {
                    ByteString byteString = ByteString.EMPTY;
                    if (n3 > 0) {
                        byteString = this.source.readByteString(n3);
                    }
                    http2Reader$Handler.goAway(n, errorCode, byteString);
                    return;
                }
                throw new IOException(Intrinsics.stringPlus("TYPE_GOAWAY unexpected error code: ", n2));
            }
            throw new IOException("TYPE_GOAWAY streamId != 0");
        }
        throw new IOException(Intrinsics.stringPlus("TYPE_GOAWAY length < 8: ", n));
    }

    private final void readWindowUpdate(Http2Reader$Handler http2Reader$Handler, int n, int n2, int n3) {
        if (n == 4) {
            long l = Util.and(this.source.readInt(), Integer.MAX_VALUE);
            if (l != 0L) {
                http2Reader$Handler.windowUpdate(n3, l);
                return;
            }
            throw new IOException("windowSizeIncrement was 0");
        }
        throw new IOException(Intrinsics.stringPlus("TYPE_WINDOW_UPDATE length !=4: ", n));
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        Logger logger = Logger.getLogger(Http2.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(Http2::class.java.name)");
        Http2Reader.logger = logger;
    }

    public final void readConnectionPreface(Http2Reader$Handler object) {
        block8: {
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter(object, "handler");
                    if (!((Http2Reader)((Object)byteString)).client) break block6;
                    if (!((Http2Reader)((Object)byteString)).nextFrame(true, (Http2Reader$Handler)object)) {
                        throw new IOException("Required SETTINGS preface not received");
                    }
                    break block7;
                }
                ByteString byteString = Http2.CONNECTION_PREFACE;
                object = ((Http2Reader)((Object)byteString)).source.readByteString(byteString.size());
                Logger logger = Http2Reader.logger;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(Util.format(Intrinsics.stringPlus("<< CONNECTION ", ((ByteString)object).hex()), new Object[0]));
                }
                if (!Intrinsics.areEqual(byteString, object)) break block8;
            }
            return;
        }
        throw new IOException(Intrinsics.stringPlus("Expected a connection header but was ", ((ByteString)object).utf8()));
    }

    public final boolean nextFrame(boolean bl, Http2Reader$Handler http2Reader$Handler) {
        Http2Reader http2Reader = this;
        Intrinsics.checkNotNullParameter(http2Reader$Handler, "handler");
        try {
            http2Reader.source.require(9L);
        }
        catch (EOFException eOFException) {
            return false;
        }
        int n = Util.readMedium(http2Reader.source);
        if (n <= 16384) {
            Http2Reader http2Reader2 = this;
            int n2 = Util.and(http2Reader2.source.readByte(), 255);
            int n3 = Util.and(http2Reader2.source.readByte(), 255);
            int n4 = http2Reader2.source.readInt() & Integer.MAX_VALUE;
            Logger logger = Http2Reader.logger;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Http2.INSTANCE.frameLog(true, n4, n, n2, n3));
            }
            if (bl && n2 != 4) {
                throw new IOException(Intrinsics.stringPlus("Expected a SETTINGS frame but was ", Http2.INSTANCE.formattedType$okhttp(n2)));
            }
            switch (n2) {
                default: {
                    this.source.skip(n);
                    break;
                }
                case 8: {
                    this.readWindowUpdate(http2Reader$Handler, n, n3, n4);
                    break;
                }
                case 7: {
                    this.readGoAway(http2Reader$Handler, n, n3, n4);
                    break;
                }
                case 6: {
                    this.readPing(http2Reader$Handler, n, n3, n4);
                    break;
                }
                case 5: {
                    this.readPushPromise(http2Reader$Handler, n, n3, n4);
                    break;
                }
                case 4: {
                    this.readSettings(http2Reader$Handler, n, n3, n4);
                    break;
                }
                case 3: {
                    this.readRstStream(http2Reader$Handler, n, n3, n4);
                    break;
                }
                case 2: {
                    this.readPriority(http2Reader$Handler, n, n3, n4);
                    break;
                }
                case 1: {
                    this.readHeaders(http2Reader$Handler, n, n3, n4);
                    break;
                }
                case 0: {
                    this.readData(http2Reader$Handler, n, n3, n4);
                }
            }
            return true;
        }
        throw new IOException(Intrinsics.stringPlus("FRAME_SIZE_ERROR: ", n));
    }

    @Override
    public void close() {
        this.source.close();
    }
}

