/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.ConscryptPlatform$Companion;
import okhttp3.internal.platform.ConscryptPlatform$DisabledHostnameVerifier;
import okhttp3.internal.platform.Platform;
import org.conscrypt.Conscrypt;
import org.conscrypt.ConscryptHostnameVerifier;

public final class ConscryptPlatform
extends Platform {
    public static final ConscryptPlatform$Companion Companion;
    private static final boolean isSupported;
    private final Provider provider;

    private ConscryptPlatform() {
        Provider provider = Conscrypt.newProvider();
        Intrinsics.checkNotNullExpressionValue(provider, "newProvider()");
        v0.provider = provider;
    }

    public static final /* synthetic */ boolean access$isSupported$cp() {
        return isSupported;
    }

    public /* synthetic */ ConscryptPlatform(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    static {
        boolean bl;
        block7: {
            block6: {
                ConscryptPlatform$Companion conscryptPlatform$Companion;
                ConscryptPlatform$Companion conscryptPlatform$Companion2 = conscryptPlatform$Companion;
                Companion = new ConscryptPlatform$Companion(null);
                String string = "org.conscrypt.Conscrypt$Version";
                Class.forName(string, false, conscryptPlatform$Companion2.getClass().getClassLoader());
                if (!Conscrypt.isAvailable()) break block6;
                try {
                    if (!conscryptPlatform$Companion2.atLeastVersion(2, 1, 0)) break block6;
                    bl = true;
                    break block7;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
            bl = false;
        }
        isSupported = bl;
    }

    @Override
    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLS\", provider)");
        return sSLContext;
    }

    @Override
    public X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                X509TrustManager x509TrustManager = (X509TrustManager)object;
                Conscrypt.setHostnameVerifier((TrustManager)x509TrustManager, (ConscryptHostnameVerifier)ConscryptPlatform$DisabledHostnameVerifier.INSTANCE);
                return x509TrustManager;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        object = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(object, "toString(this)");
        object = Intrinsics.stringPlus("Unexpected default trust managers: ", object);
        throw new IllegalStateException(object.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(list, "protocols");
        if (Conscrypt.isConscrypt((SSLSocket)sSLSocket)) {
            Conscrypt.setUseSessionTickets((SSLSocket)sSLSocket, (boolean)true);
            String[] stringArray = Platform.Companion.alpnProtocolNames(list).toArray(new String[0]);
            if (stringArray == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            Conscrypt.setApplicationProtocols((SSLSocket)sSLSocket, (String[])stringArray);
            return;
        } else {
            super.configureTlsExtensions(sSLSocket, string, list);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        SSLSocket sSLSocket2 = sSLSocket;
        Intrinsics.checkNotNullParameter(sSLSocket2, "sslSocket");
        return Conscrypt.isConscrypt((SSLSocket)sSLSocket2) ? Conscrypt.getApplicationProtocol((SSLSocket)sSLSocket) : super.getSelectedProtocol(sSLSocket);
    }

    @Override
    public SSLSocketFactory newSslSocketFactory(X509TrustManager x509TrustManager) {
        Intrinsics.checkNotNullParameter(x509TrustManager, "trustManager");
        SSLContext sSLContext = trustManagerArray2.newSSLContext();
        TrustManager[] trustManagerArray = new TrustManager[1];
        TrustManager[] trustManagerArray2 = trustManagerArray;
        trustManagerArray[0] = x509TrustManager;
        sSLContext.init(null, trustManagerArray2, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "newSSLContext().apply {\n\u2026null)\n    }.socketFactory");
        return sSLSocketFactory;
    }
}

