/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.InflaterSource;
import okio.RealBufferedSource;
import okio.Segment;
import okio.Source;
import okio.Timeout;

public final class GzipSource
implements Source {
    private byte section;
    private final RealBufferedSource source;
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private final CRC32 crc;

    public GzipSource(Source object) {
        CRC32 cRC32;
        InflaterSource inflaterSource;
        Inflater inflater;
        RealBufferedSource realBufferedSource;
        Intrinsics.checkNotNullParameter(object, "source");
        Object object2 = realBufferedSource;
        realBufferedSource = new RealBufferedSource((Source)object);
        v1.source = object2;
        object = inflater;
        inflater = new Inflater(true);
        v1.inflater = object;
        InflaterSource inflaterSource2 = inflaterSource;
        inflaterSource = new InflaterSource((BufferedSource)object2, (Inflater)object);
        v1.inflaterSource = inflaterSource2;
        object2 = cRC32;
        cRC32 = new CRC32();
        v1.crc = object2;
    }

    private final void consumeHeader() {
        GzipSource gzipSource = this;
        gzipSource.source.require(10L);
        short s = gzipSource.source.bufferField.getByte(3L);
        boolean bl = (s >> 1 & 1) == 1;
        if (bl) {
            GzipSource gzipSource2 = this;
            gzipSource2.updateCrc(gzipSource2.source.bufferField, 0L, 10L);
        }
        GzipSource gzipSource3 = this;
        short s2 = gzipSource3.source.readShort();
        gzipSource3.checkEqual("ID1ID2", 8075, s2);
        gzipSource3.source.skip(8L);
        if ((s >> 2 & 1) == 1) {
            this.source.require(2L);
            if (bl) {
                GzipSource gzipSource4 = this;
                gzipSource4.updateCrc(gzipSource4.source.bufferField, 0L, 2L);
            }
            GzipSource gzipSource5 = this;
            long l = gzipSource5.source.bufferField.readShortLe();
            gzipSource5.source.require(l);
            if (bl) {
                GzipSource gzipSource6 = this;
                gzipSource6.updateCrc(gzipSource6.source.bufferField, 0L, l);
            }
            this.source.skip(l);
        }
        if ((s >> 3 & 1) == 1) {
            long l = this.source.indexOf((byte)0);
            if (l != -1L) {
                if (bl) {
                    Buffer buffer = this.source.bufferField;
                    long l2 = l + 1L;
                    this.updateCrc(buffer, 0L, l2);
                }
                this.source.skip(l + 1L);
            } else {
                throw new EOFException();
            }
        }
        if ((s >> 4 & 1) == 1) {
            long l = this.source.indexOf((byte)0);
            if (l != -1L) {
                if (bl) {
                    Buffer buffer = this.source.bufferField;
                    long l3 = l + 1L;
                    this.updateCrc(buffer, 0L, l3);
                }
                this.source.skip(l + 1L);
            } else {
                throw new EOFException();
            }
        }
        if (bl) {
            GzipSource gzipSource7 = this;
            short s3 = gzipSource7.source.readShortLe();
            s = (short)gzipSource7.crc.getValue();
            gzipSource7.checkEqual("FHCRC", s3, s);
            gzipSource7.crc.reset();
        }
    }

    private final void consumeTrailer() {
        GzipSource gzipSource = this;
        int n = gzipSource.source.readIntLe();
        int n2 = (int)gzipSource.crc.getValue();
        gzipSource.checkEqual("CRC", n, n2);
        n = gzipSource.source.readIntLe();
        n2 = (int)gzipSource.inflater.getBytesWritten();
        gzipSource.checkEqual("ISIZE", n, n2);
    }

    private final void updateCrc(Buffer object, long l, long l2) {
        int n;
        int n2;
        object = ((Buffer)object).head;
        Intrinsics.checkNotNull(object);
        while (l >= (long)((n2 = ((Segment)object).limit) - (n = ((Segment)object).pos))) {
            l -= (long)(n2 - n);
            object = ((Segment)object).next;
            Intrinsics.checkNotNull(object);
        }
        while (l2 > 0L) {
            Object object2 = object;
            int n3 = (int)((long)((Segment)object2).pos + l);
            int n4 = (int)Math.min((long)(((Segment)object2).limit - n3), l2);
            this.crc.update(((Segment)object).data, n3, n4);
            l2 -= (long)n4;
            l = 0L;
            object = ((Segment)object).next;
            Intrinsics.checkNotNull(object);
        }
    }

    private final void checkEqual(String string, int n, int n2) {
        if (n2 == n) {
            return;
        }
        Object[] objectArray = new Object[3];
        Object object = objectArray;
        object[0] = string;
        object[1] = n2;
        objectArray[2] = n;
        object = String.format("%s: actual 0x%08x != expected 0x%08x", Arrays.copyOf(objectArray, 3));
        Intrinsics.checkNotNullExpressionValue(object, "format(this, *args)");
        throw new IOException((String)object);
    }

    @Override
    public long read(Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "sink");
        long l2 = l - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (l3 >= 0) {
            if (l3 == false) {
                return 0L;
            }
            if (((GzipSource)((Object)string)).section == 0) {
                ((GzipSource)((Object)string)).consumeHeader();
                ((GzipSource)((Object)string)).section = 1;
            }
            if (((GzipSource)((Object)string)).section == 1) {
                long l4 = buffer.size();
                if ((l = ((GzipSource)((Object)string)).inflaterSource.read(buffer, l)) != -1L) {
                    super.updateCrc(buffer, l4, l);
                    return l;
                }
                ((GzipSource)((Object)string)).section = (byte)2;
            }
            if (((GzipSource)((Object)string)).section == 2) {
                String string = string;
                super.consumeTrailer();
                ((GzipSource)((Object)string)).section = (byte)3;
                if (!((GzipSource)((Object)string)).source.exhausted()) {
                    throw new IOException("gzip finished without exhausting source");
                }
            }
            return -1L;
        }
        String string = "byteCount < 0: " + l;
        throw new IllegalArgumentException(string.toString());
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() {
        this.inflaterSource.close();
    }
}

