/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import net.minecraft.Util;
import net.minecraftforge.common.util.NonNullSupplier;

public class CommonPanels {
    public static final int STANDARD_PANEL_HEIGHT = 84;

    public static Panel empty(ModContainerScreen<? extends ModContainer> gui, int width, int height) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"Width must be greater than zero.");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"Height must be greater than zero.");
        return (Panel)Util.m_137469_((Object)new Panel(gui), p -> p.setDesiredDimension(width, height));
    }

    public static Panel empty(ModContainerScreen<? extends ModContainer> gui, int width) {
        return CommonPanels.empty(gui, width, 84);
    }

    public static Panel verticalSeparator(ModContainerScreen<? extends ModContainer> gui, int height) {
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"Height must be greater than zero.");
        Static s = new Static(gui, 1, height);
        s.setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint(5, 0, 1, height));
        Panel p = new Panel(gui);
        p.setDesiredDimension(11, height);
        p.setLayoutEngine(new FixedLayoutEngine());
        p.addControl((IControl)s);
        return p;
    }

    public static Panel verticalSeparator(ModContainerScreen<? extends ModContainer> gui) {
        return CommonPanels.verticalSeparator(gui, 84);
    }

    public static Panel horizontalSeparator(ModContainerScreen<? extends ModContainer> gui, int width) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"Width must be greater than zero.");
        Panel p = new Panel(gui);
        p.setDesiredDimension(width, 1);
        p.setLayoutEngine(new FixedLayoutEngine());
        p.setBackground(Colour.BLACK);
        return p;
    }

    public static Panel verticalTemperatureScale(ModContainerScreen<? extends ModContainer> gui, int height) {
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"Height must be greater than zero.");
        Picture pic = new Picture(gui, gui.nextGenericName(), BaseIcons.TemperatureScale, 5, 59);
        pic.setLayoutEngineHint(FixedLayoutEngine.hint(3, 23, 5, 59));
        Panel p = new Panel(gui);
        p.setDesiredDimension(11, height);
        p.setLayoutEngine(new FixedLayoutEngine());
        p.addControl((IControl)pic);
        return p;
    }

    public static Panel verticalTemperatureScale(ModContainerScreen<? extends ModContainer> gui) {
        return CommonPanels.verticalTemperatureScale(gui, 84);
    }

    public static Panel verticalCommandPanel(ModContainerScreen<? extends ModContainer> gui, int width, int height) {
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"Height must be greater than zero.");
        Panel p = new Panel(gui);
        p.setDesiredDimension(width, height);
        p.setLayoutEngine(new FixedLayoutEngine());
        return p;
    }

    public static Panel verticalCommandPanel(ModContainerScreen<? extends ModContainer> gui, int width) {
        return CommonPanels.verticalCommandPanel(gui, width, 84);
    }

    public static Panel verticalCommandPanel(ModContainerScreen<? extends ModContainer> gui) {
        return CommonPanels.verticalCommandPanel(gui, -1, 84);
    }

    public static Picture icon(ModContainerScreen<? extends ModContainer> gui, NonNullSupplier<ISprite> icon) {
        return (Picture)Util.m_137469_((Object)new Picture(gui, "icn", icon), p -> p.setDesiredDimension(16, 16));
    }
}

