/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner;

import com.ael.viner.registry.VinerBlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class VinerPlayerData {
    private final UUID playerId;
    private List<Block> vineableBlocks;
    private List<Block> unvineableBlocks;
    private List<TagKey<Block>> vineableTags;
    private List<TagKey<Block>> unvineableTags;
    private boolean vineKeyPressed = false;
    private boolean vineAllEnabled = false;
    private double exhaustionPerBlock;
    private int vineableLimit;
    private int heightAbove;
    private int heightBelow;
    private int widthLeft;
    private int widthRight;
    private int layerOffset;
    private boolean isShapeVine;

    public VinerPlayerData(UUID playerId) {
        this.playerId = playerId;
        this.initializeConfig();
    }

    private void initializeConfig() {
        this.vineAllEnabled = VinerBlockRegistry.isVineAll();
        this.exhaustionPerBlock = VinerBlockRegistry.getExhaustionPerBlock();
        this.vineableLimit = VinerBlockRegistry.getVineableLimit();
        this.heightAbove = VinerBlockRegistry.getHeightAbove();
        this.heightBelow = VinerBlockRegistry.getHeightBelow();
        this.widthLeft = VinerBlockRegistry.getWidthLeft();
        this.widthRight = VinerBlockRegistry.getWidthRight();
        this.layerOffset = VinerBlockRegistry.getLayerOffset();
        this.vineableBlocks = VinerBlockRegistry.getVineableBlocks();
        this.unvineableBlocks = VinerBlockRegistry.getUnvineableBlocks();
        this.vineableTags = VinerBlockRegistry.getVineableTags();
        this.unvineableTags = VinerBlockRegistry.getUnvineableTags();
        this.isShapeVine = VinerBlockRegistry.isShapeVine();
    }

    public List<Block> getVineableBlocks() {
        return this.vineableBlocks;
    }

    public void setVineableBlocks(List<Block> vineableBlocks) {
        this.vineableBlocks = new ArrayList<Block>(vineableBlocks);
    }

    public List<Block> getUnvineableBlocks() {
        return this.unvineableBlocks;
    }

    public void setUnvineableBlocks(List<Block> unvineableBlocks) {
        this.unvineableBlocks = new ArrayList<Block>(unvineableBlocks);
    }

    public List<TagKey<Block>> getVineableTags() {
        return this.vineableTags;
    }

    public void setVineableTags(List<TagKey<Block>> vineableTags) {
        this.vineableTags = vineableTags;
    }

    public List<TagKey<Block>> getUnvineableTags() {
        return this.unvineableTags;
    }

    public void setUnvineableTags(List<TagKey<Block>> unvineableTags) {
        this.unvineableTags = unvineableTags;
    }

    public boolean isVineKeyPressed() {
        return this.vineKeyPressed;
    }

    public void setVineKeyPressed(boolean pressed) {
        this.vineKeyPressed = pressed;
    }

    public boolean isVineAllEnabled() {
        return this.vineAllEnabled;
    }

    public void setVineAllEnabled(boolean enabled) {
        this.vineAllEnabled = enabled;
    }

    public double getExhaustionPerBlock() {
        return this.exhaustionPerBlock;
    }

    public void setExhaustionPerBlock(double exhaustionPerBlock) {
        this.exhaustionPerBlock = exhaustionPerBlock;
    }

    public int getVineableLimit() {
        return this.vineableLimit;
    }

    public void setVineableLimit(int vineableLimit) {
        this.vineableLimit = vineableLimit;
    }

    public int getHeightAbove() {
        return this.heightAbove;
    }

    public void setHeightAbove(int heightAbove) {
        this.heightAbove = heightAbove;
    }

    public int getHeightBelow() {
        return this.heightBelow;
    }

    public void setHeightBelow(int heightBelow) {
        this.heightBelow = heightBelow;
    }

    public int getWidthLeft() {
        return this.widthLeft;
    }

    public void setWidthLeft(int widthLeft) {
        this.widthLeft = widthLeft;
    }

    public int getWidthRight() {
        return this.widthRight;
    }

    public void setWidthRight(int widthRight) {
        this.widthRight = widthRight;
    }

    public int getLayerOffset() {
        return this.layerOffset;
    }

    public void setLayerOffset(int layerOffset) {
        this.layerOffset = layerOffset;
    }

    public boolean isShapeVine() {
        return this.isShapeVine;
    }

    public void setShapeVine(boolean isShapeVine) {
        this.isShapeVine = isShapeVine;
    }
}

