/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.gui;

import com.ael.viner.registry.VinerBlockRegistry;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class BlockListScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String minecraftTagsLink = "https://mcreator.net/wiki/minecraft-block-and-item-list-registry-and-code-names";
    private int linkX;
    private int linkY;
    private int linkWidth;
    private int linkHeight;
    private final Screen parent;
    private final List<? extends String> blockList;
    private final Consumer<List<String>> configUpdater;
    private EditBox blockTagInputField;
    private int maxWidth = 0;

    public BlockListScreen(Screen parent, String screenTitle, List<? extends String> blockList, Consumer<List<String>> configUpdater) {
        super((Component)Component.m_237113_((String)screenTitle));
        this.parent = parent;
        this.blockList = blockList;
        this.configUpdater = configUpdater;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setupUIElements();
    }

    private void setupUIElements() {
        this.setupInputField();
        this.setupControlButtons();
        this.addRemoveButtons();
    }

    private void setupInputField() {
        int fieldWidth = 200;
        int fieldX = this.f_96543_ / 2 - fieldWidth / 2;
        int fieldY = this.f_96544_ - 70;
        this.blockTagInputField = new EditBox(this.f_96547_, fieldX, fieldY, fieldWidth, 20, (Component)Component.m_237113_((String)""));
        this.blockTagInputField.m_94199_(50);
        this.m_142416_((GuiEventListener)this.blockTagInputField);
    }

    private void setupControlButtons() {
        int fieldWidth = 200;
        int fieldX = this.f_96543_ / 2 - fieldWidth / 2;
        int buttonY = this.blockTagInputField.m_252907_() + 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> Minecraft.m_91087_().m_91152_(this.parent)).m_252794_(fieldX, buttonY).m_252780_(fieldWidth / 2 - 2).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Add"), button -> {
            String input = this.blockTagInputField.m_94155_();
            if (this.validateInput(input)) {
                ArrayList<String> tempList = new ArrayList<String>(this.blockList);
                tempList.add(input);
                this.applyConfigChanges(tempList);
                this.blockTagInputField.m_94144_("");
            } else {
                LOGGER.error("Invalid block/tag format: {}", (Object)input);
            }
        }).m_252794_(fieldX + fieldWidth / 2 + 2, buttonY).m_252780_(fieldWidth / 2 - 2).m_253136_());
    }

    private boolean validateInput(String input) {
        return input.matches("^#?[a-z_]+:[a-z_]+$");
    }

    private void addRemoveButtons() {
        this.calculateMaxWidth();
        this.setupRemoveButtonForEachBlock();
    }

    private void calculateMaxWidth() {
        this.maxWidth = this.blockList.stream().mapToInt(block -> this.f_96547_.m_92895_(block)).max().orElse(0);
    }

    private void setupRemoveButtonForEachBlock() {
        int yStart = 40;
        int i = 0;
        while (i < this.blockList.size()) {
            int index = i++;
            int buttonX = this.f_96543_ / 2 + (this.maxWidth + 8) / 2 + 4;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"X"), button -> {
                ArrayList<String> tempList = new ArrayList<String>(this.blockList);
                tempList.remove(index);
                this.applyConfigChanges(tempList);
            }).m_252794_(buttonX, yStart).m_252780_(20).m_253136_());
            Objects.requireNonNull(this.f_96547_);
            yStart += 9 + 10;
        }
    }

    private void applyConfigChanges(List<String> updatedList) {
        try {
            this.configUpdater.accept(updatedList);
            VinerBlockRegistry.setup();
            Minecraft.m_91087_().m_91152_((Screen)new BlockListScreen(this.parent, this.f_96539_.getString(), updatedList, this.configUpdater));
        }
        catch (Exception e) {
            LOGGER.error("Error applying config changes: {}", (Object)e.getMessage());
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int yStart = 40;
        this.renderInstructionalText(graphics, yStart);
        this.renderBlocksAndTags(graphics, yStart += 5);
    }

    private void renderInstructionalText(@NotNull GuiGraphics graphics, int yStart) {
        String instructionalText = "Enter block names or tags here, for example:";
        int textY = yStart - 30;
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)instructionalText), this.f_96543_ / 2 - this.f_96547_.m_92895_(instructionalText) / 2, textY, 0xFFFFFF);
        this.linkX = this.f_96543_ / 2 - this.f_96547_.m_92895_("https://mcreator.net/wiki/minecraft-block-and-item-list-registry-and-code-names") / 2;
        this.linkY = textY + 10;
        this.linkWidth = this.f_96547_.m_92895_("https://mcreator.net/wiki/minecraft-block-and-item-list-registry-and-code-names");
        Objects.requireNonNull(this.f_96547_);
        this.linkHeight = 9;
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"https://mcreator.net/wiki/minecraft-block-and-item-list-registry-and-code-names"), this.linkX, this.linkY, 0x55FF55);
    }

    private void renderBlocksAndTags(@NotNull GuiGraphics graphics, int yStart) {
        for (String string : this.blockList) {
            int boxX = this.f_96543_ / 2 - (this.maxWidth + 8) / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280509_(boxX, yStart, boxX + this.maxWidth + 8, yStart + 9 + 8, -11184811);
            graphics.m_280488_(this.f_96547_, string, boxX + 4, yStart + 4, 0xFFFFFF);
            Objects.requireNonNull(this.f_96547_);
            yStart += 9 + 10;
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

