/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.gui;

import com.ael.viner.config.Config;
import com.ael.viner.gui.BlockListScreen;
import com.ael.viner.gui.GuiUtils;
import com.ael.viner.network.packets.ConfigSyncPacket;
import com.ael.viner.registry.VinerBlockRegistry;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int boxWidth;
    private int padding;
    private int leftColumnX;
    private int rightColumnX;
    private int yStart;
    private int stepSize;
    private Button vineableBlockListButton;
    private Button nonVineableBlockListButton;
    private Button shapeVineButton;
    private Button vineAllButton;
    private AbstractSliderButton heightBelowField;
    private AbstractSliderButton heightAboveField;
    private AbstractSliderButton widthLeftField;
    private AbstractSliderButton widthRightField;
    private AbstractSliderButton layerOffsetField;
    private AbstractSliderButton vineableLimitField;
    private AbstractSliderButton exhaustionPerBlockField;

    public ConfigScreen() {
        super((Component)Component.m_237113_((String)"Viner Configurations"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.calculateLayoutParameters();
        this.addConfigWidgets();
        this.addApplyButton();
        this.updateBlockListButtonState();
    }

    private void calculateLayoutParameters() {
        this.boxWidth = Math.min(150, this.f_96543_ / 4);
        this.leftColumnX = this.padding = this.f_96543_ / 5;
        this.rightColumnX = this.f_96543_ - this.boxWidth - this.padding;
        this.yStart = this.f_96544_ / 4;
        this.stepSize = 30;
    }

    private void updateBlockListButtonState() {
        boolean isShapeVineEnabled;
        boolean isVineAllEnabled;
        this.vineableBlockListButton.f_93623_ = isVineAllEnabled = (Boolean)Config.VINE_ALL.get() == false;
        this.nonVineableBlockListButton.f_93623_ = isVineAllEnabled;
        this.heightBelowField.f_93623_ = isShapeVineEnabled = ((Boolean)Config.SHAPE_VINE.get()).booleanValue();
        this.heightAboveField.f_93623_ = isShapeVineEnabled;
        this.widthLeftField.f_93623_ = isShapeVineEnabled;
        this.widthRightField.f_93623_ = isShapeVineEnabled;
        this.layerOffsetField.f_93623_ = isShapeVineEnabled;
    }

    private void addConfigWidgets() {
        this.addLeftColumnWidgets();
        this.yStart = this.f_96544_ / 4;
        this.addRightColumnWidgets();
    }

    private void addRedirectButtons() {
        BlockListScreen vineableBlockListScreen = new BlockListScreen(this, "Vineable Block List", (List)Config.VINEABLE_BLOCKS.get(), updatedList -> {
            Config.VINEABLE_BLOCKS.set(updatedList);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.BLOCK_LIST, updatedList, "vineableBlocks");
        });
        this.vineableBlockListButton = GuiUtils.createRedirectButton(this.leftColumnX, this.yStart, this.boxWidth, 20, "Vineable Block List", vineableBlockListScreen);
        this.m_142416_((GuiEventListener)this.vineableBlockListButton);
        this.yStart += this.stepSize;
        BlockListScreen nonVineableBlockListScreen = new BlockListScreen(this, "Non-Vineable Block List", (List)Config.UNVINEABLE_BLOCKS.get(), updatedList -> {
            Config.UNVINEABLE_BLOCKS.set(updatedList);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.BLOCK_LIST, updatedList, "unvineableBlocks");
        });
        this.nonVineableBlockListButton = GuiUtils.createRedirectButton(this.leftColumnX, this.yStart, this.boxWidth, 20, "Non-Vineable Block List", nonVineableBlockListScreen);
        this.m_142416_((GuiEventListener)this.nonVineableBlockListButton);
    }

    private void addLeftColumnWidgets() {
        this.addRedirectButtons();
        this.yStart += this.stepSize * 2;
        this.vineAllButton = GuiUtils.createConfigBooleanButton(this.leftColumnX, this.yStart, this.boxWidth, 20, "Vine All", Config.VINE_ALL, newValue -> {
            Config.VINE_ALL.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.BOOLEAN, newValue, "vineAll");
            this.updateBlockListButtonState();
        });
        this.m_142416_((GuiEventListener)this.vineAllButton);
        this.yStart += this.stepSize;
        this.vineableLimitField = GuiUtils.createConfigSlider(this.leftColumnX, this.yStart, this.boxWidth, 20, 0, 500, "Vineable Limit", (Supplier<Integer>)Config.VINEABLE_LIMIT, newValue -> {
            Config.VINEABLE_LIMIT.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.INT, newValue, "vineableLimit");
        });
        this.m_142416_((GuiEventListener)this.vineableLimitField);
        this.yStart += this.stepSize;
        this.exhaustionPerBlockField = GuiUtils.createConfigSlider(this.leftColumnX, this.yStart, this.boxWidth, 20, 20.0, "Hunger Per Block", (Supplier<Double>)Config.EXHAUSTION_PER_BLOCK, newValue -> {
            Config.EXHAUSTION_PER_BLOCK.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.DOUBLE, newValue, "exhaustionPerBlock");
        });
        this.m_142416_((GuiEventListener)this.exhaustionPerBlockField);
    }

    private void addRightColumnWidgets() {
        this.shapeVineButton = GuiUtils.createConfigBooleanButton(this.rightColumnX, this.yStart, this.boxWidth, 20, "Shape Vine", (Supplier<Boolean>)Config.SHAPE_VINE, newValue -> {
            Config.SHAPE_VINE.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.BOOLEAN, newValue, "shapeVine");
            this.updateBlockListButtonState();
        });
        this.m_142416_((GuiEventListener)this.shapeVineButton);
        this.yStart += this.stepSize;
        this.heightAboveField = GuiUtils.createConfigSlider(this.rightColumnX, this.yStart, this.boxWidth, 20, 0, 100, "Height Above", (Supplier<Integer>)Config.HEIGHT_ABOVE, newValue -> {
            Config.HEIGHT_ABOVE.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.INT, newValue, "heightAbove");
        });
        this.m_142416_((GuiEventListener)this.heightAboveField);
        this.yStart += this.stepSize;
        this.heightBelowField = GuiUtils.createConfigSlider(this.rightColumnX, this.yStart, this.boxWidth, 20, 0, 100, "Height Below", (Supplier<Integer>)Config.HEIGHT_BELOW, newValue -> {
            Config.HEIGHT_BELOW.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.INT, newValue, "heightBelow");
        });
        this.m_142416_((GuiEventListener)this.heightBelowField);
        this.yStart += this.stepSize;
        this.widthLeftField = GuiUtils.createConfigSlider(this.rightColumnX, this.yStart, this.boxWidth, 20, 0, 100, "Width Left", (Supplier<Integer>)Config.WIDTH_LEFT, newValue -> {
            Config.WIDTH_LEFT.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.INT, newValue, "widthLeft");
        });
        this.m_142416_((GuiEventListener)this.widthLeftField);
        this.yStart += this.stepSize;
        this.widthRightField = GuiUtils.createConfigSlider(this.rightColumnX, this.yStart, this.boxWidth, 20, 0, 100, "Width Right", (Supplier<Integer>)Config.WIDTH_RIGHT, newValue -> {
            Config.WIDTH_RIGHT.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.INT, newValue, "widthRight");
        });
        this.m_142416_((GuiEventListener)this.widthRightField);
        this.yStart += this.stepSize;
        this.layerOffsetField = GuiUtils.createConfigSlider(this.rightColumnX, this.yStart, this.boxWidth, 20, -64, 256, "Layer Offset", (Supplier<Integer>)Config.LAYER_OFFSET, newValue -> {
            Config.LAYER_OFFSET.set(newValue);
            ConfigSyncPacket.syncConfigWithServer(ConfigSyncPacket.ConfigType.INT, newValue, "layerOffset");
        });
        this.m_142416_((GuiEventListener)this.layerOffsetField);
    }

    private void addApplyButton() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Apply"), button -> this.applyConfigChanges()).m_252794_(this.f_96543_ / 2 - this.boxWidth / 2, this.f_96544_ - 50).m_252780_(this.boxWidth).m_253136_());
    }

    private void applyConfigChanges() {
        try {
            VinerBlockRegistry.setup();
            Minecraft.m_91087_().m_91152_(null);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Error applying config changes: {}", (Object)e.getMessage());
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltips(graphics, mouseX - 60, mouseY - 10);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        graphics.m_280430_(this.f_96547_, this.f_96539_, (this.f_96543_ - titleWidth) / 2, 15, 0xFFFFFF);
    }

    private void renderTooltips(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.shapeVineButton.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Enables shaping vines according to specific dimensions."), mouseX, mouseY);
        }
        if (this.vineableBlockListButton.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Configure which blocks are vineable."), mouseX, mouseY);
        }
        if (this.nonVineableBlockListButton.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Configure which blocks are non-vineable."), mouseX, mouseY);
        }
        if (this.vineAllButton.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Toggle to vine all blocks without exceptions."), mouseX, mouseY);
        }
        if (this.heightBelowField.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Sets the vine growth limit below the source block."), mouseX, mouseY);
        }
        if (this.heightAboveField.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Sets the vine growth limit above the source block."), mouseX, mouseY);
        }
        if (this.widthLeftField.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Sets the vine growth limit left of the source block."), mouseX, mouseY);
        }
        if (this.widthRightField.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Sets the vine growth limit right of the source block."), mouseX, mouseY);
        }
        if (this.layerOffsetField.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Adjusts the vertical offset between each shape vined layer."), mouseX, mouseY);
        }
        if (this.vineableLimitField.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Limits the number of blocks that can be vineable."), mouseX, mouseY);
        }
        if (this.exhaustionPerBlockField.m_198029_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Sets the hunger rate per vined block."), mouseX, mouseY);
        }
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

