/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.network.packets;

import com.ael.viner.Viner;
import com.ael.viner.network.VinerPacketHandler;
import com.ael.viner.network.packets.AbstractPacket;
import com.ael.viner.registry.VinerBlockRegistry;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ConfigSyncPacket
extends AbstractPacket<ConfigData> {
    public static final AbstractPacket.PacketFactory<ConfigSyncPacket> FACTORY = buf -> {
        ConfigType type = (ConfigType)buf.m_130066_(ConfigType.class);
        String configName = buf.m_130136_(Short.MAX_VALUE);
        Object value = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigType.BOOLEAN -> buf.readBoolean();
            case ConfigType.DOUBLE -> buf.readDouble();
            case ConfigType.INT -> buf.readInt();
            case ConfigType.BLOCK_LIST -> buf.m_236845_(FriendlyByteBuf::m_130277_);
        };
        return new ConfigSyncPacket(new ConfigData(type, value, configName));
    };
    private static final Logger LOGGER = LogUtils.getLogger();

    public ConfigSyncPacket(ConfigData data) {
        super(data);
    }

    public static void encode(ConfigSyncPacket msg, FriendlyByteBuf buf) {
        ConfigData data = (ConfigData)msg.getData();
        buf.m_130068_((Enum)data.type());
        buf.m_130070_(data.configName());
        switch (data.type()) {
            case BOOLEAN: {
                buf.writeBoolean(((Boolean)data.value()).booleanValue());
                break;
            }
            case DOUBLE: {
                buf.writeDouble(((Double)data.value()).doubleValue());
                break;
            }
            case INT: {
                buf.writeInt(((Integer)data.value()).intValue());
                break;
            }
            case BLOCK_LIST: {
                List list = (List)data.value();
                buf.m_236828_((Collection)list, FriendlyByteBuf::m_130070_);
            }
        }
    }

    public static void syncConfigWithServer(ConfigType type, Object value, String configName) {
        ConfigSyncPacket packet = new ConfigSyncPacket(new ConfigData(type, value, configName));
        VinerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    @Override
    public void handle(AbstractPacket<ConfigData> msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        if ("vineAll".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.BOOLEAN) {
            Viner.getInstance().getPlayerRegistry().setVineAllEnabled(player, (Boolean)msg.getData().value());
        } else if ("vineableLimit".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.INT) {
            Viner.getInstance().getPlayerRegistry().setVineableLimit(player, (Integer)msg.getData().value());
        } else if ("exhaustionPerBlock".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.DOUBLE) {
            Viner.getInstance().getPlayerRegistry().setExhaustionPerBlock(player, (Double)msg.getData().value());
        } else if ("heightAbove".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.INT) {
            Viner.getInstance().getPlayerRegistry().setHeightAbove(player, (Integer)msg.getData().value());
        } else if ("heightBelow".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.INT) {
            Viner.getInstance().getPlayerRegistry().setHeightBelow(player, (Integer)msg.getData().value());
        } else if ("widthLeft".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.INT) {
            Viner.getInstance().getPlayerRegistry().setWidthLeft(player, (Integer)msg.getData().value());
        } else if ("widthRight".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.INT) {
            Viner.getInstance().getPlayerRegistry().setWidthRight(player, (Integer)msg.getData().value());
        } else if ("layerOffset".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.INT) {
            Viner.getInstance().getPlayerRegistry().setLayerOffset(player, (Integer)msg.getData().value());
        } else if ("shapeVine".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.BOOLEAN) {
            Viner.getInstance().getPlayerRegistry().setShapeVine(player, (Boolean)msg.getData().value());
        } else if ("vineableBlocks".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.BLOCK_LIST) {
            List entries = (List)msg.getData().value();
            List<Block> blocks = VinerBlockRegistry.getBlocksFromConfigEntries(entries);
            List<TagKey<Block>> tags = VinerBlockRegistry.getTagsFromConfigEntries(entries);
            Viner.getInstance().getPlayerRegistry().setVineableBlocks(player, blocks);
            Viner.getInstance().getPlayerRegistry().setVineableTags(player, tags);
        } else if ("unvineableBlocks".equals(msg.getData().configName()) && msg.getData().type() == ConfigType.BLOCK_LIST) {
            List entries = (List)msg.getData().value();
            List<Block> blocks = VinerBlockRegistry.getBlocksFromConfigEntries(entries);
            List<TagKey<Block>> tags = VinerBlockRegistry.getTagsFromConfigEntries(entries);
            Viner.getInstance().getPlayerRegistry().setUnvineableBlocks(player, blocks);
            Viner.getInstance().getPlayerRegistry().setUnvineableTags(player, tags);
        }
        ctx.get().setPacketHandled(true);
    }

    public record ConfigData(ConfigType type, Object value, String configName) {
    }

    public static enum ConfigType {
        BOOLEAN,
        DOUBLE,
        INT,
        BLOCK_LIST;

    }
}

