/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.network.packets;

import com.ael.viner.Viner;
import com.ael.viner.network.packets.AbstractPacket;
import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class MouseScrollPacket
extends AbstractPacket<Double> {
    public static final AbstractPacket.PacketFactory<MouseScrollPacket> FACTORY = buf -> {
        double scrollDelta = buf.readDouble();
        return new MouseScrollPacket(scrollDelta);
    };
    private static final Logger LOGGER = LogUtils.getLogger();

    public MouseScrollPacket(Double data) {
        super(data);
    }

    public static void processScrollEvent(Double data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        double scrollDelta = data;
        if (Viner.getInstance().getPlayerRegistry().getPlayerData((Player)Objects.requireNonNull(context.getSender())).isVineKeyPressed() && scrollDelta != 0.0) {
            MutableComponent message = Component.m_237113_((String)"Shape vine enabled");
            assert (player != null);
            player.m_213846_((Component)message);
        }
    }

    @Override
    public void handle(AbstractPacket<Double> msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> MouseScrollPacket.processScrollEvent((Double)msg.getData(), (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }
}

