/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.registry;

import com.ael.viner.VinerPlayerData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class VinerPlayerRegistry {
    private final Map<UUID, VinerPlayerData> players = new HashMap<UUID, VinerPlayerData>();

    public static VinerPlayerRegistry create() {
        return new VinerPlayerRegistry();
    }

    public VinerPlayerData getPlayerData(Player player) {
        return this.players.computeIfAbsent(player.m_20148_(), VinerPlayerData::new);
    }

    public void setVineableBlocks(ServerPlayer player, List<Block> vineableBlocks) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setVineableBlocks(vineableBlocks);
    }

    public void setUnvineableBlocks(ServerPlayer player, List<Block> unvineableBlocks) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setUnvineableBlocks(unvineableBlocks);
    }

    public void setVineableTags(ServerPlayer player, List<TagKey<Block>> vineableTags) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setVineableTags(vineableTags);
    }

    public void setUnvineableTags(ServerPlayer player, List<TagKey<Block>> unvineableTags) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setUnvineableTags(unvineableTags);
    }

    public void setVineKeyPressed(ServerPlayer player, boolean vineKeyPressed) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setVineKeyPressed(vineKeyPressed);
    }

    public void setVineAllEnabled(ServerPlayer player, boolean vineAllEnabled) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setVineAllEnabled(vineAllEnabled);
    }

    public void setExhaustionPerBlock(ServerPlayer player, double exhaustionPerBlock) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setExhaustionPerBlock(exhaustionPerBlock);
    }

    public void setVineableLimit(ServerPlayer player, int vineableLimit) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setVineableLimit(vineableLimit);
    }

    public void setHeightAbove(ServerPlayer player, int heightAbove) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setHeightAbove(heightAbove);
    }

    public void setHeightBelow(ServerPlayer player, int heightBelow) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setHeightBelow(heightBelow);
    }

    public void setWidthLeft(ServerPlayer player, int widthLeft) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setWidthLeft(widthLeft);
    }

    public void setWidthRight(ServerPlayer player, int widthRight) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setWidthRight(widthRight);
    }

    public void setLayerOffset(ServerPlayer player, int layerOffset) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setLayerOffset(layerOffset);
    }

    public void setShapeVine(ServerPlayer player, Boolean shapeVine) {
        VinerPlayerData playerData = this.getPlayerData((Player)player);
        playerData.setShapeVine(shapeVine);
    }
}

