/*
 * Decompiled with CFR 0.152.
 */
package com.ael.viner.util;

import com.ael.viner.Viner;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class MiningUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void mineBlocks(ServerPlayer player, List<BlockPos> blocksToMine) {
        if (player == null) {
            return;
        }
        Level level = player.m_9236_();
        ItemStack tool = player.m_21120_(InteractionHand.MAIN_HAND);
        int vineableLimit = Viner.getInstance().getPlayerRegistry().getPlayerData((Player)player).getVineableLimit();
        if (level.m_5776_() || vineableLimit <= 0) {
            return;
        }
        BlockPos firstBlockPos = blocksToMine.get(0);
        int currentBlock = 1;
        for (BlockPos blockPos : blocksToMine) {
            if (currentBlock++ != 1 && MiningUtils.applyDamage(tool, 1)) break;
            MiningUtils.protectStorage(level, blockPos);
            MiningUtils.spawnBlockDrops(player, (ServerLevel)level, blockPos, tool, firstBlockPos);
            MiningUtils.spawnExp(level.m_8055_(blockPos), (ServerLevel)level, firstBlockPos, tool);
            boolean isIceWithoutSilkTouch = level.m_8055_(blockPos).m_60734_() == Blocks.f_50126_ && tool.getEnchantmentLevel(Enchantments.f_44985_) == 0;
            level.m_46597_(blockPos, isIceWithoutSilkTouch ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
        }
    }

    private static void protectStorage(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity != null) {
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                NonNullList inventoryContents = NonNullList.m_122780_((int)itemHandler.getSlots(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    inventoryContents.set(i, (Object)itemHandler.getStackInSlot(i).m_41777_());
                }
                CompoundTag inventoryTag = new CompoundTag();
                ContainerHelper.m_18976_((CompoundTag)inventoryTag, (NonNullList)inventoryContents, (boolean)true);
                CompoundTag persistentData = blockEntity.getPersistentData();
                persistentData.m_128365_("Items", (Tag)inventoryTag.m_128437_("Items", 10));
                blockEntity.m_6596_();
            });
        }
    }

    private static void spawnExp(BlockState blockState, ServerLevel level, BlockPos blockPos, ItemStack tool) {
        int silkTouchLevel;
        int fortuneLevel = tool.getEnchantmentLevel(Enchantments.f_44987_);
        int exp = blockState.getExpDrop((LevelReader)level, level.f_46441_, blockPos, fortuneLevel, silkTouchLevel = tool.getEnchantmentLevel(Enchantments.f_44985_));
        if (exp > 0) {
            blockState.m_60734_().m_49805_(level, blockPos, exp);
        }
    }

    private static void spawnBlockDrops(ServerPlayer player, ServerLevel level, BlockPos blockPos, ItemStack tool, BlockPos firstBlockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        CompoundTag blockEntityTag = null;
        if (blockEntity instanceof ShulkerBoxBlockEntity) {
            blockEntityTag = blockEntity.m_187482_();
        }
        List itemsToDrop = Block.m_49874_((BlockState)level.m_8055_(blockPos), (ServerLevel)level, (BlockPos)blockPos, null, (Entity)player, (ItemStack)tool);
        for (ItemStack item : itemsToDrop) {
            if (blockEntityTag != null && item.m_41720_() instanceof BlockItem && ((BlockItem)item.m_41720_()).m_40614_() instanceof ShulkerBoxBlock) {
                CompoundTag itemTag = item.m_41784_();
                itemTag.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
                item.m_41751_(itemTag);
            }
            double d0 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
            double d1 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
            double d2 = (double)(level.f_46441_.m_188501_() * 0.5f) + 0.25;
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)firstBlockPos.m_123341_() + d0, (double)firstBlockPos.m_123342_() + d1, (double)firstBlockPos.m_123343_() + d2, item);
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static List<BlockPos> collectConnectedBlocks(Level level, BlockPos pos, BlockState targetState, Vec3i lookPos, int vineableLimit, boolean isShapeVine, int heightAbove, int heightBelow, int widthLeft, int widthRight, int layerOffset) {
        ArrayList<BlockPos> connectedBlocks = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        if (isShapeVine) {
            MiningUtils.collectConfigurablePattern(level, lookPos, pos, targetState, connectedBlocks, visited, vineableLimit, heightAbove, heightBelow, widthLeft, widthRight, layerOffset);
        } else {
            MiningUtils.collect(level, pos, targetState, connectedBlocks, visited, vineableLimit);
        }
        return connectedBlocks;
    }

    private static void collect(Level level, BlockPos pos, BlockState targetState, List<BlockPos> connectedBlocks, Set<BlockPos> visited, int vineableLimit) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(pos);
        while (!queue.isEmpty() && connectedBlocks.size() < vineableLimit) {
            BlockPos currentPos = (BlockPos)queue.poll();
            if (visited.contains(currentPos) || !targetState.m_60734_().equals(level.m_8055_(currentPos).m_60734_())) continue;
            visited.add(currentPos);
            connectedBlocks.add(currentPos);
            for (Direction direction : Direction.values()) {
                queue.add(currentPos.m_121945_(direction));
            }
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        queue.add(currentPos.m_7918_(dx, dy, dz));
                    }
                }
            }
        }
    }

    private static void collectConfigurablePattern(Level level, Vec3i lookPos, BlockPos pos, BlockState targetState, List<BlockPos> connectedBlocks, Set<BlockPos> visited, int vineableLimit, int heightAbove, int heightBelow, int widthLeft, int widthRight, int layerOffset) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(pos);
        Vec3i horizontalDirection = new Vec3i(lookPos.m_123343_(), 0, -lookPos.m_123341_());
        int blockVolumeToMine = (heightAbove + heightBelow + 1) * (widthLeft + widthRight + 1);
        while (!queue.isEmpty() && connectedBlocks.size() + blockVolumeToMine <= vineableLimit) {
            BlockPos currentPos = (BlockPos)queue.poll();
            HashSet<BlockPos> potentialBlocks = new HashSet<BlockPos>();
            for (int h = -heightBelow; h <= heightAbove; ++h) {
                for (int w = -widthLeft; w <= widthRight; ++w) {
                    BlockPos blockToMine = currentPos.m_7918_(horizontalDirection.m_123341_() * w, h, horizontalDirection.m_123343_() * w);
                    potentialBlocks.add(blockToMine);
                }
            }
            potentialBlocks.removeAll(visited);
            for (BlockPos blockToMine : potentialBlocks) {
                if (!targetState.m_60734_().equals(level.m_8055_(blockToMine).m_60734_())) continue;
                visited.add(blockToMine);
                connectedBlocks.add(blockToMine);
            }
            BlockPos nextDepthBlock = currentPos.m_7918_(lookPos.m_123341_(), lookPos.m_123342_() - layerOffset, lookPos.m_123343_());
            if (visited.contains(nextDepthBlock) || level.m_8055_(nextDepthBlock).m_60795_()) continue;
            queue.add(nextDepthBlock);
        }
    }

    public static boolean isVineable(Block block, Player player) {
        return Viner.getInstance().getPlayerRegistry().getPlayerData(player).isVineAllEnabled() || !MiningUtils.blockExistsInUnvineableBlocks(block, player) && MiningUtils.blockExistsInVineableBlocks(block, player);
    }

    private static boolean blockExistsInUnvineableBlocks(Block block, Player player) {
        return Viner.getInstance().getPlayerRegistry().getPlayerData(player).getUnvineableBlocks().contains(block) || MiningUtils.blockExistsInUnvineableTags(block, player);
    }

    private static boolean blockExistsInVineableBlocks(Block block, Player player) {
        return Viner.getInstance().getPlayerRegistry().getPlayerData(player).getVineableBlocks().contains(block) || MiningUtils.blockExistsInVineableTags(block, player);
    }

    private static boolean blockExistsInVineableTags(Block block, Player player) {
        List<TagKey<Block>> tags = Viner.getInstance().getPlayerRegistry().getPlayerData(player).getVineableTags();
        for (TagKey<Block> tagKey : tags) {
            if (!MiningUtils.tagContainsBlock(tagKey, block)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockExistsInUnvineableTags(Block block, Player player) {
        List<TagKey<Block>> tags = Viner.getInstance().getPlayerRegistry().getPlayerData(player).getUnvineableTags();
        for (TagKey<Block> tagKey : tags) {
            if (!MiningUtils.tagContainsBlock(tagKey, block)) continue;
            return true;
        }
        return false;
    }

    private static boolean tagContainsBlock(TagKey<Block> tagKey, Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(tagKey).contains((Object)block);
    }

    public static int getUnbreakingLevel(ItemStack tool) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)tool);
    }

    public static double getDamageChance(int unbreakingLevel) {
        return 1.0 / (double)(unbreakingLevel + 1);
    }

    public static boolean applyDamage(@NotNull ItemStack tool, int damage) {
        if (!tool.m_41763_()) {
            return false;
        }
        int unbreakingLevel = MiningUtils.getUnbreakingLevel(tool);
        double chance = MiningUtils.getDamageChance(unbreakingLevel);
        double random = Math.random();
        if (random < chance) {
            int maxDamage;
            int newDamage = tool.m_41773_() + damage;
            if (newDamage >= (maxDamage = tool.m_41776_())) {
                tool.m_41721_(maxDamage);
                return true;
            }
            tool.m_41721_(newDamage);
        }
        return false;
    }
}

