/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.damagenumbers.client;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public record Color(float r, float g, float b, float a) {
    private static final Pattern pattern = Pattern.compile("#?([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})?", 2);

    public Color(int value) {
        this(Math.max(0.0f, (float)(value >> 16 & 0xFF) / 255.0f), Math.max(0.0f, (float)(value >> 8 & 0xFF) / 255.0f), Math.max(0.0f, (float)(value & 0xFF) / 255.0f), Math.max(0.0f, (float)(value >> 24 & 0xFF) / 255.0f));
    }

    public Color(@NotNull java.awt.Color color) {
        this(color.getRGB());
    }

    public int getValue() {
        int value = 0;
        value |= Color.convertComponent(this.a) << 24;
        value |= Color.convertComponent(this.r) << 16;
        value |= Color.convertComponent(this.g) << 8;
        return value |= Color.convertComponent(this.b);
    }

    @NotNull
    public java.awt.Color toNativeColor() {
        return new java.awt.Color(this.getValue(), true);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.a == 1.0f) {
            return String.format("#%02X%02X%02X", Color.convertComponent(this.r), Color.convertComponent(this.g), Color.convertComponent(this.b));
        }
        return String.format("#%02X%02X%02X%02X", Color.convertComponent(this.r), Color.convertComponent(this.g), Color.convertComponent(this.b), Color.convertComponent(this.a));
    }

    @NotNull
    public static Color valueOf(@NotNull String string) {
        Objects.requireNonNull(string, "Argument 'string'");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid color code syntax");
        }
        String alpha = matcher.group(4);
        int value = alpha != null ? Color.parseHexComponent(alpha) << 24 : -16777216;
        value |= Color.parseHexComponent(matcher.group(1)) << 16;
        value |= Color.parseHexComponent(matcher.group(2)) << 8;
        return new Color(value |= Color.parseHexComponent(matcher.group(3)));
    }

    @NotNull
    public static Color lerp(@NotNull Color a, @NotNull Color b, float delta) {
        Objects.requireNonNull(a, "Argument 'a'");
        Objects.requireNonNull(b, "Argument 'b'");
        return new Color(a.r + (b.r - a.r) * delta, a.g + (b.g - a.g) * delta, a.b + (b.b - a.b) * delta, a.a + (b.a - a.a) * delta);
    }

    private static int parseHexComponent(String input) {
        return Integer.parseUnsignedInt(input, 16);
    }

    private static int convertComponent(float component) {
        return Math.max(Math.min((int)(component * 255.0f), 255), 0);
    }
}

