/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeWrapper
implements IBiomeWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ConcurrentMap<class_6880<class_1959>, BiomeWrapper> WRAPPER_BY_BIOME = new ConcurrentHashMap<class_6880<class_1959>, BiomeWrapper>();
    public static final ConcurrentHashMap<String, BiomeWrapper> WRAPPER_BY_RESOURCE_LOCATION = new ConcurrentHashMap();
    public static final String EMPTY_BIOME_STRING = "EMPTY";
    public static final BiomeWrapper EMPTY_WRAPPER = new BiomeWrapper(null, null);
    public static final String PLAINS_RESOURCE_LOCATION_STRING = "minecraft:plains";
    private static final HashSet<String> brokenResourceLocationStrings = new HashSet();
    private static boolean emptyStringWarningLogged = false;
    private static boolean emptyLevelSerializeFailLogged = false;
    public final class_6880<class_1959> biome;
    private String serialString;
    private final int hashCode;

    public static IBiomeWrapper getBiomeWrapper(class_6880<class_1959> biome, ILevelWrapper levelWrapper) {
        if (biome == null) {
            return EMPTY_WRAPPER;
        }
        if (WRAPPER_BY_BIOME.containsKey(biome)) {
            return (IBiomeWrapper)WRAPPER_BY_BIOME.get(biome);
        }
        BiomeWrapper newWrapper = new BiomeWrapper(biome, levelWrapper);
        WRAPPER_BY_BIOME.put(biome, newWrapper);
        return newWrapper;
    }

    private BiomeWrapper(class_6880<class_1959> biome, ILevelWrapper levelWrapper) {
        this.biome = biome;
        this.serialString = this.serialize(levelWrapper);
        this.hashCode = Objects.hash(this.serialString);
    }

    @Override
    public String getName() {
        if (this == EMPTY_WRAPPER) {
            return EMPTY_BIOME_STRING;
        }
        return this.biome.method_40230().orElse(class_1972.field_9473).method_41185().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BiomeWrapper that = (BiomeWrapper)obj;
        return Objects.equals(this.getSerialString(), that.getSerialString());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getSerialString() {
        return this.serialString;
    }

    @Override
    public Object getWrappedMcObject() {
        return this.biome;
    }

    public String toString() {
        return this.getSerialString();
    }

    public String serialize(ILevelWrapper levelWrapper) {
        if (this.biome == null) {
            return EMPTY_BIOME_STRING;
        }
        if (levelWrapper == null) {
            if (!emptyLevelSerializeFailLogged) {
                emptyLevelSerializeFailLogged = true;
                LOGGER.warn("Unable to serialize biome: [" + String.valueOf(this.biome) + "] because the passed in level wrapper is null. Future errors of this type won't be logged.");
            }
            return EMPTY_BIOME_STRING;
        }
        class_1937 level = (class_1937)levelWrapper.getWrappedMcObject();
        class_5455 registryAccess = level.method_30349();
        class_2960 resourceLocation = registryAccess.method_30530(class_7924.field_41236).method_10221((Object)((class_1959)this.biome.comp_349()));
        if (resourceLocation == null) {
            String biomeName = ((class_1959)this.biome.comp_349()).toString();
            LOGGER.warn("unable to serialize: " + biomeName);
            this.serialString = "";
        } else {
            this.serialString = resourceLocation.method_12836() + ":" + resourceLocation.method_12832();
        }
        return this.serialString;
    }

    public static IBiomeWrapper deserialize(String resourceLocationString, ILevelWrapper levelWrapper) throws IOException {
        String finalResourceStateString = resourceLocationString;
        if (resourceLocationString.equals(EMPTY_BIOME_STRING)) {
            if (!emptyStringWarningLogged) {
                emptyStringWarningLogged = true;
                LOGGER.warn("[EMPTY] biome string deserialized. This may mean the level was null when a save was attempted, a file saving error, or a biome saving error. Future errors will not be logged.");
            }
            return EMPTY_WRAPPER;
        }
        if (resourceLocationString.trim().isEmpty() || resourceLocationString.equals("")) {
            LOGGER.warn("Null biome string deserialized.");
            return EMPTY_WRAPPER;
        }
        if (WRAPPER_BY_RESOURCE_LOCATION.containsKey(finalResourceStateString)) {
            return WRAPPER_BY_RESOURCE_LOCATION.get(finalResourceStateString);
        }
        BiomeWrapper foundWrapper = EMPTY_WRAPPER;
        try {
            class_1937 level = (class_1937)levelWrapper.getWrappedMcObject();
            class_5455 registryAccess = level.method_30349();
            BiomeDeserializeResult deserializeResult = BiomeWrapper.deserializeBiome(resourceLocationString, registryAccess);
            if (!deserializeResult.success) {
                if (!brokenResourceLocationStrings.contains(resourceLocationString)) {
                    brokenResourceLocationStrings.add(resourceLocationString);
                    LOGGER.warn("Unable to deserialize biome from string: [" + resourceLocationString + "]");
                }
                BiomeWrapper biomeWrapper = EMPTY_WRAPPER;
                return biomeWrapper;
            }
            BiomeWrapper biomeWrapper = foundWrapper = (BiomeWrapper)BiomeWrapper.getBiomeWrapper(deserializeResult.biome, levelWrapper);
            return biomeWrapper;
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize the string [" + finalResourceStateString + "] into a BiomeWrapper: " + e.getMessage(), e);
        }
        finally {
            WRAPPER_BY_RESOURCE_LOCATION.putIfAbsent(finalResourceStateString, foundWrapper);
        }
    }

    public static BiomeDeserializeResult deserializeBiome(String resourceLocationString, class_5455 registryAccess) throws IOException {
        class_2960 resourceLocation;
        int separatorIndex = resourceLocationString.indexOf(":");
        if (separatorIndex == -1) {
            throw new IOException("Unable to parse resource location string: [" + resourceLocationString + "].");
        }
        try {
            resourceLocation = new class_2960(resourceLocationString.substring(0, separatorIndex), resourceLocationString.substring(separatorIndex + 1));
        }
        catch (Exception e) {
            throw new IOException("No Resource Location found for the string: [" + resourceLocationString + "] Error: [" + e.getMessage() + "].");
        }
        class_1959 unwrappedBiome = (class_1959)registryAccess.method_30530(class_7924.field_41236).method_10223(resourceLocation);
        boolean success = unwrappedBiome != null;
        class_6880.class_6881 biome = new class_6880.class_6881((Object)unwrappedBiome);
        return new BiomeDeserializeResult(success, (class_6880<class_1959>)biome);
    }

    public static class BiomeDeserializeResult {
        public final boolean success;
        public final class_6880<class_1959> biome;

        public BiomeDeserializeResult(boolean success, class_6880<class_1959> biome) {
            this.success = success;
            this.biome = biome;
        }
    }
}

