/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.command;

import com.majruszlibrary.command.CommandBuilder;
import com.majruszlibrary.command.CommandData;
import com.majruszlibrary.command.IParameter;
import com.majruszlibrary.math.Range;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class Command {
    public static CommandBuilder create() {
        return new CommandBuilder();
    }

    private Command() {
    }

    public static IParameter.Named<Integer> integer() {
        return Command.integer(null);
    }

    public static IParameter.Named<Integer> integer(Range<Integer> range) {
        IParameter.Named parameter = new IParameter.Named();
        IntegerArgumentType argument = range == null ? IntegerArgumentType.integer() : (range.to == null ? IntegerArgumentType.integer((int)((Integer)range.from)) : IntegerArgumentType.integer((int)((Integer)range.from), (int)((Integer)range.to)));
        return parameter.applier(builder -> builder.addArgument(() -> Commands.m_82129_((String)parameter.name, (ArgumentType)argument))).getter(context -> (Integer)context.getArgument(parameter.name, Integer.class)).named("value");
    }

    public static IParameter.Named<Float> number() {
        return Command.number(null);
    }

    public static IParameter.Named<Float> number(Range<Float> range) {
        IParameter.Named parameter = new IParameter.Named();
        FloatArgumentType argument = range == null ? FloatArgumentType.floatArg() : (range.to == null ? FloatArgumentType.floatArg((float)((Float)range.from).floatValue()) : FloatArgumentType.floatArg((float)((Float)range.from).floatValue(), (float)((Float)range.to).floatValue()));
        return parameter.applier(builder -> builder.addArgument(() -> Commands.m_82129_((String)parameter.name, (ArgumentType)argument))).getter(context -> (Float)context.getArgument(parameter.name, Float.class)).named("value");
    }

    public static IParameter.Named<Boolean> bool() {
        IParameter.Named parameter = new IParameter.Named();
        return parameter.applier(builder -> builder.addArgument(() -> Commands.m_82129_((String)parameter.name, (ArgumentType)BoolArgumentType.bool()))).getter(context -> (Boolean)context.getArgument(parameter.name, Boolean.TYPE)).named("value");
    }

    public static IParameter.Hinted<String> string() {
        IParameter.Hinted<String> parameter = new IParameter.Hinted<String>();
        parameter.applier(builder -> builder.addArgument(() -> Commands.m_82129_((String)parameter.name, (ArgumentType)StringArgumentType.string()).suggests((context, subbuilder) -> SharedSuggestionProvider.m_82970_((Iterable)parameter.suggestions.get(), (SuggestionsBuilder)subbuilder)))).getter(context -> (String)context.getArgument(parameter.name, String.class)).named("value");
        return parameter;
    }

    public static IParameter.Hinted<ResourceLocation> resource() {
        IParameter.Hinted<ResourceLocation> parameter = new IParameter.Hinted<ResourceLocation>();
        parameter.applier(builder -> builder.addArgument(() -> Commands.m_82129_((String)parameter.name, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((context, subbuilder) -> SharedSuggestionProvider.m_82926_((Iterable)parameter.suggestions.get(), (SuggestionsBuilder)subbuilder)))).getter(context -> (ResourceLocation)context.getArgument(parameter.name, ResourceLocation.class)).named("value");
        return parameter;
    }

    public static <EnumType extends Enum<EnumType>> IParameter.Named<EnumType> enumeration(Supplier<EnumType[]> values) {
        IParameter.Named parameter = new IParameter.Named();
        return parameter.applier(builder -> builder.addArgument(() -> Command.lambda$enumeration$18(parameter, (Supplier)values))).getter(context -> {
            String name = (String)context.getArgument(parameter.name, String.class);
            for (Enum value : (Enum[])values.get()) {
                if (!name.equals(value.name())) continue;
                return value;
            }
            throw new IllegalStateException();
        }).named("value");
    }

    public static IParameter.Named<Vec3> position() {
        IParameter.Named parameter = new IParameter.Named();
        return parameter.applier(builder -> builder.addArgument(() -> Commands.m_82129_((String)parameter.name, (ArgumentType)Vec3Argument.m_120841_()))).getter(context -> ((Coordinates)context.getArgument(parameter.name, Coordinates.class)).m_6955_((CommandSourceStack)context.getSource())).named("position");
    }

    public static IParameter.Named<List<? extends Entity>> entities() {
        IParameter.Named parameter = new IParameter.Named();
        return parameter.applier(builder -> builder.addArgument(() -> Commands.m_82129_((String)parameter.name, (ArgumentType)EntityArgument.m_91460_()))).getter(context -> {
            try {
                return ((EntitySelector)context.getArgument(parameter.name, EntitySelector.class)).m_121160_((CommandSourceStack)context.getSource());
            }
            catch (Throwable exception) {
                return null;
            }
        }).named("entities");
    }

    public static IParameter<List<Vec3>> anyPosition() {
        IParameter.Named parameter = new IParameter.Named();
        return parameter.applier(builder -> builder.add(List.of(subbuilder -> subbuilder.addArgument((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_())), subbuilder -> subbuilder.addArgument((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()))))).getter(context -> {
            ArrayList<Vec3> positions = new ArrayList<Vec3>();
            try {
                positions.add(((Coordinates)context.getArgument("position", Coordinates.class)).m_6955_((CommandSourceStack)context.getSource()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ((EntitySelector)context.getArgument("entities", EntitySelector.class)).m_121160_((CommandSourceStack)context.getSource()).forEach(entity -> positions.add(entity.m_20182_()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return positions;
        });
    }

    private static /* synthetic */ ArgumentBuilder lambda$enumeration$18(IParameter.Named parameter, Supplier values) {
        return Commands.m_82129_((String)parameter.name, (ArgumentType)StringArgumentType.string()).suggests((arg_0, arg_1) -> Command.lambda$enumeration$17((Supplier)values, arg_0, arg_1));
    }

    private static /* synthetic */ CompletableFuture lambda$enumeration$17(Supplier values, CommandContext context, SuggestionsBuilder subbuilder) throws CommandSyntaxException {
        return SharedSuggestionProvider.m_82970_(Arrays.stream((Enum[])values.get()).map(Enum::name).toList(), (SuggestionsBuilder)subbuilder);
    }

    public static class DefaultKeys {
        public static final String ENTITIES = "entities";
        public static final String VALUE = "value";
        public static final String POSITION = "position";
    }

    @FunctionalInterface
    public static interface IModification {
        public void apply(CommandBuilder var1);
    }

    @FunctionalInterface
    public static interface IExecutable {
        public int execute(CommandData var1) throws CommandSyntaxException;
    }
}

