/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.entity;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class EffectDef {
    public Supplier<? extends MobEffect> effect;
    public int amplifier;
    public float duration;

    public EffectDef(Supplier<? extends MobEffect> effect, int amplifier, float duration) {
        this.effect = effect;
        this.amplifier = amplifier;
        this.duration = duration;
    }

    public EffectDef() {
        this(() -> null, 0, 1.0f);
    }

    public MobEffectInstance toEffectInstance() {
        return new MobEffectInstance(this.effect.get(), TimeHelper.toTicks(this.duration), this.amplifier);
    }

    public MutableComponent toComponent() {
        Component effectName = this.effect.get().m_19482_();
        MutableComponent fullName = this.amplifier > 0 ? TextHelper.translatable("potion.withAmplifier", effectName.getString(), TextHelper.toRoman(this.amplifier + 1)) : TextHelper.literal(effectName.getString());
        return TextHelper.translatable("potion.withDuration", fullName.getString(), TextHelper.toEffectDuration(this.duration));
    }

    static {
        Serializables.get(EffectDef.class).define("id", Reader.optional(Reader.mobEffect()), s -> s.effect.get(), (s, v) -> {
            s.effect = () -> v;
        }).define("amplifier", Reader.integer(), s -> s.amplifier, (s, v) -> {
            s.amplifier = Range.of(0, 10).clamp((Integer)v);
        }).define("duration", Reader.number(), s -> Float.valueOf(s.duration), (s, v) -> {
            s.duration = Range.of(Float.valueOf(1.0f), Float.valueOf(1000.0f)).clamp((Float)v).floatValue();
        });
    }
}

