/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.item;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.registry.Registries;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentHelper {
    public static int getLevel(Supplier<? extends Enchantment> enchantment, ItemStack itemStack) {
        ResourceLocation enchantmentId = Registries.ENCHANTMENTS.getId(enchantment.get());
        for (EnchantmentDef enchantmentDef : EnchantmentHelper.read((ItemStack)itemStack).enchantments) {
            if (!enchantmentId.equals((Object)enchantmentDef.id)) continue;
            return enchantmentDef.level;
        }
        return 0;
    }

    public static int getLevel(Supplier<? extends Enchantment> enchantment, LivingEntity entity) {
        return net.minecraft.world.item.enchantment.EnchantmentHelper.m_44836_((Enchantment)enchantment.get(), (LivingEntity)entity);
    }

    public static int getLevelSum(Supplier<? extends Enchantment> enchantment, Iterable<ItemStack> itemStacks) {
        int sum = 0;
        for (ItemStack itemStack : itemStacks) {
            sum += EnchantmentHelper.getLevel(enchantment, itemStack);
        }
        return sum;
    }

    public static int getLevelSum(Supplier<? extends Enchantment> enchantment, LivingEntity entity) {
        int sum = 0;
        for (ItemStack itemStack : enchantment.get().m_44684_(entity).values()) {
            sum += EnchantmentHelper.getLevel(enchantment, itemStack);
        }
        return sum;
    }

    public static int getLevelSum(Supplier<? extends Enchantment> enchantment, LivingEntity entity, Iterable<EquipmentSlot> slots) {
        int sum = 0;
        for (EquipmentSlot slot : slots) {
            sum += EnchantmentHelper.getLevel(enchantment, entity.m_6844_(slot));
        }
        return sum;
    }

    public static boolean has(Supplier<? extends Enchantment> enchantment, ItemStack itemStack) {
        return EnchantmentHelper.getLevel(enchantment, itemStack) > 0;
    }

    public static boolean has(Supplier<? extends Enchantment> enchantment, LivingEntity entity) {
        return EnchantmentHelper.getLevel(enchantment, entity) > 0;
    }

    public static boolean increaseLevel(Supplier<? extends Enchantment> enchantment, ItemStack itemStack) {
        ResourceLocation id = Registries.ENCHANTMENTS.getId(enchantment.get());
        EnchantmentsDef enchantmentsDef = EnchantmentHelper.read(itemStack);
        for (EnchantmentDef enchantmentDef : enchantmentsDef.enchantments) {
            if (!id.equals((Object)enchantmentDef.id)) continue;
            if (enchantmentDef.level >= enchantment.get().m_6586_()) {
                return false;
            }
            ++enchantmentDef.level;
            Serializables.write(enchantmentsDef, itemStack.m_41784_());
            return true;
        }
        enchantmentsDef.enchantments.add(new EnchantmentDef(id, 1));
        Serializables.write(enchantmentsDef, itemStack.m_41784_());
        return true;
    }

    public static boolean remove(Supplier<? extends Enchantment> enchantment, ItemStack itemStack) {
        ResourceLocation id = Registries.ENCHANTMENTS.getId(enchantment.get());
        EnchantmentsDef enchantmentsDef = EnchantmentHelper.read(itemStack);
        for (int idx = 0; idx < enchantmentsDef.enchantments.size(); ++idx) {
            if (!id.equals((Object)enchantmentsDef.enchantments.get((int)idx).id)) continue;
            enchantmentsDef.enchantments.remove(idx);
            Serializables.write(enchantmentsDef, itemStack.m_41783_());
            return true;
        }
        return false;
    }

    public static EnchantmentsDef read(ItemStack itemStack) {
        EnchantmentsDef enchantmentsDef = new EnchantmentsDef();
        CompoundTag tag = itemStack.m_41783_();
        return tag != null ? Serializables.read(enchantmentsDef, (Tag)tag) : enchantmentsDef;
    }

    public static class EnchantmentsDef {
        public List<EnchantmentDef> enchantments = new ArrayList<EnchantmentDef>();

        static {
            Serializables.get(EnchantmentsDef.class).define("Enchantments", Reader.list(Reader.custom(EnchantmentDef::new)), s -> s.enchantments, (s, v) -> {
                s.enchantments = v;
            });
        }
    }

    public static class EnchantmentDef {
        public ResourceLocation id;
        public int level;

        public EnchantmentDef(ResourceLocation id, int level) {
            this.id = id;
            this.level = level;
        }

        public EnchantmentDef() {
        }

        static {
            Serializables.get(EnchantmentDef.class).define("id", Reader.location(), s -> s.id, (s, v) -> {
                s.id = v;
            }).define("lvl", Reader.integer(), s -> s.level, (s, v) -> {
                s.level = v;
            });
        }
    }
}

