/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.mixin;

import com.majruszlibrary.events.OnEntityDamageBlocked;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.OnEntityEffectCheck;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnEntitySwimSpeedMultiplierGet;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.OnItemEaten;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.OnItemSwingDurationGet;
import com.majruszlibrary.events.OnItemUseTicked;
import com.majruszlibrary.events.OnLootingLevelGet;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.mixininterfaces.IMixinLivingEntity;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LivingEntity.class}, priority=1100)
public abstract class MixinLivingEntity
implements IMixinLivingEntity {
    @Shadow
    private int f_20936_;
    float majruszlibrary$lastDamage = 0.0f;
    float majruszlibrary$swimSpeedMultiplier = 1.0f;

    @Override
    public float majruszlibrary$getSwimSpeedMultiplier() {
        return this.majruszlibrary$swimSpeedMultiplier;
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"hurt (Lnet/minecraft/world/damagesource/DamageSource;F)Z"})
    private void hurt(DamageSource source, float damage, CallbackInfoReturnable<Boolean> callback) {
        this.majruszlibrary$lastDamage = damage;
        LivingEntity entity = (LivingEntity)this;
        if (MixinLivingEntity.majruszlibrary$willBeCancelled(source, entity)) {
            return;
        }
        if (damage == 0.0f || entity.m_21275_(source)) {
            Events.dispatch(new OnEntityDamageBlocked(source, entity));
            return;
        }
        OnEntityPreDamaged data = Events.dispatch(new OnEntityPreDamaged(source, entity, damage));
        if (data.isDamageCancelled()) {
            data.target.f_19802_ = 20;
            callback.setReturnValue((Object)false);
        } else {
            this.majruszlibrary$lastDamage = data.damage;
            MixinLivingEntity.majruszlibrary$tryToAddMagicParticles(data);
        }
    }

    @ModifyVariable(at=@At(shift=At.Shift.AFTER, value="HEAD"), method={"hurt (Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, ordinal=0)
    private float replacePreDamage(float damage) {
        return this.majruszlibrary$lastDamage;
    }

    @Inject(at={@At(target="Lnet/minecraft/world/damagesource/CombatTracker;recordDamage (Lnet/minecraft/world/damagesource/DamageSource;F)V", shift=At.Shift.BEFORE, value="INVOKE")}, method={"actuallyHurt (Lnet/minecraft/world/damagesource/DamageSource;F)V"})
    private void actuallyHurt(DamageSource source, float damage, CallbackInfo callback) {
        Events.dispatch(new OnEntityDamaged(source, (LivingEntity)this, damage));
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"die (Lnet/minecraft/world/damagesource/DamageSource;)V"})
    private void die(DamageSource source, CallbackInfo callback) {
        if (Events.dispatch(new OnEntityDied(source, (LivingEntity)this)).isDeathCancelled()) {
            callback.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"canBeAffected (Lnet/minecraft/world/effect/MobEffectInstance;)Z"})
    private void canBeAffected(MobEffectInstance effect, CallbackInfoReturnable<Boolean> callback) {
        if (Events.dispatch(new OnEntityEffectCheck(effect, (LivingEntity)this)).isEffectCancelled()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick ()V"})
    private void tick(CallbackInfo callback) {
        Events.dispatch(new OnEntityTicked((LivingEntity)this));
        this.majruszlibrary$swimSpeedMultiplier = Events.dispatch(new OnEntitySwimSpeedMultiplierGet((LivingEntity)this, 1.0f)).getMultiplier();
    }

    @Inject(at={@At(target="Lnet/minecraft/world/entity/LivingEntity;equipmentHasChanged (Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z", value="INVOKE")}, locals=LocalCapture.CAPTURE_FAILHARD, method={"collectEquipmentChanges ()Ljava/util/Map;"})
    private void collectEquipmentChanges(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> callback, Map<EquipmentSlot, ItemStack> map, EquipmentSlot[] slots, int slotsCount, int idx, EquipmentSlot slot, ItemStack from, ItemStack to) {
        if (!ItemStack.m_41728_((ItemStack)from, (ItemStack)to)) {
            Events.dispatch(new OnItemEquipped((LivingEntity)this, slot, from, to));
        }
    }

    @Inject(at={@At(value="RETURN")}, cancellable=true, method={"getCurrentSwingDuration ()I"})
    private void getCurrentSwingDuration(CallbackInfoReturnable<Integer> callback) {
        callback.setReturnValue((Object)Events.dispatch(new OnItemSwingDurationGet((LivingEntity)this, (Integer)callback.getReturnValue())).getSwingDuration());
    }

    @Inject(at={@At(value="HEAD")}, method={"updateUsingItem (Lnet/minecraft/world/item/ItemStack;)V"})
    private void updateUsingItem(ItemStack itemStack, CallbackInfo callback) {
        OnItemUseTicked data = Events.dispatch(new OnItemUseTicked((LivingEntity)this, itemStack, itemStack.m_41779_(), this.f_20936_));
        this.f_20936_ = data.getDuration();
    }

    @Inject(at={@At(value="HEAD")}, method={"dropAllDeathLoot (Lnet/minecraft/world/damagesource/DamageSource;)V"})
    private void dropAllDeathLoot(DamageSource source, CallbackInfo callback) {
        OnLootingLevelGet.Cache.SOURCE = source;
    }

    @Inject(at={@At(value="HEAD")}, method={"eat (Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"})
    private void eat(Level level, ItemStack itemStack, CallbackInfoReturnable<ItemStack> callback) {
        Events.dispatch(new OnItemEaten((LivingEntity)this, itemStack));
    }

    private static void majruszlibrary$tryToAddMagicParticles(OnEntityPreDamaged data) {
        LivingEntity livingEntity = data.attacker;
        if (livingEntity instanceof Player) {
            MobType type;
            Player player = (Player)livingEntity;
            Entity entity = data.source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                v0 = entity2.m_6336_();
            } else {
                v0 = type = MobType.f_21640_;
            }
            if (EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)type) > 0.0f) {
                return;
            }
            if (data.spawnCriticalParticles) {
                player.m_5704_((Entity)data.target);
            }
            if (data.spawnMagicParticles) {
                player.m_5700_((Entity)data.target);
            }
        }
    }

    private static boolean majruszlibrary$willBeCancelled(DamageSource source, LivingEntity target) {
        boolean isInvulnerable = target.m_6673_(source);
        boolean isClientSide = !(target.m_9236_() instanceof ServerLevel);
        boolean isDeadOrDying = target.m_21224_();
        boolean isFireResistant = source.m_269533_(DamageTypeTags.f_268745_) && target.m_21023_(MobEffects.f_19607_);
        return isInvulnerable || isClientSide || isDeadOrDying || isFireResistant;
    }
}

