/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.core.mixin;

import com.teamabnormals.allurement.core.AllurementConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ChiseledBookShelfBlock.class})
public abstract class ChiseledBookShelfBlockMixin
extends Block {
    public ChiseledBookShelfBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)AllurementConfig.COMMON.chiseledBookshelfEnchanting.get()).booleanValue()) {
            if (!level.m_5776_()) {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
                    ChiseledBookShelfBlockEntity blockEntity2 = (ChiseledBookShelfBlockEntity)blockEntity;
                    int books = 0;
                    int enchantedBooks = 0;
                    for (int i = 0; i < blockEntity2.m_6643_(); ++i) {
                        ItemStack stack = blockEntity2.m_8020_(i);
                        if (stack.m_150930_(Items.f_42690_)) {
                            ++enchantedBooks;
                            continue;
                        }
                        if (!stack.m_204117_(ItemTags.f_244646_)) continue;
                        ++books;
                    }
                    return (float)books / (float)((Integer)AllurementConfig.COMMON.booksNeededPerLevel.get()).intValue() + (float)enchantedBooks / (float)((Integer)AllurementConfig.COMMON.enchantedBooksNeededPerLevel.get()).intValue();
                }
            } else {
                int count = 0;
                for (BooleanProperty property : ChiseledBookShelfBlock.f_260698_) {
                    if (!((Boolean)state.m_61143_((Property)property)).booleanValue()) continue;
                    ++count;
                }
                if (count > 0) {
                    return (float)count / 3.0f;
                }
            }
        }
        return super.getEnchantPowerBonus(state, level, pos);
    }
}

