/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.microopt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import me.steinborn.krypton.mod.shared.network.util.VarIntUtil;
import me.steinborn.krypton.mod.shared.network.util.VarLongUtil;
import net.minecraft.network.FriendlyByteBuf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FriendlyByteBuf.class}, priority=900)
public abstract class FriendlyByteBufMixin
extends ByteBuf {
    @Shadow
    @Final
    private ByteBuf f_130049_;

    @Overwrite
    public static int m_130053_(int v) {
        return VarIntUtil.getVarIntLength(v);
    }

    @Overwrite
    public static int m_178339_(long data) {
        return VarLongUtil.getVarLongLength(data);
    }

    @Overwrite
    public FriendlyByteBuf m_130072_(String string, int maxLength) {
        if (string.length() > maxLength) {
            throw new EncoderException("String too big (was " + string.length() + " characters, max " + maxLength + ")");
        }
        int utf8Bytes = ByteBufUtil.utf8Bytes((CharSequence)string);
        if (utf8Bytes > maxLength * 3) {
            throw new EncoderException("String too big (was " + utf8Bytes + " bytes encoded, max " + maxLength * 3 + ")");
        }
        this.m_130130_(utf8Bytes);
        this.writeCharSequence(string, StandardCharsets.UTF_8);
        return (FriendlyByteBuf)this;
    }

    @Overwrite
    public FriendlyByteBuf m_130130_(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            this.f_130049_.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            this.f_130049_.writeShort((value & 0x7F | 0x80) << 8 | value >>> 7);
        } else if ((value & 0xFFE00000) == 0) {
            this.f_130049_.writeMedium((value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14);
        } else if ((value & 0xF0000000) == 0) {
            this.f_130049_.writeInt((value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21);
        } else {
            this.f_130049_.writeInt((value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80));
            this.f_130049_.writeByte(value >>> 28);
        }
        return (FriendlyByteBuf)this;
    }

    @Overwrite
    public FriendlyByteBuf m_130103_(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.f_130049_.writeByte((int)value);
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            this.f_130049_.writeShort((int)(value & 0x7FL | 0x80L) << 8 | (int)(value >>> 7));
        } else {
            VarLongUtil.writeVarLongFull(this, value);
        }
        return (FriendlyByteBuf)this;
    }
}

