/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.constraints;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.spaceeye.elementa.UIComponent;
import net.spaceeye.elementa.components.Window;
import net.spaceeye.elementa.constraints.ColorConstraint;
import net.spaceeye.elementa.constraints.ConstraintType;
import net.spaceeye.elementa.constraints.resolution.ConstraintVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u0012\b\b\u0002\u0010,\u001a\u00020\"\u00a2\u0006\u0004\b/\u00100J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R*\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00040\u00048\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u0004\u0018\u00010\u00028\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\"\u0010&\u001a\u00020%8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0017\u0010,\u001a\u00020\"8\u0006\u00a2\u0006\f\n\u0004\b,\u0010$\u001a\u0004\b-\u0010.\u00a8\u00061"}, d2={"Lnet/spaceeye/elementa/constraints/RainbowColorConstraint;", "Lnet/spaceeye/elementa/constraints/ColorConstraint;", "Lnet/spaceeye/elementa/UIComponent;", "component", "Ljava/awt/Color;", "getColorImpl", "(Lnet/spaceeye/elementa/UIComponent;)Ljava/awt/Color;", "to", "(Lnet/spaceeye/elementa/UIComponent;)Lnet/spaceeye/elementa/constraints/RainbowColorConstraint;", "Lnet/spaceeye/elementa/constraints/resolution/ConstraintVisitor;", "visitor", "Lnet/spaceeye/elementa/constraints/ConstraintType;", "type", "", "visitImpl", "(Lnet/spaceeye/elementa/constraints/resolution/ConstraintVisitor;Lnet/spaceeye/elementa/constraints/ConstraintType;)V", "", "alpha", "I", "getAlpha", "()I", "kotlin.jvm.PlatformType", "cachedValue", "Ljava/awt/Color;", "getCachedValue", "()Ljava/awt/Color;", "setCachedValue", "(Ljava/awt/Color;)V", "constrainTo", "Lnet/spaceeye/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "", "randomOffset", "F", "", "recalculate", "Z", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "speed", "getSpeed", "()F", "<init>", "(IF)V", "Elementa"})
public final class RainbowColorConstraint
implements ColorConstraint {
    private final int alpha;
    private final float speed;
    private Color cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;
    private final float randomOffset;

    public RainbowColorConstraint(int alpha, float speed) {
        this.alpha = alpha;
        this.speed = speed;
        this.cachedValue = Color.WHITE;
        this.recalculate = true;
        this.randomOffset = Random.Default.nextInt(500);
    }

    public /* synthetic */ RainbowColorConstraint(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 255;
        }
        if ((n2 & 2) != 0) {
            f = 50.0f;
        }
        this(n, f);
    }

    public final int getAlpha() {
        return this.alpha;
    }

    public final float getSpeed() {
        return this.speed;
    }

    @Override
    public Color getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Color color) {
        this.cachedValue = color;
    }

    @Override
    public boolean getRecalculate() {
        return this.recalculate;
    }

    @Override
    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Override
    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    @Override
    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    @Override
    @NotNull
    public Color getColorImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Window window = Window.Companion.ofOrNull(component2);
        float currentStep = this.randomOffset + (float)(window != null ? window.getAnimationTimeMs() : 0L) * ((float)244 / 1000.0f);
        int red = (int)((Math.sin(currentStep / this.speed) + 0.75) * (double)170);
        int green = (int)((Math.sin((double)(currentStep / this.speed) + (double)2 * Math.PI / (double)3) + 0.75) * (double)170);
        int blue = (int)((Math.sin((double)(currentStep / this.speed) + (double)4 * Math.PI / (double)3) + 0.75) * (double)170);
        return new Color(RangesKt.coerceIn((int)red, (int)0, (int)255), RangesKt.coerceIn((int)green, (int)0, (int)255), RangesKt.coerceIn((int)blue, (int)0, (int)255), RangesKt.coerceIn((int)this.alpha, (int)0, (int)255));
    }

    @NotNull
    public RainbowColorConstraint to(@NotNull UIComponent component2) {
        RainbowColorConstraint rainbowColorConstraint;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        RainbowColorConstraint $this$to_u24lambda_u240 = rainbowColorConstraint = this;
        boolean bl = false;
        throw new UnsupportedOperationException("Constraint.to(UIComponent) is not available in this context!");
    }

    @Override
    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    public RainbowColorConstraint() {
        this(0, 0.0f, 3, null);
    }
}

